/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.core.agile.AgileFactory;
import org.eclipse.osee.ats.ide.agile.SprintItems;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingPreComputedColumn;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.world.IAtsWorldArtifactEventColumn;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class AgileFeatureGroupColumn
extends BackgroundLoadingPreComputedColumn
implements IAtsWorldArtifactEventColumn,
IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static AgileFeatureGroupColumn instance = new AgileFeatureGroupColumn();
    private boolean preloaded = false;

    public static AgileFeatureGroupColumn getInstance() {
        return instance;
    }

    private AgileFeatureGroupColumn() {
        super("ats.column.agileFeatureGroup", "Feature Group", 40, XViewerAlign.Left, false, SortDataType.String, true, "Agile Feature Group for this Item.");
    }

    public AgileFeatureGroupColumn copy() {
        AgileFeatureGroupColumn newXCol = new AgileFeatureGroupColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        try {
            Collection featureArts = AtsApiService.get().getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup);
            HashSet<String> strs = new HashSet<String>();
            for (ArtifactToken featureArt : featureArts) {
                strs.add(featureArt.getName());
            }
            return Collections.toString((String)", ", strs);
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
    }

    @Override
    public void handlePreLoadingTasks(Collection<?> objects) {
        if (!this.preloaded) {
            List arts = Collections.castAll(objects);
            AtsBulkLoad.bulkLoadArtifacts(arts);
            this.preloaded = true;
        }
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            if (treeItem.getData() instanceof AbstractWorkflowArtifact) {
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)((Object)treeItem.getData());
                boolean modified = AgileFeatureGroupColumn.promptChangeFeatureGroup(Arrays.asList(awa));
                if (modified) {
                    awa.persist("persist goals via alt-left-click");
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static boolean promptChangeFeatureGroup(Collection<? extends AbstractWorkflowArtifact> awas) {
        SprintItems items = new SprintItems(awas);
        if (items.isNoBacklogDetected()) {
            AWorkbench.popup((String)"Workflow(s) must belong to a Backlog to set their Feature Group.");
            return false;
        }
        if (items.isMultipleBacklogsDetected()) {
            AWorkbench.popup((String)"All workflows must belong to same Backlog.");
            return false;
        }
        AgileEndpointApi agileEp = AtsApiService.get().getServerEndpoints().getAgileEndpoint();
        if (items.getCommonBacklog() == null) {
            return false;
        }
        long teamId = items.getCommonBacklog().getTeamId();
        FilteredCheckboxTreeDialog<JaxAgileFeatureGroup> dialog = AgileFeatureGroupColumn.openSelectionDialog(teamId, awas);
        JaxAgileItem updateItem = new JaxAgileItem();
        if (dialog == null) {
            return false;
        }
        if (dialog.getResult().length == 0) {
            updateItem.setRemoveFeatures(true);
        } else {
            updateItem.setSetFeatures(true);
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                updateItem.getFeatures().add(((JaxAgileFeatureGroup)object).getId());
                ++n2;
            }
        }
        for (AbstractWorkflowArtifact abstractWorkflowArtifact : awas) {
            updateItem.getIds().add(abstractWorkflowArtifact.getId());
        }
        try {
            agileEp.updateAgileItem(teamId, updateItem);
            ArtifactQuery.reloadArtifacts(awas);
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)exception);
        }
        return true;
    }

    public static FilteredCheckboxTreeDialog<JaxAgileFeatureGroup> openSelectionDialog(long teamId, Collection<? extends AbstractWorkflowArtifact> awas) {
        AtsConfigurations configurations = AtsApiService.get().getConfigService().getConfigurations();
        ArrayList<JaxAgileFeatureGroup> activeFeatureGroups = new ArrayList<JaxAgileFeatureGroup>();
        for (Map.Entry entry : configurations.getFeatureToAgileTeam().entrySet()) {
            JaxAgileFeatureGroup feature;
            Long featureId = (Long)entry.getKey();
            Long agileTeamId = (Long)entry.getValue();
            if (!agileTeamId.equals(teamId) || !(feature = (JaxAgileFeatureGroup)configurations.getIdToAgileFeature().get(featureId)).isActive()) continue;
            activeFeatureGroups.add(feature);
        }
        FilteredCheckboxTreeDialog dialog = new FilteredCheckboxTreeDialog("Select Feature Group(s)", "Select Feature Group(s)", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider(), (ViewerComparator)new StringNameComparator());
        dialog.setInput(activeFeatureGroups);
        Collection<JaxAgileFeatureGroup> selectedFeatureGroups = AgileFeatureGroupColumn.getSelectedFeatureGroups(awas);
        if (!selectedFeatureGroups.isEmpty()) {
            dialog.setInitialSelections(selectedFeatureGroups);
        }
        dialog.setShowSelectButtons(true);
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        return dialog;
    }

    private static Collection<JaxAgileFeatureGroup> getSelectedFeatureGroups(Collection<? extends AbstractWorkflowArtifact> awas) {
        LinkedList<JaxAgileFeatureGroup> selected = new LinkedList<JaxAgileFeatureGroup>();
        if (awas.size() == 1) {
            for (Artifact featureArt : awas.iterator().next().getRelatedArtifacts(AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
                IAgileFeatureGroup featureGroup = AtsApiService.get().getAgileService().getAgileFeatureGroup((ArtifactId)featureArt);
                if (!featureGroup.isActive()) continue;
                selected.add(AgileFactory.createJaxAgileFeatureGroup((IAgileFeatureGroup)featureGroup));
            }
        }
        return selected;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
            ArrayList<Artifact> arts = new ArrayList<Artifact>();
            for (TreeItem item : treeItems) {
                Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                if (art == null || !art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) continue;
                awas.add((AbstractWorkflowArtifact)art);
                arts.add(art);
            }
            AgileFeatureGroupColumn.promptChangeFeatureGroup(awas);
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }

    @Override
    public void handleArtifactEvent(ArtifactEvent artifactEvent, WorldXViewer xViewer) {
        if (!Widgets.isAccessible((Widget)xViewer.getTree())) {
            return;
        }
        for (EventBasicGuidArtifact guidArt : artifactEvent.get(new EventModType[]{EventModType.Reloaded})) {
            Artifact workflow = ArtifactCache.getActive((DefaultBasicGuidArtifact)guidArt);
            if (workflow == null || !workflow.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) continue;
            IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)workflow);
            String newValue = this.getValue(workItem, this.preComputedValueMap);
            this.preComputedValueMap.put(workflow.getId(), newValue);
            xViewer.update(workflow, null);
        }
    }

    @Override
    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, WorldXViewer xViewer) {
        if (!Widgets.isAccessible((Widget)xViewer.getTree())) {
            return;
        }
        for (EventTopicArtifactTransfer topicArt : artifactTopicEvent.getTransfer(new EventModType[]{EventModType.Reloaded})) {
            Artifact workflow = ArtifactCache.getActive((ArtifactToken)topicArt.getArtifactToken());
            if (workflow == null || !workflow.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) continue;
            IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)workflow);
            String newValue = this.getValue(workItem, this.preComputedValueMap);
            this.preComputedValueMap.put(workflow.getId(), newValue);
            xViewer.update(workflow, null);
        }
    }
}

