/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.newaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.actions.wizard.IAtsWizardItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelActionableItemSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkChangeTypeSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkPrioritySelection;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;

public class CreateNewActionBlam
extends AbstractBlam
implements INewActionListener {
    protected static final String BLAM_DESCRIPTION = "Select options to create new ATS Action";
    protected static final String TITLE = "Title";
    protected static final String PROGRAM = "Program";
    protected static final String DESCRIPTION = "Description";
    protected static final String CHANGE_TYPE = "Change Type";
    protected static final String PRIORITY = "Priority";
    protected static final String NEED_BY = "Need By";
    protected XText titleWidget;
    protected XText descWidget;
    protected XHyperlinkChangeTypeSelection changeTypeWidget;
    protected XHyperlinkPrioritySelection priorityWidget;
    protected XHyperlabelActionableItemSelection aiWidget;
    protected final AtsApi atsApi;
    protected XWidgetBuilder wb;
    private ActionResult actionResult;
    private XWidgetPage page;
    private Composite teamComp;
    private static Set<IAtsWizardItem> wizardExtensionItems = new HashSet<IAtsWizardItem>();
    private final Set<IAtsWizardItem> handledExtensionItems = new HashSet<IAtsWizardItem>();
    private IManagedForm form;
    private Section section;
    private Composite comp;
    private XWidgetPage widgetPage;

    public CreateNewActionBlam() {
        this("Create New Action", BLAM_DESCRIPTION);
    }

    public CreateNewActionBlam(String name, String desc) {
        super(name, desc, null);
        this.atsApi = AtsApiService.get();
    }

    protected boolean isValidEntry() {
        return true;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        Priorities priority;
        ChangeTypes cType;
        String desc;
        this.variableMap = variableMap;
        boolean valid = true;
        String title = variableMap.getString(TITLE);
        if (Strings.isInValid((String)title)) {
            this.log(new String[]{"Enter Title"});
            valid = false;
        }
        if (Strings.isInValid((String)(desc = variableMap.getString(DESCRIPTION)))) {
            this.log(new String[]{"Enter Description"});
            valid = false;
        }
        if ((cType = (ChangeTypes)variableMap.getValue(CHANGE_TYPE)) == null || cType == ChangeTypes.None) {
            this.log(new String[]{"Invalid Change Type"});
        }
        if ((priority = (Priorities)variableMap.getValue(PRIORITY)) == null) {
            this.log(new String[]{"Select Priority"});
            valid = false;
        }
        Date needBy = (Date)variableMap.getValue(NEED_BY);
        Collection<IAtsActionableItem> actionableItems = this.aiWidget.getSelectedActionableItems();
        if (actionableItems.isEmpty()) {
            valid = false;
            this.log(new String[]{"Must select Actionable Item(s)"});
        }
        if (!this.isValidEntry() || !valid) {
            return;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getName());
        this.actionResult = this.atsApi.getActionService().createAction(this.atsApi.getUserService().getCurrentUser(), title, desc, cType, priority.getName(), false, needBy, actionableItems, new Date(), this.atsApi.getUserService().getCurrentUser(), Collections.singleton(this), changes);
        if (this.actionResult.getResults().isErrors()) {
            XResultDataUI.report((XResultData)this.actionResult.getResults(), (String)this.getTitle());
            return;
        }
        for (IAtsWizardItem wizardItem : this.handledExtensionItems) {
            wizardItem.wizardCompleted(this.actionResult, changes);
        }
        changes.execute();
        if (this.actionResult.getResults().isErrors()) {
            this.log(new String[]{this.actionResult.getResults().toString()});
            return;
        }
        Collection teamWfs = this.actionResult.getTeamWfs();
        if (teamWfs.size() == 1) {
            WorkflowEditor.edit((IAtsWorkItem)teamWfs.iterator().next());
        } else {
            WorldEditor.open(new WorldEditorSimpleProvider("New Action Workflows", AtsObjects.getArtifacts((Collection)teamWfs)));
        }
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        this.wb = new XWidgetBuilder();
        this.wb.andXText(TITLE).andRequired().endWidget();
        this.wb.andXHyperlinkActionableItemActive().andRequired().endWidget();
        this.wb.andXText((AttributeTypeToken)AtsAttributeTypes.Description).andHeight(80).andRequired().endWidget();
        this.addWidgetsAfterDescription(this.wb);
        this.wb.andChangeType(ChangeTypes.DEFAULT_CHANGE_TYPES).andRequired().endWidget();
        this.wb.andPriority().andRequired().endWidget();
        this.addWidgetAfterPriority();
        this.wb.andXHyperLinkDate(AtsAttributeTypes.NeedBy.getUnqualifiedName()).endComposite().endWidget();
        return this.wb.getItems();
    }

    protected void addWidgetsAfterDescription(XWidgetBuilder wb) {
    }

    public void createWidgets(Composite comp, IManagedForm form, Section section, XWidgetPage widgetPage) {
        this.comp = comp;
        this.form = form;
        this.section = section;
        this.widgetPage = widgetPage;
        this.teamComp = new Composite(comp, 0);
        this.teamComp.setLayout((Layout)new GridLayout(1, false));
        this.teamComp.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void updateTeamComposites() {
        try {
            boolean hasWizardXWidgetExtensions;
            this.teamComp.dispose();
            this.createWidgets(this.comp, this.form, this.section, this.widgetPage);
            this.handledExtensionItems.clear();
            this.getWizardXWidgetExtensions();
            ArrayList allWidgets = new ArrayList();
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append("<WorkPage>");
            IDynamicWidgetLayoutListener dynamicWidgetLayoutListener = null;
            for (IAtsWizardItem item : wizardExtensionItems) {
                hasWizardXWidgetExtensions = item.hasWizardXWidgetExtensions(this.aiWidget.getSelectedActionableItems());
                if (!hasWizardXWidgetExtensions) continue;
                stringBuffer.append("<XWidget displayName=\"--- Extra fields for " + item.getName() + " ---\" xwidgetType=\"XLabel\" horizontalLabel=\"true\" toolTip=\"These fields are available for only the team workflow specified here.\"/>");
                try {
                    if (item instanceof IDynamicWidgetLayoutListener) {
                        dynamicWidgetLayoutListener = (IDynamicWidgetLayoutListener)item;
                    }
                    item.getWizardXWidgetExtensions(this.aiWidget.getSelectedActionableItems(), stringBuffer);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
            stringBuffer.append("</WorkPage>");
            this.page = new XWidgetPage(stringBuffer.toString(), (IXWidgetOptionResolver)ATSXWidgetOptionResolver.getInstance(), dynamicWidgetLayoutListener);
            this.page.createBody(null, this.teamComp, null, null, true);
            allWidgets.addAll(this.page.getDynamicXWidgetLayout().getXWidgets());
            for (IAtsWizardItem item : wizardExtensionItems) {
                if (this.handledExtensionItems.contains(item) || !(hasWizardXWidgetExtensions = item.hasWizardXWidgetExtensions(this.aiWidget.getSelectedActionableItems()))) continue;
                item.getWizardXWidgetExtensions(this.aiWidget.getSelectedActionableItems(), this.teamComp);
                this.handledExtensionItems.add(item);
            }
            this.teamComp.getParent().layout(true, true);
            this.teamComp.getParent().getParent().layout(true, true);
            this.form.reflow(true);
            this.section.layout(true, true);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(TITLE)) {
            this.titleWidget = (XText)xWidget;
            this.titleWidget.getLabelWidget().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        CreateNewActionBlam.this.handlePopulateWithDebugInfo();
                    }
                }
            });
        } else if (xWidget.getLabel().equals(DESCRIPTION)) {
            this.descWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(CHANGE_TYPE)) {
            this.changeTypeWidget = (XHyperlinkChangeTypeSelection)xWidget;
            this.setChangeTypeWidget(this.changeTypeWidget);
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XHyperlinkPrioritySelection)xWidget;
        } else if (xWidget instanceof XHyperlabelActionableItemSelection) {
            this.aiWidget = (XHyperlabelActionableItemSelection)xWidget;
            this.aiWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    CreateNewActionBlam.this.updateTeamComposites();
                    Collection<IAtsActionableItem> ais = CreateNewActionBlam.this.aiWidget.getSelectedActionableItems();
                    if (!ais.isEmpty()) {
                        IAtsActionableItem ai = ais.iterator().next();
                        List changeTypeOptions = CreateNewActionBlam.this.atsApi.getWorkItemService().getChangeTypeOptions((IAtsObject)ai);
                        CreateNewActionBlam.this.changeTypeWidget.setSelectable(changeTypeOptions);
                        List priorityOptions = CreateNewActionBlam.this.atsApi.getWorkItemService().getPrioritiesOptions((IAtsObject)ai);
                        CreateNewActionBlam.this.priorityWidget.setSelectable(priorityOptions);
                    }
                }
            });
        }
    }

    private Collection<ChangeTypes> setChangeTypeWidget(XHyperlinkChangeTypeSelection changeWidget) {
        Collection<IAtsActionableItem> ais = this.aiWidget.getSelectedActionableItems();
        if (ais == null || ais.isEmpty()) {
            this.logf("Must Select Actionable Item(s) First", new Object[0]);
            return Collections.emptyList();
        }
        IAtsActionableItem ai = ais.iterator().next();
        List changeTypes = this.atsApi.getWorkItemService().getChangeTypeOptions((IAtsObject)ai);
        changeWidget.setSelectable(changeTypes);
        return changeTypes;
    }

    public void handlePopulateWithDebugInfo() {
        String title = "New Action " + this.atsApi.getRandomNum();
        this.handlePopulateWithDebugInfo(title);
    }

    public void handlePopulateWithDebugInfo(String title) {
        try {
            ArrayList<IAtsActionableItem> ais = new ArrayList<IAtsActionableItem>();
            for (IAtsActionableItem ai : this.atsApi.getConfigService().getConfigurations().getIdToAi().values()) {
                if (ai.getName().equals("ATS")) {
                    ais.add(ai);
                    continue;
                }
                if (ai.getName().equals("SAW Requirements")) {
                    ais.add(ai);
                    continue;
                }
                if (!ai.getName().contains("Requirements")) continue;
                ais.add(ai);
            }
            this.aiWidget.setSelectedAIs(ais);
            this.titleWidget.set(title);
            this.descWidget.set("Description...");
            Collection<ChangeTypes> cTypes = this.setChangeTypeWidget(this.changeTypeWidget);
            this.changeTypeWidget.setSelected(cTypes.iterator().next().name());
            List<Priorities> selectable = this.priorityWidget.getSelectable();
            this.priorityWidget.setSelected(selectable.iterator().next());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private Set<IAtsWizardItem> getWizardXWidgetExtensions() {
        IExtension[] extensions;
        if (!wizardExtensionItems.isEmpty()) {
            return wizardExtensionItems;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.ats.ide.AtsWizardItem");
        if (point == null) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't access AtsWizardItem extension point");
            return wizardExtensionItems;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("AtsWizardItem")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                    if (classname != null && bundleName != null) {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        try {
                            Class taskClass = bundle.loadClass(classname);
                            Object obj = taskClass.newInstance();
                            wizardExtensionItems.add((IAtsWizardItem)obj);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading AtsWizardItem extension", (Throwable)ex);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return wizardExtensionItems;
    }

    public String getRunText() {
        return "Create New Action";
    }

    public String getOutputMessage() {
        return "Not yet run.";
    }

    public String getTabTitle() {
        return "New Action";
    }

    public String getTitle() {
        return this.getName();
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavItemCat.TOP);
    }

    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.NEW_ACTION);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NEW_ACTION);
    }

    public ActionResult getActionResult() {
        return this.actionResult;
    }

    protected void addWidgetAfterPriority() {
    }

    protected int getChangeTypeRowColumns() {
        return 6;
    }
}

