/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class ArchiveCommitedBranches
extends AbstractAtsAction {
    private static final String MSG = "Archive Branch(es)";
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private boolean prompt = true;
    private final boolean executeInCurrentThread;

    public ArchiveCommitedBranches(ISelectedAtsArtifacts selectedAtsArtifacts, boolean executeInCurrentThread) {
        super(MSG, ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.ARCHIVE));
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.setToolTipText(this.getText());
        this.executeInCurrentThread = executeInCurrentThread;
    }

    @Override
    public void runWithException() {
        XResultData rd = new XResultData();
        rd.log(String.valueOf(this.getText()) + "\n\n");
        ArrayList<Branch> toCommit = new ArrayList<Branch>();
        Set<Artifact> artifacts = this.selectedAtsArtifacts.getSelectedWorkflowArtifacts();
        for (Artifact art : artifacts) {
            if (art instanceof IAtsTeamWorkflow) {
                Branch branch = (Branch)AtsApiService.get().getBranchService().getBranch((IAtsTeamWorkflow)art);
                if (branch == null || branch.isInvalid()) {
                    rd.logf("Team Workflow has no branch: %s\n", new Object[]{art.toStringWithId()});
                    continue;
                }
                if (branch.isArchived()) {
                    rd.logf("Team Workflow branch already archived: %s\n", new Object[]{art.toStringWithId()});
                    continue;
                }
                if (!branch.getBranchState().isCommitted()) {
                    rd.logf("Team Workflow branch not Committed: %s\n", new Object[]{art.toStringWithId()});
                    continue;
                }
                toCommit.add(branch);
                continue;
            }
            rd.logf("Not a Team Workflow: %s\n", new Object[]{art.toStringWithId()});
        }
        if (toCommit.isEmpty()) {
            rd.logf("\nNothing to Archive\n", new Object[0]);
        } else {
            rd.logf("\n%s Found to Archive", new Object[]{toCommit.size()});
            String msg = String.format("Archive %s Branches\n\nWARNING: Not recommended to Archive more than a couple at a time\n\nNote: This operation will run in the background and a delay\nwill be inserted between Archive so DB and backups are not overwhelmed.\n\nDo NOT shut your OSEE down.", toCommit.size());
            if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getText(), (String)(String.valueOf(msg) + "\n\nAre you sure?"))) {
                AWorkbench.popup((String)("Archiving " + toCommit.size()));
                for (Branch branch : toCommit) {
                    AtsApiService.get().getBranchService().archiveBranch((BranchId)branch);
                    rd.logf("\nArchived: %s", new Object[]{branch.toStringWithId()});
                    System.err.println("\nArchived: " + branch.toStringWithId());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                rd.log("\n\nOperation Cancelled\n");
            }
        }
        XResultDataUI.report((XResultData)rd, (String)this.getText());
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }
}

