/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;
import org.eclipse.osee.support.test.util.UnitTestUtil;

public class UnitTestValidator {
    private static int suiteCount = 0;
    private static List<File> testClassFiles = new ArrayList<File>();
    private static List<File> notForSuiteFiles = new ArrayList<File>();
    private static final Map<String, Collection<String>> testClassToSuites = new HashMap<String, Collection<String>>(100);
    private static final List<File> suites = new ArrayList<File>();
    private static final String NOT_FOR_SUITE = "NOT_FOR_SUITE";

    public static void main(String[] args) {
        try {
            StringBuffer sb = new StringBuffer();
            for (String dirNam : Arrays.asList("C:\\UserData\\git\\org.eclipse.osee\\plugins\\", "C:\\UserData\\git\\lba.osee\\plugins\\")) {
                File dir1 = new File(dirNam);
                for (String endName : Arrays.asList("test", "tests")) {
                    for (String filename : Lib.readListFromDir((File)dir1, (FilenameFilter)new MatchFilter(".*\\." + endName), (boolean)true)) {
                        if (!Strings.isValid((String)filename)) continue;
                        System.out.println("Processing BUNDLE " + filename);
                        File file = new File(dir1 + "\\" + filename);
                        UnitTestValidator.recurseAndFind(file, sb);
                    }
                }
            }
            Collections.sort(testClassFiles);
            for (File suiteFile : suites) {
                String suiteFileText = Lib.fileToString((File)suiteFile);
                for (File testClass : testClassFiles) {
                    String testClassName = testClass.getName();
                    if (!suiteFileText.contains(testClassName.replaceFirst("\\.java", ".class"))) continue;
                    Collection<String> collection = testClassToSuites.get(testClassName);
                    if (collection == null) {
                        collection = new ArrayList<String>();
                        testClassToSuites.put(testClassName, collection);
                    }
                    collection.add(suiteFile.getName());
                }
            }
            int noMatchCount = 0;
            XConsoleLogger.err((String)"\n\n", (Object[])new Object[0]);
            for (File testClass : testClassFiles) {
                String testClassName = testClass.getName();
                if (testClassToSuites.containsKey(testClassName) || notForSuiteFiles.contains(testClass)) continue;
                XConsoleLogger.err((String)String.format("No Suite contains test unit [%s] - Authors [%s]", testClassName, UnitTestUtil.getAuthors(testClass)), (Object[])new Object[0]);
                ++noMatchCount;
            }
            System.out.println(String.format("\nTest Cases [%d] Suites [%s] No Match [%d]", testClassFiles.size(), suiteCount, noMatchCount));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    private static void recurseAndFind(File file, StringBuffer sb) throws IOException {
        if (file.isDirectory()) {
            for (String filename : Lib.readListFromDir((File)file, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                File childFile = new File(String.valueOf(file.getAbsolutePath()) + "\\" + filename);
                UnitTestValidator.recurseAndFind(childFile, sb);
            }
        }
        boolean isSuite = UnitTestUtil.isSuite(file);
        if (file.getAbsolutePath().endsWith(".java") && !isSuite) {
            String text = Lib.fileToString((File)file);
            if (file.getName().startsWith("Abstract") || text.contains("abstract class " + file.getName().replaceFirst("\\.java", ""))) {
                System.out.println("Found ABSTRACT TEST " + file.getName() + ", Ignorning");
            } else if (text.contains("Parameterized.class")) {
                System.out.println("Found Parameterized TEST " + file.getName() + ", Ignorning");
            } else if (text.contains("@Test") || text.contains("@org.junit.Test")) {
                System.out.println("Found TEST " + file.getName());
                testClassFiles.add(file);
                sb.append("\n");
            }
            if (text.contains(NOT_FOR_SUITE)) {
                notForSuiteFiles.add(file);
            }
        }
        if (file.getAbsolutePath().endsWith(".java") && isSuite) {
            System.out.println("Found SUITE " + file.getName());
            suites.add(file);
            ++suiteCount;
        }
    }
}

