/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

public class RenamePackage {
    static String[] classes;
    static int classCount;
    static int classCounter;

    static {
        classCount = 0;
        classCounter = 0;
    }

    public static void main(String[] args) {
        Scanner scan = new Scanner(System.in);
        System.out.println("What package do you want to rename?");
        String oldPackage = scan.nextLine();
        System.out.println("What name do you want to rename the package to?");
        String newPackageName = scan.nextLine();
        int pluginIndex = System.getProperty("user.dir").indexOf("plugins");
        String pluginsPath = System.getProperty("user.dir").substring(0, pluginIndex + 8);
        String featPath = String.valueOf(pluginsPath.substring(0, pluginsPath.length() - 8)) + "features";
        File pluginsDir = new File(pluginsPath);
        File featDir = new File(featPath);
        File[] fileDir = pluginsDir.listFiles();
        int i = 0;
        while (i < fileDir.length) {
            RenamePackage.renameOSGIINFDirectory(new File(fileDir[i] + "\\OSGI-INF"), oldPackage, newPackageName);
            RenamePackage.renameManifest(fileDir[i], oldPackage, newPackageName);
            RenamePackage.renameJavaImports(new File(fileDir[i] + "\\src"), oldPackage, newPackageName);
            ++i;
        }
        File oldPackageTest = new File(pluginsDir + "\\" + oldPackage + ".test");
        if (oldPackageTest.isDirectory()) {
            RenamePackage.findTestJavaFiles(new File(oldPackageTest + "\\src"), String.valueOf(oldPackage) + ".test", String.valueOf(newPackageName) + ".test");
            RenamePackage.renameManifest(new File("" + oldPackageTest), String.valueOf(oldPackage) + ".test", String.valueOf(newPackageName) + ".test");
            RenamePackage.renameFiles(String.valueOf(oldPackage) + ".test", String.valueOf(newPackageName) + ".test", pluginsDir, featDir);
        }
        RenamePackage.renameFiles(oldPackage, newPackageName, pluginsDir, featDir);
    }

    protected static void renameFiles(String oldPackage, String newPackageName, File pluginsDir, File featDir) {
        RenamePackage.renameOtherFiles(pluginsDir, oldPackage, newPackageName, ".project");
        RenamePackage.renameOtherFiles(pluginsDir, oldPackage, newPackageName, "plugin.xml");
        RenamePackage.renameFeatures(featDir, oldPackage, newPackageName);
        RenamePackage.renamePom(pluginsDir, oldPackage, newPackageName);
        RenamePackage.renameBinSubpackages(pluginsDir, oldPackage, newPackageName);
        if (oldPackage.contains("test")) {
            RenamePackage.renameTestSubpackages(pluginsDir, oldPackage, newPackageName);
        } else {
            RenamePackage.renameSubpackages(pluginsDir, oldPackage, newPackageName);
        }
        RenamePackage.deleteSubPackages(pluginsDir, oldPackage);
        RenamePackage.renamePackage(pluginsDir, oldPackage, newPackageName);
        RenamePackage.deleteRemnents(new File(pluginsDir + "\\" + oldPackage));
    }

    protected static void findTestJavaFiles(File path, String oldPackageName, String newPackageName) {
        File ats = new File(path.getAbsolutePath());
        File[] atsPackages = ats.listFiles();
        if (atsPackages == null) {
            return;
        }
        String oldPackageWithoutTest = oldPackageName;
        int i = 0;
        while (i < atsPackages.length) {
            if (atsPackages[i].isDirectory()) {
                RenamePackage.findTestJavaFiles(atsPackages[i], oldPackageName, newPackageName);
            } else if (atsPackages[i].getAbsolutePath().contains("java")) {
                if (atsPackages[i].getAbsolutePath().contains("refactor")) {
                    return;
                }
                RenamePackage.renameTestJavaFiles(atsPackages[i], oldPackageWithoutTest, newPackageName);
            }
            ++i;
        }
    }

    protected static void renameTestJavaFiles(File path, String oldPackageName, String newPackageName) {
        block27: {
            File old = new File(path.getAbsolutePath());
            File temp = new File(String.valueOf(path.getAbsolutePath().substring(0, path.getAbsolutePath().lastIndexOf("\\"))) + "\\test.java");
            if (!old.isFile()) {
                return;
            }
            oldPackageName = oldPackageName.substring(0, oldPackageName.indexOf("test") - 1);
            newPackageName = newPackageName.substring(0, newPackageName.indexOf("test") - 1);
            BufferedReader br = null;
            BufferedWriter bw = null;
            boolean isChanged = false;
            try {
                try {
                    br = new BufferedReader(new FileReader(old.getAbsolutePath()));
                    bw = new BufferedWriter(new FileWriter(temp.getAbsolutePath()));
                    String line = br.readLine();
                    while (line != null) {
                        if (line.contains(oldPackageName)) {
                            isChanged = true;
                            line = line.replace(oldPackageName, newPackageName);
                        }
                        bw.write(String.valueOf(line) + "\n");
                        line = br.readLine();
                    }
                }
                catch (Exception e) {
                    System.out.println("exception: " + e);
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println("IOException: " + e2);
                    }
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e3) {
                        System.err.println("IOException: " + e3);
                    }
                    if (isChanged) {
                        File oldFile = new File(old.getAbsolutePath());
                        oldFile.delete();
                        File newF = new File(temp.getAbsolutePath());
                        newF.renameTo(old);
                        break block27;
                    }
                    old.delete();
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("IOException: " + e);
                }
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("IOException: " + e);
                }
                if (isChanged) {
                    File oldFile = new File(old.getAbsolutePath());
                    oldFile.delete();
                    File newF = new File(temp.getAbsolutePath());
                    newF.renameTo(old);
                } else {
                    old.delete();
                }
            }
        }
    }

    protected static void renameOSGIINFDirectory(File path, String oldPackageName, String newPackageName) {
        if (path == null || !path.isDirectory()) {
            return;
        }
        File[] OSGIINFFiles = path.listFiles();
        if (OSGIINFFiles == null) {
            return;
        }
        int i = 0;
        while (i < OSGIINFFiles.length) {
            if (OSGIINFFiles[i].getAbsolutePath().contains("xml")) {
                RenamePackage.renameOtherFiles(OSGIINFFiles[i], oldPackageName, newPackageName, "OSGIINF");
            }
            ++i;
        }
    }

    protected static void deleteSubPackages(File path, String oldPackageName) {
        File srcDir = new File(String.valueOf(path.getAbsolutePath()) + "\\" + oldPackageName + "\\src\\");
        String[] dirs = oldPackageName.split("\\.");
        String subPackagePath = "";
        int i = dirs.length;
        while (i > 0) {
            subPackagePath = "";
            int count = 0;
            while (count < i) {
                subPackagePath = String.valueOf(subPackagePath) + dirs[count] + "\\";
                ++count;
            }
            File temp = new File(String.valueOf(srcDir.getAbsolutePath()) + "\\" + subPackagePath);
            if (temp.isDirectory() && temp.list().length == 0) {
                temp.delete();
            }
            --i;
        }
    }

    protected static void deleteRemnents(File path) {
        File toDelete = new File("" + path);
        if (toDelete.isDirectory()) {
            File[] dirs = toDelete.listFiles();
            int i = 0;
            while (i < dirs.length) {
                if (dirs[i].isFile()) {
                    dirs[i].delete();
                } else {
                    RenamePackage.deleteRemnents(dirs[i]);
                }
                ++i;
            }
        }
        toDelete.delete();
    }

    protected static void renameBinSubpackages(File path, String oldPackageName, String newPackageName) {
        String oldPack = oldPackageName.replace(".", "\\");
        String srcDir = path + "\\" + oldPackageName + "\\bin\\";
        String[] newDirs = newPackageName.split("\\.");
        int i = 0;
        while (i < newDirs.length - 1) {
            if (!new File(srcDir = String.valueOf(srcDir) + newDirs[i] + "\\").isDirectory()) {
                new File(srcDir).mkdir();
            }
            ++i;
        }
        srcDir = String.valueOf(srcDir) + newDirs[newDirs.length - 1];
        File oldDir = new File(path + "\\" + oldPackageName + "\\bin\\" + oldPack);
        File newDir = new File(srcDir);
        oldDir.renameTo(newDir);
    }

    protected static void renameTestSubpackages(File path, String oldPackageName, String newPackageName) {
        String oldPack = oldPackageName.replace(".", "\\");
        String srcDir = path + "\\" + oldPackageName + "\\src\\";
        String[] newDirs = newPackageName.split("\\.");
        int i = 0;
        while (i < newDirs.length - 1) {
            if (!new File(srcDir = String.valueOf(srcDir) + newDirs[i] + "\\").isDirectory()) {
                new File(srcDir).mkdir();
            }
            ++i;
        }
        if ((srcDir = String.valueOf(srcDir) + newDirs[newDirs.length - 1]).substring(srcDir.lastIndexOf("\\")).contains("test")) {
            if (new File(srcDir).isDirectory()) {
                RenamePackage.renameSubpackages(path, oldPackageName, newPackageName);
            } else {
                String oldDirPath = path + "\\" + oldPackageName + "\\src\\" + oldPack;
                File oldDir = new File(oldDirPath.substring(0, oldDirPath.lastIndexOf("test") - 1));
                File newDir = new File(srcDir.substring(0, srcDir.lastIndexOf("test") - 1));
                if (newDir.isDirectory()) {
                    newDir.delete();
                }
                oldDir.renameTo(newDir);
            }
        }
    }

    protected static void renameSubpackages(File path, String oldPackageName, String newPackageName) {
        String oldPack = oldPackageName.replace(".", "\\");
        String srcDir = path + "\\" + oldPackageName + "\\src\\";
        String[] newDirs = newPackageName.split("\\.");
        int i = 0;
        while (i < newDirs.length - 1) {
            if (!new File(srcDir = String.valueOf(srcDir) + newDirs[i] + "\\").isDirectory()) {
                new File(srcDir).mkdir();
            }
            ++i;
        }
        srcDir = String.valueOf(srcDir) + newDirs[newDirs.length - 1];
        File oldDir = new File(path + "\\" + oldPackageName + "\\src\\" + oldPack);
        File newDir = new File(srcDir);
        oldDir.renameTo(newDir);
    }

    protected static void renameFeatures(File path, String oldPackageName, String newPackageName) {
        File[] features = path.listFiles();
        int i = 0;
        while (i < features.length) {
            features[i].getAbsolutePath();
            RenamePackage.renameOtherFiles(features[i], oldPackageName, newPackageName, "feature");
            ++i;
        }
    }

    protected static void renameOtherFiles(File path, String oldPackageName, String newPackageName, String type) {
        block56: {
            String t;
            int index;
            File temp;
            File old;
            String packageName = "";
            boolean inMainPackageToChange = false;
            boolean pastParentTags = false;
            if (type == "feature") {
                old = new File(String.valueOf(path.getAbsolutePath()) + "\\feature.xml");
                temp = new File(String.valueOf(path.getAbsolutePath()) + "\\test.xml");
                if (!old.isFile()) {
                    return;
                }
            } else if (type == "pom") {
                old = new File(String.valueOf(path.getAbsolutePath()) + "\\" + oldPackageName + "\\pom.xml");
                temp = new File(String.valueOf(path.getAbsolutePath()) + "\\" + oldPackageName + "\\testpom.xml");
                if (oldPackageName.contains("test")) {
                    oldPackageName.substring(0, oldPackageName.indexOf("test") - 1);
                }
            } else if (type == "parentPom") {
                old = new File(String.valueOf(path.getAbsolutePath()) + "\\pom.xml");
                temp = new File(String.valueOf(path.getAbsolutePath()) + "\\testpom.xml");
            } else if (type == "manifest") {
                int src = path.getAbsolutePath().lastIndexOf("\\");
                packageName = path.getAbsolutePath().substring(src + 1);
                if (packageName.equals(oldPackageName)) {
                    inMainPackageToChange = true;
                }
                if (!(old = new File(String.valueOf(path.getAbsolutePath()) + "\\META-INF\\MANIFEST.MF")).isFile()) {
                    return;
                }
                temp = new File(String.valueOf(path.getAbsolutePath()) + "\\META-INF\\TEST.MF");
            } else if (type == "java") {
                old = new File(path.getAbsolutePath());
                index = path.getAbsolutePath().lastIndexOf("\\");
                t = path.getAbsolutePath().substring(0, index);
                temp = new File(String.valueOf(t) + "\\test.java");
                packageName = RenamePackage.checkIfInMainPackage(path);
                if (packageName.equals(oldPackageName)) {
                    inMainPackageToChange = true;
                }
            } else if (type == "OSGIINF") {
                old = new File(path.getAbsolutePath());
                index = path.getAbsolutePath().lastIndexOf("\\");
                t = path.getAbsolutePath().substring(0, index);
                temp = new File(String.valueOf(t) + "\\test.xml");
            } else {
                old = new File(String.valueOf(path.getAbsolutePath()) + "\\" + oldPackageName + "\\" + type);
                if (!old.isFile()) {
                    return;
                }
                temp = new File(String.valueOf(path.getAbsolutePath()) + "\\" + oldPackageName + "\\test" + type);
            }
            BufferedReader br = null;
            BufferedWriter bw = null;
            boolean isChanged = false;
            try {
                try {
                    br = new BufferedReader(new FileReader(old.getAbsolutePath()));
                    bw = new BufferedWriter(new FileWriter(temp.getAbsolutePath()));
                    String line = br.readLine();
                    while (line != null) {
                        if (line.contains("<testClass>")) {
                            isChanged = true;
                            line = line.replace(oldPackageName.substring(0, oldPackageName.indexOf("test") - 1), newPackageName.substring(0, newPackageName.lastIndexOf("test") - 1));
                        }
                        if (line.contains(oldPackageName) && (type != "pom" || pastParentTags)) {
                            int pluginIndex = line.indexOf("plugins");
                            int modIndex = line.indexOf("</module>");
                            if (pluginIndex > 0 && modIndex > 0) {
                                String module = line.substring(pluginIndex + 8, modIndex);
                                if (module.length() <= oldPackageName.length()) {
                                    line = line.replace(oldPackageName, newPackageName);
                                    isChanged = true;
                                }
                            } else if (line.contains("Bundle-SymbolicName")) {
                                int semiColonIndex = line.indexOf(";");
                                String bundleName = line.substring(21, semiColonIndex);
                                if (bundleName.length() == oldPackageName.length()) {
                                    isChanged = true;
                                    line = line.replace(oldPackageName, newPackageName);
                                }
                            } else if (!line.contains("package") || oldPackageName.length() == packageName.length()) {
                                if (line.contains("import")) {
                                    int lastPeriodIndex = line.lastIndexOf(".");
                                    int semiColonIndex = line.indexOf(";");
                                    line.substring(lastPeriodIndex + 1, semiColonIndex);
                                    String srcPath = path.getAbsolutePath().substring(0, path.getAbsolutePath().indexOf("src") + 3);
                                    classCount = 0;
                                    classCounter = 0;
                                    RenamePackage.countJavaNames(new File(srcPath));
                                    RenamePackage.classesToArray(new File(srcPath));
                                    isChanged = true;
                                    line = line.replace(oldPackageName, newPackageName);
                                } else if (!line.contains("Export-Package") || inMainPackageToChange) {
                                    isChanged = true;
                                    line = line.replace(oldPackageName, newPackageName);
                                }
                            }
                        }
                        if (line.contains("</parent>")) {
                            pastParentTags = true;
                        }
                        bw.write(String.valueOf(line) + "\n");
                        line = br.readLine();
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println("Exception: " + e2);
                    }
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e3) {
                        System.err.println("Exception: " + e3);
                    }
                    if (isChanged) {
                        File oldFile = new File(old.getAbsolutePath());
                        oldFile.delete();
                        temp.renameTo(old);
                        break block56;
                    }
                    temp.delete();
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception: " + e);
                }
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception: " + e);
                }
                if (isChanged) {
                    File oldFile = new File(old.getAbsolutePath());
                    oldFile.delete();
                    temp.renameTo(old);
                } else {
                    temp.delete();
                }
            }
        }
    }

    private static String checkIfInMainPackage(File path) {
        int pluginsIndex = path.getAbsolutePath().indexOf("plugins");
        int src = path.getAbsolutePath().indexOf("src");
        String packageName = path.getAbsolutePath().substring(pluginsIndex + 8, src - 1);
        return packageName;
    }

    protected static void renameJavaImports(File path, String oldPackageName, String newPackageName) {
        File ats = new File(path.getAbsolutePath());
        File[] Packages = ats.listFiles();
        if (Packages == null) {
            return;
        }
        String oldPackageWithoutTest = oldPackageName;
        int i = 0;
        while (i < Packages.length) {
            if (Packages[i].isDirectory()) {
                RenamePackage.renameJavaImports(Packages[i], oldPackageName, newPackageName);
            } else if (Packages[i].getAbsolutePath().contains("java")) {
                if (Packages[i].getAbsolutePath().contains("RenamePackage")) {
                    return;
                }
                RenamePackage.renameOtherFiles(Packages[i], oldPackageWithoutTest, newPackageName, "java");
            }
            ++i;
        }
    }

    protected static void countJavaNames(File path) {
        File ats = new File(path.getAbsolutePath());
        File[] atsPackages = ats.listFiles();
        int i = 0;
        while (i < atsPackages.length) {
            if (atsPackages[i].isDirectory()) {
                RenamePackage.countJavaNames(atsPackages[i]);
            } else if (atsPackages[i].getAbsolutePath().contains("java")) {
                ++classCount;
            }
            ++i;
        }
        classes = new String[classCount];
    }

    protected static void classesToArray(File path) {
        File ats = new File(path.getAbsolutePath());
        File[] atsPackages = ats.listFiles();
        int i = 0;
        while (i < atsPackages.length) {
            if (atsPackages[i].isDirectory()) {
                RenamePackage.classesToArray(atsPackages[i]);
            } else if (atsPackages[i].getAbsolutePath().contains("java")) {
                RenamePackage.classes[RenamePackage.classCounter] = atsPackages[i].getAbsolutePath();
                ++classCounter;
            }
            ++i;
        }
    }

    private static boolean checkJavaClasses(String packageName) {
        int i = 0;
        while (i < classes.length) {
            if (classes[i].contains(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean checkJavaClassNames(File path, String oldPackageName) {
        File ats = new File(path.getAbsolutePath());
        File[] atsPackages = ats.listFiles();
        String[] javaClassArray = new String[classCount];
        int arrayCounter = 0;
        if (atsPackages == null) {
            return false;
        }
        int i = 0;
        while (i < atsPackages.length) {
            if (atsPackages[i].isDirectory()) {
                RenamePackage.checkJavaClassNames(atsPackages[i], oldPackageName);
            } else if (atsPackages[i].getAbsolutePath().contains("java")) {
                javaClassArray[arrayCounter] = atsPackages[i].getAbsolutePath();
                ++arrayCounter;
            }
            ++i;
        }
        i = 0;
        while (i < javaClassArray.length) {
            if (javaClassArray[i].contains(oldPackageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static void renamePackage(File path, String oldPackageName, String newPackageName) {
        File oldFile = new File(String.valueOf(path.getAbsolutePath()) + "\\" + oldPackageName);
        File newFile = new File(String.valueOf(path.getAbsolutePath()) + "\\" + newPackageName);
        oldFile.renameTo(newFile);
    }

    public static String getPluginFromPath(File path) {
        int index = path.getAbsolutePath().indexOf("plugins");
        String packageName = path.getAbsolutePath().substring(index + 7);
        return packageName;
    }

    protected static void renameManifest(File path, String oldPackageName, String newPackageName) {
        RenamePackage.renameOtherFiles(path, oldPackageName, newPackageName, "manifest");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void renamePom(File path, String oldPackageName, String newPackageName) {
        RenamePackage.renameOtherFiles(path, oldPackageName, newPackageName, "pom");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileReader fr = new FileReader(path + "\\" + oldPackageName + "\\pom.xml");
                try {
                    try (BufferedReader br = new BufferedReader(fr);){
                        String line = br.readLine();
                        while (line != null) {
                            if (line.contains("<relativePath>")) {
                                int tagIndex = line.lastIndexOf("<relativePath>");
                                line.indexOf("plugin");
                                String parentPom = line.substring(tagIndex + 28, line.indexOf("</relativePath"));
                                RenamePackage.renameOtherFiles(new File(path + "\\" + parentPom), oldPackageName, newPackageName, "parentPom");
                            }
                            line = br.readLine();
                        }
                        br.close();
                    }
                    if (fr == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex);
        }
    }
}

