/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.io.File;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.osee.define.ide.traceability.HierarchyHandler;
import org.eclipse.osee.define.ide.traceability.TestUnitTagger;
import org.eclipse.osee.define.ide.utility.IResourceLocator;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class TraceResourceDropOperation
extends AbstractOperation {
    private final Collection<URI> resources;
    private final IResourceLocator locator;
    private final RelationTypeSide relTypeSide;
    private final Artifact requirement;
    private final boolean persistChanges;
    private final RenameConfirmer confirmer;

    public TraceResourceDropOperation(Collection<URI> resources, RelationTypeSide relTypeSide, Artifact requirement, IResourceLocator locator, boolean persistChanges, RenameConfirmer confirmer) {
        super("Trace Resource Drop Operation", "org.eclipse.nebula.widgets.xviewer");
        this.relTypeSide = relTypeSide;
        this.requirement = requirement;
        this.resources = resources;
        this.locator = locator;
        this.persistChanges = persistChanges;
        this.confirmer = confirmer;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        if (!this.resources.isEmpty()) {
            BranchToken branch = this.requirement.getBranch();
            SkynetTransaction transaction = null;
            if (this.persistChanges) {
                transaction = TransactionManager.createTransaction((BranchId)branch, (String)"TraceResourceDrop");
            }
            if (transaction != null) {
                HierarchyHandler handler = new HierarchyHandler(transaction);
                TreeMap<Artifact, String> nameUpdateRequired = new TreeMap<Artifact, String>();
                for (URI resource : this.resources) {
                    File file = new File(resource);
                    if (file.isDirectory()) continue;
                    this.processFile(file, handler, transaction, nameUpdateRequired);
                }
                boolean isOk = true;
                if (!nameUpdateRequired.isEmpty()) {
                    if (this.confirmer != null) {
                        isOk = this.confirmer.acceptUpdate(nameUpdateRequired);
                    }
                    if (isOk) {
                        for (Map.Entry entry : nameUpdateRequired.entrySet()) {
                            ((Artifact)entry.getKey()).setName((String)entry.getValue());
                        }
                    }
                }
                if (this.persistChanges && isOk) {
                    this.requirement.persist(transaction);
                    transaction.execute();
                }
            }
        }
    }

    private void processFile(File file, HierarchyHandler handler, SkynetTransaction transaction, Map<Artifact, String> nameUpdateRequired) throws Exception {
        CharBuffer fileBuffer = Lib.fileToCharBuffer((File)file);
        URI fileUri = file.toURI();
        IFileStore fileStore = EFS.getStore((URI)fileUri);
        String name = this.locator.getIdentifier(fileStore, fileBuffer).getName();
        TestUnitTagger tagger = TestUnitTagger.getInstance();
        String tag = tagger.getSourceTag(fileUri);
        Artifact testUnitArtifact = null;
        BranchToken branch = this.requirement.getBranch();
        boolean tagSource = false;
        if (GUID.isValid((String)tag)) {
            try {
                testUnitArtifact = ArtifactQuery.getArtifactFromId((String)tag, (BranchId)branch);
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        } else {
            tag = GUID.create();
            tagSource = true;
        }
        if (testUnitArtifact == null) {
            testUnitArtifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.TestCase, (BranchToken)branch, (String)name, (String)tag);
            handler.addArtifact(testUnitArtifact);
            if (tagSource) {
                tagger.addSourceTag(fileUri, testUnitArtifact.getGuid());
                this.refreshFile(file.getAbsolutePath());
            }
        }
        if (!testUnitArtifact.getName().equals(name)) {
            nameUpdateRequired.put(testUnitArtifact, name);
        }
        this.requirement.addRelation(this.relTypeSide, testUnitArtifact);
        if (this.persistChanges) {
            testUnitArtifact.persist(transaction);
        }
    }

    private void refreshFile(String uri) {
        IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(uri);
        if (eclipseResource != null) {
            try {
                eclipseResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                OseeLog.log(Activator.class, (Level)Level.INFO, (String)"Refreshing resource failed.");
            }
        }
    }

    public static interface RenameConfirmer {
        public boolean acceptUpdate(Map<Artifact, String> var1);
    }
}

