/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.api.publishing.templatemanager.TemplateManagerEndpoint;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.internal.ServiceUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.swt.program.Program;

public class PublishingTemplateBlam
extends AbstractBlam {
    private static String blamDescription = "Finds a Publishing Template using the server side Publishing Template Manager.";
    private static String blamName = "Publishing Template BLAM";
    private static String variableRendererId = "Renderer Id";
    private static String variableArtifactTypeName = "Artifact Type Name";
    private static String variablePresentationType = "Presentation Type";
    private static String variableOption = "Option";

    public PublishingTemplateBlam() {
        super(blamName, blamDescription, null);
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_HEALTH);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        return new XWidgetBuilder().andWidget(variableRendererId, "XText").endWidget().andWidget(variableArtifactTypeName, "XText").endWidget().andWidget(variablePresentationType, "XText").endWidget().andWidget(variableOption, "XText").endWidget().getItems();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        try {
            String rendererId = variableMap.getString(variableRendererId);
            String artifactTypeName = variableMap.getString(variableArtifactTypeName);
            String presentationType = variableMap.getString(variablePresentationType);
            String option = variableMap.getString(variableOption);
            OseeClient oseeClient = ServiceUtil.getOseeClient();
            TemplateManagerEndpoint templateManagerEndpoint = oseeClient.getTemplateManagerEndpoint();
            PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest(rendererId, artifactTypeName, presentationType, option);
            PublishingTemplate publishingTemplate = templateManagerEndpoint.getPublishingTemplate(publishingTemplateRequest);
            String fileName = "PUBLISHING_TEMPLATE_" + publishingTemplate.getIdentifier() + "_" + Lib.getDateTimeString() + ".txt";
            File file = OseeData.getFile((String)fileName);
            Throwable throwable = null;
            Object var14_18 = null;
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(publishingTemplate.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Program.launch((String)file.getAbsolutePath());
        }
        catch (Exception e) {
            Message message = new Message().title((CharSequence)"Publishing Template Request Failed").reasonFollows((Throwable)e);
            Throwable cause = e.getCause();
            if (Objects.nonNull(cause)) {
                message.reasonFollows("Caused By", cause);
            }
            AWorkbench.popup((String)message.toString());
        }
    }
}

