/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.column.CountryColumn;
import org.eclipse.osee.ats.core.config.WorkPackageUtility;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class InsertionColumn
extends AbstractServicesColumn {
    private Map<Object, ArtifactToken> idToInsertion;

    public InsertionColumn(AtsApi atsApi) {
        super(atsApi);
    }

    public void setIdToInsertionCache(Map<Object, ArtifactToken> idToInsertion) {
        this.idToInsertion = idToInsertion;
    }

    @Override
    public String getText(IAtsObject atsObject) {
        String format = "%s";
        if (this.atsApi.getStoreService().isDeleted(atsObject)) {
            format = "<Deleted> %s";
        }
        return String.format(format, InsertionColumn.getInsertionStr(atsObject, this.atsApi, CountryColumn.getUtil(), this.idToInsertion));
    }

    public static String getInsertionStr(IAtsObject atsObject, AtsApi atsApi) {
        return InsertionColumn.getInsertionStr(atsObject, atsApi, CountryColumn.getUtil());
    }

    public static String getInsertionStr(IAtsObject atsObject, AtsApi atsApi, WorkPackageUtility util) {
        return InsertionColumn.getInsertionStr(atsObject, atsApi, util, null);
    }

    public static String getInsertionStr(IAtsObject atsObject, AtsApi atsApi, WorkPackageUtility util, Map<Object, ArtifactToken> idToInsertion) {
        String result = "";
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem;
            Pair<IAtsInsertion, Boolean> insertion;
            ArtifactToken insertionArt;
            if (idToInsertion != null && (insertionArt = idToInsertion.get(atsObject.getId())) != null) {
                result = insertionArt.getName();
            }
            if (Strings.isInValid((String)result) && (insertion = util.getInsertion(atsApi, workItem = (IAtsWorkItem)atsObject)).getFirst() != null) {
                result = String.format("%s%s", ((IAtsInsertion)insertion.getFirst()).getName(), (Boolean)insertion.getSecond() != false ? " (I)" : "");
            }
        } else if (atsObject instanceof IAtsWorkPackage) {
            ArtifactToken insertionArt;
            if (idToInsertion != null && (insertionArt = idToInsertion.get(((IAtsWorkPackage)atsObject).getId())) != null) {
                result = insertionArt.getName();
            }
            if (Strings.isInValid((String)result)) {
                IAtsInsertion insertion;
                IAtsWorkPackage workPackage = (IAtsWorkPackage)atsObject;
                IAtsInsertionActivity insertionActivity = atsApi.getProgramService().getInsertionActivity(workPackage);
                if (insertionActivity != null && (insertion = atsApi.getProgramService().getInsertion(insertionActivity)) != null) {
                    result = insertion.getName();
                }
            }
        }
        return result;
    }
}

