/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.CreateTeamData;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.config.ITeamDefinitionUtility;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class ModifyActionableItems {
    private final XResultData results;
    private final IAtsTeamWorkflow teamWf;
    private final Collection<IAtsActionableItem> currAIsForAllWfs;
    private final Collection<IAtsActionableItem> currWorkflowDesiredAIs;
    private final Collection<IAtsActionableItem> newAIs;
    private final AtsUser modifiedBy;
    private final List<CreateTeamData> teamDatas = new ArrayList<CreateTeamData>();
    private final List<IAtsActionableItem> addAis = new ArrayList<IAtsActionableItem>();
    private final List<IAtsActionableItem> removeAis = new ArrayList<IAtsActionableItem>();
    private final Map<IAtsTeamDefinition, CreateTeamData> teamDefToTeamDataMap = new HashMap<IAtsTeamDefinition, CreateTeamData>();
    private final ITeamDefinitionUtility teamDefUtil;
    private final AtsApi atsApi;

    public ModifyActionableItems(XResultData results, IAtsTeamWorkflow teamWf, Collection<IAtsActionableItem> currAIsForAllWfs, Collection<IAtsActionableItem> currWorkflowDesiredAIs, Collection<IAtsActionableItem> newAIs, AtsUser modifiedBy, ITeamDefinitionUtility teamDefUtil, AtsApi atsApi) {
        this.results = results;
        this.teamWf = teamWf;
        this.currAIsForAllWfs = currAIsForAllWfs;
        this.currWorkflowDesiredAIs = currWorkflowDesiredAIs;
        this.newAIs = newAIs;
        this.modifiedBy = modifiedBy;
        this.teamDefUtil = teamDefUtil;
        this.atsApi = atsApi;
    }

    public void performModification() {
        Conditions.checkNotNull((Object)this.results, (String)"results");
        Conditions.checkNotNull((Object)this.teamWf, (String)"teamWf");
        Conditions.checkNotNull((Object)this.modifiedBy, (String)"modifiedBy");
        if (this.currWorkflowDesiredAIs != null) {
            this.processAisAddedRemovedFromSelectedTeamWf();
        }
        this.processAisAddedForNewWorkflows();
    }

    private void processAisAddedForNewWorkflows() {
        if (this.newAIs.isEmpty()) {
            return;
        }
        HashSet<IAtsActionableItem> allAIsForNewWorkflow = new HashSet<IAtsActionableItem>();
        HashSet<IAtsActionableItem> duplicatedAIs = new HashSet<IAtsActionableItem>();
        for (IAtsActionableItem checkAi : this.newAIs) {
            if (!checkAi.isActionable()) {
                this.results.errorf("Actionable Item [%s] is not actionable; select item lower in hierarchy\n", new Object[]{checkAi});
                continue;
            }
            if (!checkAi.isAllowUserActionCreation()) {
                this.results.errorf("Actionable Item [%s] is not actionable by users; select another item\n", new Object[]{checkAi});
                continue;
            }
            if (this.currAIsForAllWfs.contains(checkAi)) {
                duplicatedAIs.add(checkAi);
            }
            allAIsForNewWorkflow.add(checkAi);
        }
        if (allAIsForNewWorkflow.isEmpty()) {
            this.results.errorf("No Actionable Items Selected", new Object[0]);
            return;
        }
        Date createdDate = new Date();
        for (IAtsActionableItem ai : allAIsForNewWorkflow) {
            CreateTeamData createTeamData;
            IAtsTeamDefinition teamDef = this.getImpactedTeamDef(ai);
            if (this.teamDefToTeamDataMap.containsKey(teamDef)) {
                createTeamData = this.teamDefToTeamDataMap.get(teamDef);
                createTeamData.getActionableItems().add(ai);
                continue;
            }
            createTeamData = new CreateTeamData(teamDef, Arrays.asList(ai), new LinkedList(this.atsApi.getTeamDefinitionService().getLeads(teamDef)), createdDate, this.modifiedBy, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
            this.teamDatas.add(createTeamData);
            this.teamDefToTeamDataMap.put(teamDef, createTeamData);
        }
        for (CreateTeamData data : this.teamDatas) {
            this.results.log(String.format("Create New Team Workflow for Actionable Item(s) %s", data.getActionableItems()));
            for (IAtsActionableItem ai : data.getActionableItems()) {
                if (!duplicatedAIs.contains(ai)) continue;
                this.results.logf("   - Note: Actionable Item [%s] is impacted by an existing Team Workflow\n", new Object[]{ai});
            }
        }
    }

    private IAtsTeamDefinition getImpactedTeamDef(IAtsActionableItem ai) {
        IAtsTeamDefinition teamDef = null;
        Collection<IAtsTeamDefinition> impactedTeamDefs = this.teamDefUtil.getImpactedTeamDefs(Arrays.asList(ai));
        if (impactedTeamDefs.size() > 0) {
            teamDef = impactedTeamDefs.iterator().next();
        }
        return teamDef;
    }

    private void processAisAddedRemovedFromSelectedTeamWf() {
        Set currAIs = this.teamWf.getActionableItems();
        if (this.currWorkflowDesiredAIs.isEmpty()) {
            this.results.error("All AIs can not be removed from a Team Workflow; Cancel workflow instead");
        } else {
            for (IAtsActionableItem checkedAi : this.currWorkflowDesiredAIs) {
                if (currAIs.contains(checkedAi)) continue;
                this.results.logf("Add Actionable Item [%s] to the selected Team Workflow\n", new Object[]{checkedAi});
                this.addAis.add(checkedAi);
            }
            for (IAtsActionableItem currAi : currAIs) {
                if (this.currWorkflowDesiredAIs.contains(currAi)) continue;
                this.results.logf("Remove Actionable Item [%s] to the selected Team Workflow\n", new Object[]{currAi});
                this.removeAis.add(currAi);
            }
        }
    }

    public List<CreateTeamData> getTeamDatas() {
        return this.teamDatas;
    }

    public List<IAtsActionableItem> getAddAis() {
        return this.addAis;
    }

    public List<IAtsActionableItem> getRemoveAis() {
        return this.removeAis;
    }
}

