/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.logger.Log;

public class AgileBacklog
extends WorkItem
implements IAgileBacklog {
    public AgileBacklog(Log logger, AtsApi atsApi, ArtifactToken artifact) {
        super(logger, atsApi, artifact, AtsArtifactTypes.AgileBacklog);
    }

    public boolean isActive() {
        return this.getCurrentStateType().isInWork();
    }

    public long getTeamId() {
        long result = 0L;
        try {
            ArtifactToken agileTeam = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)this.artifact, AtsRelationTypes.AgileTeamToBacklog_AgileTeam);
            if (agileTeam.isValid()) {
                result = agileTeam.getId();
            }
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return result;
    }
}

