/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.access;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;

public class UserRelatedToAtsObjectSearch {
    private final boolean activeObjectsOnly;
    private final AtsUser atsUser;
    private final AtsApi atsApi;

    public UserRelatedToAtsObjectSearch(AtsUser user, boolean activeObjectsOnly, AtsApi atsApi) {
        this.atsUser = user;
        this.activeObjectsOnly = activeObjectsOnly;
        this.atsApi = atsApi;
    }

    public Collection<ArtifactToken> getResults() {
        ArrayList<ArtifactToken> arts = new ArrayList<ArtifactToken>();
        if (this.activeObjectsOnly) {
            arts.addAll(this.atsApi.getQueryService().getArtifactsFromAttributeKeywords((BranchId)this.atsApi.getAtsBranch(), this.atsUser.getUserId(), false, DeletionFlag.EXCLUDE_DELETED, false, new AttributeTypeString[]{AtsAttributeTypes.CurrentState}));
        } else {
            arts.addAll(this.atsApi.getQueryService().getArtifactsFromAttributeKeywords((BranchId)this.atsApi.getAtsBranch(), this.atsUser.getUserId(), false, DeletionFlag.EXCLUDE_DELETED, false, new AttributeTypeString[]{AtsAttributeTypes.CurrentState, AtsAttributeTypes.State, AtsAttributeTypes.Log}));
        }
        arts.addAll(this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)this.atsUser, AtsRelationTypes.TeamLead_Team));
        arts.addAll(this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)this.atsUser, AtsRelationTypes.TeamMember_Team));
        arts.addAll(this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)this.atsUser, AtsRelationTypes.FavoriteUser_Artifact));
        arts.addAll(this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)this.atsUser, AtsRelationTypes.SubscribedUser_Artifact));
        return arts;
    }
}

