/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassXViewerFactory;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.ui.define.viewers.IDataChangedListener;
import org.eclipse.osee.ote.ui.define.viewers.data.ArtifactItem;
import org.eclipse.osee.ote.ui.define.viewers.data.BranchItem;
import org.eclipse.osee.ote.ui.define.viewers.data.DataItem;
import org.eclipse.osee.ote.ui.define.viewers.data.ScriptItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerDataManager {
    private final XViewer xViewer;
    private final List<DataItem> commitableItems;
    private final List<DataItem> uncommitableItems;
    private final Map<BranchId, DataItem> branchMap;
    private final List<DataItem> backingData = new ArrayList<DataItem>();
    private final Collection<IDataChangedListener> listeners;
    private boolean isInitialized = false;

    public XViewerDataManager(XViewer xViewer) {
        this.xViewer = xViewer;
        this.branchMap = new HashMap<BranchId, DataItem>();
        this.commitableItems = new ArrayList<DataItem>();
        this.uncommitableItems = new ArrayList<DataItem>();
        this.listeners = Collections.synchronizedSet(new HashSet());
    }

    private void ensureInitialized() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    XViewerDataManager.this.xViewer.setInput(XViewerDataManager.this.backingData);
                }
            });
        }
    }

    public void addArtifacts(IProgressMonitor monitor, List<Artifact> artifacts) {
        if (this.branchMap.isEmpty() && this.xViewer.getXViewerFactory() instanceof MassXViewerFactory) {
            ((MassXViewerFactory)this.xViewer.getXViewerFactory()).registerAllAttributeColumnsForArtifacts(artifacts, true);
        }
        int total = artifacts.size();
        int index = 0;
        while (index < artifacts.size()) {
            Artifact artifact = artifacts.get(index);
            monitor.subTask(String.format("Adding to Table: [%s] [%s of %s]", artifact.getName(), index + 1, total));
            DataItem branchItem = this.getBranchItem(artifact);
            DataItem scriptItem = this.getScriptItem(branchItem, artifact);
            ArtifactItem tempItem = new ArtifactItem(this.xViewer, artifact, null);
            DataItem itemFound = scriptItem.getChild(tempItem.getKey());
            if (itemFound == null) {
                scriptItem.addChild(tempItem.getKey(), tempItem);
                tempItem.setParent(scriptItem);
                ArtifactTestRunOperator operator = tempItem.getOperator();
                if (operator.isFromLocalWorkspace()) {
                    if (operator.isCommitAllowed()) {
                        this.commitableItems.add(tempItem);
                    } else {
                        this.uncommitableItems.add(tempItem);
                    }
                }
            }
            monitor.worked(1);
            ++index;
        }
        this.refresh();
    }

    private void refresh() {
        this.ensureInitialized();
        this.notifyOnDataChanged();
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XViewerDataManager.this.xViewer.refresh();
            }
        });
    }

    private DataItem getScriptItem(DataItem branchItem, Artifact artifact) {
        ArtifactTestRunOperator testRunArtifact = new ArtifactTestRunOperator(artifact);
        ScriptItem tempItem = new ScriptItem(testRunArtifact.getScriptUrl(), testRunArtifact.getScriptRevision(), null);
        DataItem scriptItem = branchItem.getChild(((DataItem)tempItem).getKey());
        if (scriptItem == null) {
            scriptItem = tempItem;
            scriptItem.setParent(branchItem);
            branchItem.addChild(scriptItem.getKey(), scriptItem);
        }
        return scriptItem;
    }

    private DataItem getBranchItem(Artifact artifact) {
        BranchToken branch = artifact.getBranchToken();
        DataItem toReturn = this.branchMap.get(branch);
        if (toReturn == null) {
            toReturn = new BranchItem(branch, null);
            this.branchMap.put((BranchId)branch, toReturn);
            this.backingData.add(toReturn);
        }
        return toReturn;
    }

    private void removeHelper(DataItem item) {
        if (item != null) {
            DataItem parent = item.getParent();
            if (parent != null) {
                parent.removeChild(item);
                if (!parent.hasChildren()) {
                    this.removeHelper(parent);
                    parent.dispose();
                }
            } else {
                this.branchMap.remove(item.getKey());
                this.backingData.remove(item);
            }
        }
    }

    public void removeSelected() {
        List<DataItem> items = this.getSelected();
        for (DataItem item : items) {
            this.removeHelper(item);
            item.dispose();
            this.commitableItems.remove(item);
            this.uncommitableItems.remove(item);
        }
        this.refresh();
    }

    public void removeAll() {
        this.commitableItems.clear();
        this.uncommitableItems.clear();
        for (DataItem dataItem : this.branchMap.values()) {
            dataItem.dispose();
        }
        this.branchMap.clear();
        this.backingData.clear();
        this.refresh();
    }

    public Control getControl() {
        return this.xViewer.getTree();
    }

    private List<DataItem> getSelected() {
        ArrayList<DataItem> toReturn = new ArrayList<DataItem>();
        TreeItem[] items = this.xViewer.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                toReturn.add((DataItem)item.getData());
                ++n2;
            }
        }
        return toReturn;
    }

    public List<Artifact> getSelectedArtifacts() {
        ArrayList<Artifact> toReturn = new ArrayList<Artifact>();
        for (DataItem item : this.getSelected()) {
            Object object = item.getData();
            if (!(object instanceof Artifact)) continue;
            toReturn.add((Artifact)object);
        }
        return toReturn;
    }

    public Artifact[] getUnCommitable() {
        return this.getArtifactsFromDataItemList(this.uncommitableItems);
    }

    public Artifact[] getAllCommitable() {
        return this.getArtifactsFromDataItemList(this.commitableItems);
    }

    private Artifact[] getArtifactsFromDataItemList(List<DataItem> sourceList) {
        ArrayList<Artifact> toReturn = new ArrayList<Artifact>();
        for (DataItem item : sourceList) {
            toReturn.add((Artifact)item.getData());
        }
        return toReturn.toArray(new Artifact[toReturn.size()]);
    }

    public Artifact[] getSelectedForCommit() {
        ArrayList<Artifact> toReturn = new ArrayList<Artifact>();
        for (DataItem item : this.getSelected()) {
            if (!this.commitableItems.contains(item)) continue;
            toReturn.add((Artifact)item.getData());
        }
        return toReturn.toArray(new Artifact[toReturn.size()]);
    }

    public void removeFromCommitable(Collection<Artifact> artifacts) {
        this.removeArtifactsFromDataItemList(this.commitableItems, artifacts);
        this.removeArtifactsFromDataItemList(this.uncommitableItems, artifacts);
        this.refresh();
    }

    private void removeArtifactsFromDataItemList(List<DataItem> sourceList, Collection<Artifact> artifactsToRemove) {
        ArrayList<DataItem> itemsToRemove = new ArrayList<DataItem>();
        for (DataItem item : sourceList) {
            Object object = item.getData();
            if (!artifactsToRemove.contains(object)) continue;
            itemsToRemove.add(item);
        }
        sourceList.removeAll(itemsToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnDataChanged() {
        Collection<IDataChangedListener> collection = this.listeners;
        synchronized (collection) {
            for (IDataChangedListener listener : this.listeners) {
                listener.onDataChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IDataChangedListener listener) {
        Collection<IDataChangedListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterListener(IDataChangedListener listener) {
        Collection<IDataChangedListener> collection = this.listeners;
        synchronized (collection) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    public boolean isEmpty() {
        return this.branchMap.isEmpty();
    }
}

