/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.word;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.Streams;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.word.UpdateBookmarkIds;
import org.eclipse.osee.jdbc.JdbcStatement;

public class WordCoreUtilClient {
    private static final Matcher binIdMatcher = Pattern.compile("wordml://(.+?)[.]").matcher("");
    public static final String BODY_END = "</w:body>";
    public static final String BODY_START = "<w:body>";
    private static int bookMarkId = 1000;
    private static final String[] NUMBER = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};
    private static final IStatus promptStatus = new Status(2, "org.eclipse.osee.framework.skynet.core", 256, "", null);
    private static final Pattern referencePattern = Pattern.compile("(_Ref[0-9]{9}|Word\\.Bookmark\\.End)");
    private static final String SELECT_WORD_VALUES = "SELECT attr.content, attr.gamma_id FROM osee_attribute attr, osee_txs txs WHERE attr.art_id=? AND attr.attr_type_id=? AND attr.gamma_id = txs.gamma_id AND txs.branch_id=? ORDER BY attr.gamma_id DESC";
    private static UpdateBookmarkIds updateBookmarkIds = new UpdateBookmarkIds(bookMarkId);
    private static final String wordBody = "<w:body></w:body>";
    private static final String wordLeader1 = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><?mso-application progid='Word.Document'?>";
    private static final String wordLeader2 = "<w:wordDocument xmlns:w='http://schemas.microsoft.com/office/word/2003/wordml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:w10='urn:schemas-microsoft-com:office:word' xmlns:sl='http://schemas.microsoft.com/schemaLibrary/2003/core' xmlns:aml='http://schemas.microsoft.com/aml/2001/core' xmlns:wx='http://schemas.microsoft.com/office/word/2003/auxHint' xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:dt='uuid:C2F41010-65B3-11d1-A29F-00AA00C14882' xmlns:wsp='http://schemas.microsoft.com/office/word/2003/wordml/sp2' xmlns:ns0='http://www.w3.org/2001/XMLSchema' xmlns:ns1='http://eclipse.org/artifact.xsd' xmlns:st1='urn:schemas-microsoft-com:office:smarttags' w:macrosPresent='no' w:embeddedObjPresent='no' w:ocxPresent='no' xml:space='preserve'>";
    private static final String wordTrailer = "</w:wordDocument> ";
    private static final String emptyDocumentContent = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><?mso-application progid='Word.Document'?><w:wordDocument xmlns:w='http://schemas.microsoft.com/office/word/2003/wordml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:w10='urn:schemas-microsoft-com:office:word' xmlns:sl='http://schemas.microsoft.com/schemaLibrary/2003/core' xmlns:aml='http://schemas.microsoft.com/aml/2001/core' xmlns:wx='http://schemas.microsoft.com/office/word/2003/auxHint' xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:dt='uuid:C2F41010-65B3-11d1-A29F-00AA00C14882' xmlns:wsp='http://schemas.microsoft.com/office/word/2003/wordml/sp2' xmlns:ns0='http://www.w3.org/2001/XMLSchema' xmlns:ns1='http://eclipse.org/artifact.xsd' xmlns:st1='urn:schemas-microsoft-com:office:smarttags' w:macrosPresent='no' w:embeddedObjPresent='no' w:ocxPresent='no' xml:space='preserve'><w:body></w:body></w:wordDocument> ";

    public static String checkForTrackedChanges(String value, Artifact art) {
        String returnValue = value;
        BranchToken branch = art.getBranch();
        if (WordCoreUtil.containsWordAnnotations((CharSequence)value) && !BranchManager.getType((BranchId)branch).isMergeBranch()) {
            try {
                String message = "This document contains track changes and cannot be saved with them. Do you want OSEE to remove them?\n\nNote:You will need to reopen this artifact in OSEE to see the final result.";
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                Pair answer = (Pair)handler.handleStatus(promptStatus, (Object)message);
                MutableBoolean first = (MutableBoolean)answer.getFirst();
                boolean isOkToRemove = first.getValue();
                if (!isOkToRemove) {
                    throw new OseeCoreException("Artifact [%s], Branch[%s] contains track changes. Please remove them and save again.", new Object[]{art, branch});
                }
                returnValue = WordCoreUtil.removeAnnotations((CharSequence)value).toString();
            }
            catch (CoreException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            catch (ClassCastException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return returnValue;
    }

    public static String elementNameFor(String artifactName) {
        char firstChar;
        String elementName = artifactName.trim().replaceAll("[^A-Za-z0-9]", "_");
        if (elementName.equals("")) {
            elementName = "nameless";
        }
        if ((firstChar = elementName.charAt(0)) >= '0' && firstChar <= '9') {
            elementName = String.valueOf(NUMBER[firstChar - 48]) + elementName.substring(1);
        }
        return elementName;
    }

    public static String getEmptyDocumentContent() {
        return emptyDocumentContent;
    }

    public static final String getGUIDFromFile(File file) throws IOException {
        String guid = null;
        byte[] myBytes = new byte[4096];
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            if (((InputStream)stream).read(myBytes) == -1) {
                throw new IOException("Buffer underrun");
            }
        }
        catch (Throwable throwable) {
            Lib.close(stream);
            throw throwable;
        }
        Lib.close((AutoCloseable)stream);
        String leadingPartOfFile = new String(myBytes, "UTF-8");
        String[] splitsBeforeAndAfter = leadingPartOfFile.split("/BeforeGUID/PrePend|/AfterGUID");
        if (splitsBeforeAndAfter.length == 3) {
            guid = splitsBeforeAndAfter[1];
        }
        return guid;
    }

    public static WordCoreUtil.pageType getPageOrientation(Artifact artifact) {
        WordCoreUtil.pageType defaultPageType = WordCoreUtil.pageType.getDefault();
        if (artifact.isInvalid()) {
            return defaultPageType;
        }
        if (!artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.PageOrientation)) {
            return defaultPageType;
        }
        try {
            String pageTypeString = artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.PageOrientation, defaultPageType.name());
            return WordCoreUtil.pageType.fromString((String)pageTypeString);
        }
        catch (Exception exception) {
            return defaultPageType;
        }
    }

    public static boolean isHeadingStyle(String paragraphStyle) {
        if (paragraphStyle == null) {
            return false;
        }
        String style = paragraphStyle.toLowerCase();
        return style.startsWith("heading") || style.startsWith("toc") || style.startsWith("outline");
    }

    public static String reassignBinDataID(String content) {
        ChangeSet changeSet = new ChangeSet((CharSequence)content);
        HashMap<String, String> guidMap = new HashMap<String, String>();
        binIdMatcher.reset(content);
        boolean atLeastOneMatch = false;
        while (binIdMatcher.find()) {
            atLeastOneMatch = true;
            String oldName = binIdMatcher.group(1);
            String guid = (String)guidMap.get(oldName);
            if (guid == null) {
                guid = GUID.create();
                guidMap.put(oldName, guid);
            }
            changeSet.replace(binIdMatcher.start(1), binIdMatcher.end(1), guid);
        }
        if (atLeastOneMatch) {
            return changeSet.toString();
        }
        return content;
    }

    public static String reassignBookMarkID(String content) {
        return updateBookmarkIds.fixTags(content);
    }

    public static String referencesOnly(String content) {
        ArrayList<String> references = new ArrayList<String>();
        Matcher referenceMatcher = referencePattern.matcher(content);
        while (referenceMatcher.find()) {
            String reference = referenceMatcher.group(1);
            references.add(reference);
        }
        StringBuilder sb = new StringBuilder();
        for (String reference : references) {
            sb.append(reference);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final String removeGUIDFromTemplate(String template) {
        String newTemplate = "";
        String[] splitsBeforeAndAfter = template.split("/BeforeGUID/PrePend|/AfterGUID");
        newTemplate = splitsBeforeAndAfter.length == 3 ? String.valueOf(splitsBeforeAndAfter[0]) + " " + splitsBeforeAndAfter[2] : template;
        return newTemplate;
    }

    public static final String removeWordMarkupSmartTags(String wordMarkup) {
        String[] splitsOnSmartTagStart;
        if (wordMarkup != null && (splitsOnSmartTagStart = wordMarkup.split("<[/]{0,1}st\\d{1,22}")).length > 1) {
            StringBuilder myStringBuilder = new StringBuilder(splitsOnSmartTagStart[0]);
            int i = 1;
            while (i < splitsOnSmartTagStart.length) {
                int smartTagEndingIndex = splitsOnSmartTagStart[i].indexOf(">");
                myStringBuilder.append(splitsOnSmartTagStart[i].substring(smartTagEndingIndex + 1));
                ++i;
            }
            wordMarkup = myStringBuilder.toString();
        }
        return wordMarkup;
    }

    public static boolean revertNonusefulWordChanges(ArtifactToken artifact, String table) {
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(SELECT_WORD_VALUES, new Object[]{artifact, CoreAttributeTypes.WordTemplateContent, artifact.getBranch()});
            LinkedList<Pair> values = new LinkedList<Pair>();
            while (chStmt.next()) {
                try {
                    InputStream stream = chStmt.getBinaryStream("content");
                    String content = stream == null ? "" : new String(Streams.getByteArray((InputStream)stream), "UTF-8");
                    values.add(new Pair((Object)content, (Object)GammaId.valueOf((Long)chStmt.getLong("gamma_id"))));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException("Must support UTF-8 format");
                }
            }
            Iterator iter = values.iterator();
            if (iter.hasNext()) {
                Pair nextNewest = (Pair)iter.next();
                LinkedList<GammaId> repeatGammas = new LinkedList<GammaId>();
                while (iter.hasNext()) {
                    Pair newest = nextNewest;
                    nextNewest = (Pair)iter.next();
                    if (!WordCoreUtil.textOnly((String)((String)newest.getFirst())).equals(nextNewest.getFirst())) continue;
                    repeatGammas.add((GammaId)newest.getSecond());
                }
                if (repeatGammas.isEmpty()) {
                    return false;
                }
                for (GammaId gamma : repeatGammas) {
                    ConnectionHandler.runPreparedUpdate("INSERT INTO " + table + " (gamma_id) values (?)", gamma);
                }
                return true;
            }
            return false;
        }
    }
}

