/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.validation;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.validation.IOseeValidator;

public class OseeValidator {
    private static final String EXTENSION_ELEMENT = "OseeValidator";
    private static final String EXTENSION_ID = "org.eclipse.osee.framework.skynet.core.OseeValidator";
    private static final String CLASS_NAME_ATTRIBUTE = "classname";
    private static final OseeValidator instance = new OseeValidator();
    private final ExtensionDefinedObjects<IOseeValidator> loadedObjects = new ExtensionDefinedObjects("org.eclipse.osee.framework.skynet.core.OseeValidator", "OseeValidator", "classname");

    private OseeValidator() {
    }

    public static OseeValidator getInstance() {
        return instance;
    }

    public XResultData validate(int requiredQualityOfService, Artifact artifact, String attributeTypeName, Object proposedValue) {
        XResultData status = XResultData.OK_STATUS;
        try {
            AttributeTypeToken attributeType = AttributeTypeManager.getType(attributeTypeName);
            status = this.validate(requiredQualityOfService, artifact, attributeType, proposedValue);
        }
        catch (Exception ex) {
            status = XResultData.valueOf((XResultData.Type)XResultData.Type.Severe, (String)"org.eclipse.osee.framework.skynet.core", (String)ex.getLocalizedMessage(), (Exception)ex);
        }
        return status;
    }

    public XResultData validate(int requiredQualityOfService, Artifact artifact, AttributeTypeToken attributeType, Object proposedValue) {
        return this.validate(requiredQualityOfService, artifact, attributeType, proposedValue, new XResultData());
    }

    public XResultData validate(int requiredQualityOfService, Artifact artifact, AttributeTypeToken attributeType, Object proposedValue, XResultData rd) {
        if (artifact != null) {
            for (IOseeValidator validator : this.loadedObjects.getObjects()) {
                rd.logTimeStart(validator.getClass().getSimpleName());
                try {
                    if (requiredQualityOfService < validator.getQualityOfService()) continue;
                    if (!validator.isApplicable(artifact, attributeType)) continue;
                    try {
                        XResultData status = validator.validate(artifact, attributeType, proposedValue);
                        if (status.isOK()) continue;
                        XResultData xResultData = status;
                        return xResultData;
                    }
                    catch (Exception ex) {
                        XResultData xResultData;
                        try {
                            xResultData = XResultData.valueOf((XResultData.Type)XResultData.Type.Severe, (String)"org.eclipse.osee.framework.skynet.core", (String)ex.getLocalizedMessage(), (Exception)ex);
                        }
                        catch (Exception ex2) {
                            XResultData xResultData2 = XResultData.valueOf((XResultData.Type)XResultData.Type.Severe, (String)"org.eclipse.osee.framework.skynet.core", (String)ex2.getLocalizedMessage(), (Exception)ex2);
                            rd.logTimeSpent(validator.getClass().getSimpleName());
                            return xResultData2;
                        }
                        rd.logTimeSpent(validator.getClass().getSimpleName());
                        return xResultData;
                    }
                }
                finally {
                    rd.logTimeSpent(validator.getClass().getSimpleName());
                }
            }
        }
        return XResultData.OK_STATUS;
    }

    public XResultData validate(int requiredQualityOfService, Artifact artifact, XResultData rd) {
        try {
            for (AttributeTypeToken attributeType : artifact.getAttributeTypes()) {
                for (Object value : artifact.getAttributeValues((AttributeTypeId)attributeType)) {
                    XResultData status = this.validate(requiredQualityOfService, artifact, attributeType, value, rd);
                    if (status.isOK()) continue;
                    return status;
                }
            }
        }
        catch (Exception ex) {
            return XResultData.valueOf((XResultData.Type)XResultData.Type.Severe, (String)"org.eclipse.osee.framework.skynet.core", (String)ex.getLocalizedMessage(), (Exception)ex);
        }
        return XResultData.OK_STATUS;
    }

    public void clearCaches() {
    }
}

