/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.skynet.core.utility.Address;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;

public class InvalidTxCurrentsAndModTypes
extends AbstractOperation {
    private static final String SELECT_ADDRESSES = "select %s, txs.branch_id, txs.transaction_id, txs.gamma_id, txs.mod_type, txs.app_id, txs.tx_current, txd.tx_type from %s t1, osee_txs%s txs, osee_tx_details txd where t1.gamma_id = txs.gamma_id and txd.transaction_id = txs.transaction_id and txs.branch_id = txd.branch_id order by txs.branch_id, %s, txs.transaction_id desc, txs.gamma_id desc";
    private static final String DELETE_ADDRESS = "delete from osee_txs%s where transaction_id = ? and gamma_id = ? and branch_id = ?";
    private static final String UPDATE_ADDRESS = "update osee_txs%s set tx_current = ? where transaction_id = ? and gamma_id = ? and branch_id = ?";
    private final List<Address> addresses = new ArrayList<Address>();
    private final List<Object[]> purgeData = new ArrayList<Object[]>();
    private final List<Object[]> currentData = new ArrayList<Object[]>();
    private final String tableName;
    private final String columnName;
    private final boolean isFixOperationEnabled;
    private final String txsTableName;
    private final JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();

    public InvalidTxCurrentsAndModTypes(String operationName, String tableName, String columnName, OperationLogger logger, boolean isFixOperationEnabled, boolean archived) {
        super("InvalidTxCurrentsAndModTypes " + operationName + tableName + " fix:" + isFixOperationEnabled + " archived:" + archived, "org.eclipse.osee.framework.skynet.core", logger);
        this.tableName = tableName;
        this.columnName = columnName;
        this.isFixOperationEnabled = isFixOperationEnabled;
        this.txsTableName = archived ? "_archived" : "";
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    private void fixIssues(IProgressMonitor monitor) {
        if (this.isFixOperationEnabled) {
            InvalidTxCurrentsAndModTypes.checkForCancelledStatus((IProgressMonitor)monitor);
            this.getJdbcClient().runBatchUpdate(String.format(DELETE_ADDRESS, this.txsTableName), this.purgeData);
            this.getJdbcClient().runBatchUpdate(String.format(UPDATE_ADDRESS, this.txsTableName), this.currentData);
        }
        monitor.worked(this.calculateWork(0.1));
    }

    private void logIssue(String issue, Address address) {
        this.log(new String[]{issue, address.getBranch().toString(), String.valueOf(address.getItemId()), String.valueOf(address.getTransactionId()), String.valueOf(address.getGammaId()), address.getModType().toString(), address.getTxCurrent().toString()});
    }

    private void consolidateAddressing() {
        this.checkForMultipleVersionsInOneTransaction();
        this.checkForIdenticalAddressingInDifferentTransactions();
        this.checkForMultipleCurrents();
        this.checkForInvalidMergedModType();
        if (this.issueDetected()) {
            for (Address address : this.addresses) {
                if (address.isPurge()) {
                    this.logIssue("purge", address);
                    this.purgeData.add(new Object[]{address.getTransactionId(), address.getGammaId(), address.getBranch()});
                    continue;
                }
                if (address.getCorrectedTxCurrent() != null) {
                    this.logIssue("corrected txCurrent: " + address.getCorrectedTxCurrent(), address);
                    this.currentData.add(new Object[]{address.getCorrectedTxCurrent(), address.getTransactionId(), address.getGammaId(), address.getBranch()});
                    continue;
                }
                System.out.println("would have fixed merge here");
            }
        }
    }

    private void checkForInvalidMergedModType() {
        int index = this.addresses.size() - 1;
        Address lastAddress = this.addresses.get(index);
        if (!lastAddress.isBaselineTx()) {
            while (index > -1) {
                if (!this.addresses.get(index).isPurge()) {
                    this.addresses.get(index).getModType();
                    return;
                }
                --index;
            }
        }
    }

    private void checkForIdenticalAddressingInDifferentTransactions() {
        Address previousAddress = null;
        for (Address address : this.addresses) {
            if (address.hasSameGamma(previousAddress) && address.hasSameModType(previousAddress) && previousAddress != null && address.hasSameApplicability(previousAddress)) {
                previousAddress.setPurge(true);
            }
            previousAddress = address;
        }
    }

    private boolean issueDetected() {
        for (Address address : this.addresses) {
            if (!address.hasIssue()) continue;
            return true;
        }
        return false;
    }

    private void checkForMultipleVersionsInOneTransaction() {
        Address previousAddress = null;
        for (Address address : this.addresses) {
            if (address.isSameTransaction(previousAddress)) {
                if (address.hasSameModType(previousAddress) || !address.getModType().isDeleted() && previousAddress != null && previousAddress.getModType().isEdited()) {
                    address.setPurge(true);
                } else {
                    this.logIssue("multiple versions in one transaction - unknown case", address);
                }
            }
            previousAddress = address;
        }
    }

    private void checkForMultipleCurrents() {
        boolean mostRecentTx = true;
        for (Address address : this.addresses) {
            if (address.isPurge()) continue;
            if (mostRecentTx) {
                address.ensureCorrectCurrent();
                mostRecentTx = false;
                continue;
            }
            address.ensureNotCurrent();
        }
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.log(new String[]{"Starting " + this.getName()});
        InvalidTxCurrentsAndModTypes.checkForCancelledStatus((IProgressMonitor)monitor);
        String sql = String.format(SELECT_ADDRESSES, this.columnName, this.tableName, this.txsTableName, this.columnName);
        monitor.worked(this.calculateWork(0.4));
        Address[] previousAddress = new Address[1];
        Consumer<JdbcStatement> consumer = stmt -> {
            InvalidTxCurrentsAndModTypes.checkForCancelledStatus((IProgressMonitor)monitor);
            ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
            TxCurrent txCurrent = TxCurrent.valueOf((int)stmt.getInt("tx_current"));
            TransactionDetailsType type = TransactionDetailsType.valueOf((int)stmt.getInt("tx_type"));
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            Address address = new Address(type.isBaseline(), BranchId.valueOf((Long)stmt.getLong("branch_id")), stmt.getInt(this.columnName), stmt.getLong("transaction_id"), GammaId.valueOf((Long)stmt.getLong("gamma_id")), modType, appId, txCurrent);
            if (!address.isSimilar(previousAddress[0])) {
                if (!this.addresses.isEmpty()) {
                    this.consolidateAddressing();
                }
                this.addresses.clear();
            }
            this.addresses.add(address);
            addressArray[0] = address;
        };
        this.getJdbcClient().runQueryWithMaxFetchSize(consumer, sql, new Object[0]);
        monitor.worked(this.calculateWork(0.5));
        this.fixIssues(monitor);
        this.log(new String[]{"Completed " + this.getName()});
    }
}

