/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelXmlArtifact
implements RowProcessor {
    private final XMLReader xmlReader;
    private final String staticId;
    private final BranchId branch;
    private final ExcelSaxHandler excelHandler;
    private final List<Worksheet> workbook = new ArrayList<Worksheet>();
    private Worksheet currentWorksheet = null;
    private boolean initialized = false;

    public ExcelXmlArtifact(boolean firstRowIsHeader, String staticId, BranchId branch) throws SAXException {
        this.excelHandler = new ExcelSaxHandler((RowProcessor)this, firstRowIsHeader, true);
        this.xmlReader = XMLReaderFactory.createXMLReader();
        this.xmlReader.setContentHandler((ContentHandler)this.excelHandler);
        this.staticId = staticId;
        this.branch = branch;
    }

    private void startParsing() throws IOException, SAXException {
        String xmlData;
        Artifact artifact = ArtifactQuery.getArtifactFromTypeAndAttribute((ArtifactTypeId)CoreArtifactTypes.GeneralDocument, (AttributeTypeId)CoreAttributeTypes.StaticId, this.staticId, this.branch);
        if (artifact != null && (xmlData = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.NativeContent, null)) != null) {
            StringReader reader = new StringReader(xmlData);
            this.xmlReader.parse(new InputSource(reader));
        }
        this.initialized = true;
    }

    public List<Worksheet> getWorkbook() throws IOException, SAXException {
        if (!this.initialized) {
            this.startParsing();
        }
        return this.workbook;
    }

    public void processRow(String[] row) throws Exception {
        if (this.currentWorksheet != null) {
            this.currentWorksheet.addRow(row);
        }
    }

    public void processHeaderRow(String[] row) {
        if (this.currentWorksheet != null) {
            this.currentWorksheet.setHeaderRow(row);
        }
    }

    public void processEmptyRow() {
        if (this.currentWorksheet != null) {
            this.currentWorksheet.addBlankRow();
        }
    }

    public void processCommentRow(String[] row) {
        if (this.currentWorksheet != null) {
            this.currentWorksheet.addBlankRow();
        }
    }

    public void reachedEndOfWorksheet() {
        this.currentWorksheet = null;
    }

    public void foundStartOfWorksheet(String sheetName) throws Exception {
        Worksheet ws = new Worksheet(sheetName);
        this.workbook.add(ws);
        this.currentWorksheet = ws;
    }

    public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        if (this.currentWorksheet != null) {
            this.currentWorksheet.setRowCount(rowCount);
            this.currentWorksheet.setColCount(columnCount);
        }
    }

    public static class Row {
        private final List<String> row = new ArrayList<String>();

        public Row() {
        }

        public Row(String[] row) {
            String[] stringArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                String cell = stringArray[n2];
                this.row.add(cell);
                ++n2;
            }
        }

        public List<String> getRow() {
            return this.row;
        }

        public List<String> getColRange(int fromIndex, int toIndex) {
            return this.row.subList(fromIndex, toIndex);
        }

        public String getCell(int colIndex) {
            if (colIndex < this.row.size()) {
                return this.row.get(colIndex);
            }
            return null;
        }
    }

    public static class Worksheet {
        private final List<Row> rows = new ArrayList<Row>();
        private Row headerRow = null;
        private final String name;
        private int rowCount = 0;
        private int colCount = 0;

        public Worksheet(String name) {
            this.name = name;
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public void addBlankRow() {
            Row row2 = new Row();
            this.rows.add(row2);
        }

        public void addRow(String[] row) {
            Row row2 = new Row(row);
            this.rows.add(row2);
        }

        public void setHeaderRow(String[] row) {
            this.headerRow = new Row(row);
        }

        public Row getHeaderRow() {
            return this.headerRow;
        }

        public String getName() {
            return this.name;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public void setColCount(int colCount) {
            this.colCount = colCount;
        }

        public int getColCount() {
            return this.colCount;
        }
    }
}

