/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.exception.TransactionDoesNotExist;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeRow;
import org.eclipse.osee.framework.skynet.core.attribute.RelationRow;
import org.eclipse.osee.framework.skynet.core.internal.accessors.DatabaseBranchAccessor;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitor;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitorCache;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitorImpl;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;

public final class TransactionManager {
    private static final String INSERT_INTO_TRANSACTION_DETAIL = "INSERT INTO osee_tx_details (transaction_id, osee_comment, time, author, branch_id, tx_type, build_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String SELECT_TRANSACTIONS = "SELECT * FROM osee_tx_details WHERE branch_id = ? ORDER BY transaction_id DESC";
    private static final String SELECT_TRANSACTIONS_BY_IDS = "SELECT * FROM osee_tx_details WHERE transaction_id in (%s)";
    private static final String SELECT_COMMIT_TRANSACTIONS = "SELECT * FROM osee_tx_details WHERE commit_art_id = ?";
    private static final String UPDATE_TRANSACTION_COMMENTS = "UPDATE osee_tx_details SET osee_comment = ? WHERE transaction_id = ?";
    private static final String SELECT_TRANSACTION_COMMENTS = "SELECT * FROM osee_tx_details WHERE osee_comment LIKE ?";
    private static final String SELECT_BRANCH_TRANSACTION_BY_DATE = "SELECT * FROM osee_tx_details WHERE branch_id = ? AND time < ? ORDER BY time DESC";
    private static final String SELECT_HEAD_TRANSACTION = "select * from osee_tx_details where transaction_id = (select max(transaction_id) from osee_tx_details where branch_id = ?) and branch_id = ?";
    private static final String SELECT_PRIOR_TRANSACTION = "select * from osee_tx_details where transaction_id = (select max(transaction_id) from osee_tx_details where branch_id = ? and transaction_id < ?) and branch_id = ?";
    private static final String TX_GET_TRANSACTION_BY_ID = "SELECT * FROM osee_tx_details WHERE transaction_id = ?";
    private static final String TX_GET_TRANSACTION_FROM_ATTR_ID = "select transaction_id from osee_attribute attr, osee_txs txs where txs.branch_id = ? and attr.gamma_id = ? and attr.gamma_id = txs.gamma_id";
    private static final String SELECT_ATTRIBUTES_FROM_ART_IN_TRANS_ID = "select * from osee_attribute attr, osee_txs txs where txs.branch_id = ? and attr.ART_ID = ? and txs.TRANSACTION_ID = ? and attr.gamma_id = txs.GAMMA_ID";
    private static final String SELECT_RELATIONS_FROM_ART_IN_TRANS_ID = "select * from osee_relation_link rel, osee_txs txs where txs.branch_id = ? and (rel.a_art_id = ? or rel.b_art_id = ?) and txs.TRANSACTION_ID = ? and rel.gamma_id = txs.GAMMA_ID";
    private static final String SELECT_RELATIONS2_FROM_ART_IN_TRANS_ID = "select * from osee_relation rel, osee_txs txs where txs.branch_id = ? and (rel.a_art_id = ? or rel.b_art_id = ?) and txs.TRANSACTION_ID = ? and rel.gamma_id = txs.GAMMA_ID";
    private static final String SELECT_ART_TRANSACTION_IDS = "select max(transaction_id) as prevTx from osee_attribute atr, osee_txs txs where branch_id = ? and art_id = ? and atr.gamma_id = txs.gamma_id and transaction_id < ?";
    private static final TxMonitorImpl<BranchId> txMonitor = new TxMonitorImpl(new TxMonitorCache());
    private static final HashCollectionSet<ArtifactId, TransactionRecord> commitArtifactIdMap = new HashCollectionSet(HashSet::new);
    private static final Set<ArtifactId> processedCommitArtifactId = new HashSet<ArtifactId>();

    public static SkynetTransaction createTransaction(BranchId branch, String comment) {
        SkynetTransaction tx = new SkynetTransaction((TxMonitor<BranchId>)txMonitor, branch, comment);
        txMonitor.createTx(branch, tx);
        return tx;
    }

    public static List<TransactionRecord> getTransaction(String comment) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        ArrayList<TransactionRecord> transactions = new ArrayList<TransactionRecord>();
        jdbcClient.runQuery(stmt -> {
            boolean bl = transactions.add(TransactionManager.loadTransaction(stmt));
        }, SELECT_TRANSACTION_COMMENTS, new Object[]{comment});
        return transactions;
    }

    public static void setTransactionComment(TransactionId transaction, String comment) {
        ConnectionHandler.runPreparedUpdate(UPDATE_TRANSACTION_COMMENTS, comment, transaction);
    }

    public static List<TransactionRecord> getTransactionsForBranch(BranchId branch) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        ArrayList<TransactionRecord> transactions = new ArrayList<TransactionRecord>();
        jdbcClient.runQueryWithMaxFetchSize(stmt -> {
            boolean bl = transactions.add(TransactionManager.loadTransaction(branch, stmt));
        }, SELECT_TRANSACTIONS, new Object[]{branch});
        return transactions;
    }

    public static ArtifactId getCommitArtifact(TransactionId tx) {
        return TransactionManager.getTransaction(tx).getCommitArtifact();
    }

    public static synchronized Collection<TransactionRecord> getCommittedArtifactTransactionIds(ArtifactId artifact) {
        if (!processedCommitArtifactId.contains(artifact) && !commitArtifactIdMap.containsKey((Object)artifact)) {
            ConnectionHandler.getJdbcClient().runQuery(stmt -> {
                Collection collection = commitArtifactIdMap.put((Object)artifact, (Object)TransactionManager.loadTransaction(stmt));
            }, SELECT_COMMIT_TRANSACTIONS, new Object[]{artifact});
            processedCommitArtifactId.add(artifact);
        }
        return commitArtifactIdMap.safeGetValues((Object)artifact);
    }

    public static synchronized void clearCommitArtifactCacheForAssociatedArtifact(ArtifactId associatedArtifact) {
        commitArtifactIdMap.removeValues((Object)associatedArtifact);
        processedCommitArtifactId.remove(associatedArtifact);
    }

    public static synchronized void cacheCommittedArtifactTransaction(ArtifactId artifact, TransactionToken transactionId) {
        commitArtifactIdMap.put((Object)artifact, (Object)TransactionManager.getTransactionRecord(transactionId.getId()));
        processedCommitArtifactId.add(artifact);
    }

    public static TransactionToken getHeadTransaction(BranchId branch) {
        return TransactionManager.getTransaction(branch, SELECT_HEAD_TRANSACTION, branch, branch);
    }

    public static TransactionToken getPriorTransaction(TransactionToken tx) {
        BranchId branch = tx.getBranch();
        return TransactionManager.getTransaction(branch, SELECT_PRIOR_TRANSACTION, branch, tx.getId(), branch);
    }

    private static TransactionRecord getTransaction(BranchId branch, String sql, Object ... data) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        return (TransactionRecord)jdbcClient.fetchOrException(() -> new TransactionDoesNotExist("No transactions where found in the database for branch: %d", new Object[]{branch.getId()}), stmt -> TransactionManager.loadTransaction(branch, stmt), sql, data);
    }

    private static TransactionRecord loadTransaction(JdbcStatement stmt) {
        return TransactionManager.loadTransaction(BranchId.valueOf((Long)stmt.getLong("branch_id")), stmt);
    }

    public static TransactionRecord loadTransaction(BranchId branch, JdbcStatement stmt) {
        Long transactionNumber = stmt.getLong("transaction_id");
        String comment = stmt.getString("osee_comment");
        Timestamp timestamp = stmt.getTimestamp("time");
        ArtifactId commitArtId = ArtifactId.valueOf((Long)stmt.getLong("commit_art_id"));
        Long buildId = stmt.getLong("build_id");
        TransactionDetailsType txType = TransactionDetailsType.valueOf((int)stmt.getInt("tx_type"));
        UserService userService = ((OseeClient)OsgiUtil.getService(DatabaseBranchAccessor.class, OseeClient.class)).userService();
        UserToken author = userService.getUserIfLoaded(Long.valueOf(stmt.getLong("author")));
        return new TransactionRecord(transactionNumber, branch, comment, (Date)timestamp, author, commitArtId, txType, buildId);
    }

    public static synchronized void internalPersist(JdbcConnection connection, TransactionRecord transactionRecord) {
        ConnectionHandler.runPreparedUpdate(connection, INSERT_INTO_TRANSACTION_DETAIL, transactionRecord.getId(), transactionRecord.getComment(), transactionRecord.getTimeStamp(), transactionRecord.getAuthor(), transactionRecord.getBranch(), transactionRecord.getTxType().getId(), OseeCodeVersion.getVersionId());
    }

    public static TransactionToken getTransactionAtDate(BranchId branch, Date maxDateExclusive) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull((Object)maxDateExclusive, (String)"max date exclusive");
        TransactionRecord txRecord = null;
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(SELECT_BRANCH_TRANSACTION_BY_DATE, new Object[]{branch, new Timestamp(maxDateExclusive.getTime())});
            if (chStmt.next()) {
                txRecord = TransactionManager.loadTransaction(chStmt);
            }
        }
        return txRecord;
    }

    public static TransactionRecord getTransaction(TransactionId tx) {
        if (tx instanceof TransactionRecord) {
            return (TransactionRecord)tx;
        }
        return TransactionManager.getTransactionRecord(tx.getId());
    }

    public static TransactionToken getTransaction(long txId) {
        return TransactionManager.getTransactionRecord(txId);
    }

    public static String getComment(long txId) {
        return TransactionManager.getTransactionRecord(txId).getComment();
    }

    public static String getComment(TransactionId tx) {
        return TransactionManager.getComment(tx.getId());
    }

    private static TransactionRecord getTransactionRecord(long txId) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        return (TransactionRecord)jdbcClient.fetchOrException(() -> new TransactionDoesNotExist("A transaction with id %d was not found.", new Object[]{txId}), stmt -> TransactionManager.loadTransaction(stmt), TX_GET_TRANSACTION_BY_ID, new Object[]{txId});
    }

    public static Collection<TransactionRecord> getTransactions(Set<Long> ids) {
        LinkedList<TransactionRecord> transactions = new LinkedList<TransactionRecord>();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            String query = String.format(SELECT_TRANSACTIONS_BY_IDS, Collections.toString((String)",", ids));
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                transactions.add(TransactionManager.loadTransaction(chStmt));
            }
        }
        return transactions;
    }

    public static TransactionId getTransaction(BranchId branch, Attribute<Object> attr) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        return (TransactionId)jdbcClient.fetchOrException(() -> new TransactionDoesNotExist("A transaction from attr gamma id %d was not found.", new Object[]{attr.getGammaId()}), stmt -> TransactionId.valueOf((Long)stmt.getLong("transaction_id")), TX_GET_TRANSACTION_FROM_ATTR_ID, new Object[]{branch.getId(), attr.getGammaId()});
    }

    public static boolean revertArtifactFromTransaction(Artifact art, TransactionId revertTransaction, XResultData results, boolean persist, SkynetTransaction persistTransaction) {
        List<AttributeRow> attributesFromArtifactAndTransaction = TransactionManager.getAttributesFromArtifactAndTransaction(art, revertTransaction);
        for (AttributeRow attr : attributesFromArtifactAndTransaction) {
            if (attr.getModType() != ModificationType.ARTIFACT_DELETED) continue;
            throw new UnsupportedOperationException("Revert of Artifact Deleted is not supported (but could be added as needed)");
        }
        List<RelationRow> relations = TransactionManager.getRelationsFromArtifactAndTransaction(art, revertTransaction);
        if (!relations.isEmpty()) {
            throw new UnsupportedOperationException("Revert of Relations Modified is not supported (but could be added as needed)");
        }
        TransactionId prevTransId = TransactionManager.getPreviousTransactionId(art, revertTransaction);
        Artifact prevArt = ArtifactQuery.getHistoricalArtifactFromId((ArtifactId)art, TransactionToken.valueOf((TransactionId)prevTransId, (BranchId)art.getBranch()), DeletionFlag.EXCLUDE_DELETED);
        boolean changed = false;
        for (AttributeRow attr : attributesFromArtifactAndTransaction) {
            AttributeTypeToken type = attr.getAttributeType();
            if (attr.getModType() == ModificationType.NEW) {
                changed = true;
                if (persist) {
                    art.deleteAttribute(attr.getAttrId());
                }
                results.logf("Deleting created attribute type [%s]\n", new Object[]{type});
                continue;
            }
            if (attr.getModType() == ModificationType.MODIFIED) {
                if (prevArt.getArtifactType().getMax(type) == 1) {
                    Object curValue = art.getSoleAttributeValue((AttributeTypeId)type, null);
                    Object prevValue = TransactionManager.getPreviousValue(prevArt, attr.getAttrId());
                    changed = true;
                    if (persist && prevValue != null) {
                        art.setSoleAttributeValue((AttributeTypeId)type, prevValue);
                    }
                    String currValueAsText = curValue.toString();
                    currValueAsText = AHTML.textToHtml((String)currValueAsText);
                    if (prevValue == null) continue;
                    String prevValueAsText = prevValue.toString();
                    prevValueAsText = AHTML.textToHtml((String)prevValueAsText);
                    results.logf("Setting modified type [%s] from [%s] to [%s]\n", new Object[]{type, currValueAsText, prevValueAsText});
                    continue;
                }
                results.errorf("Max Occurrences > 1 not supported for attribute %s (but could be added as needed)\n", new Object[]{attr});
                continue;
            }
            results.errorf("Mod Type %s not supported for attribute %s (but could be added as needed)\n", new Object[]{attr.getModType(), attr});
        }
        if (persist && changed) {
            art.persist(persistTransaction);
        }
        return changed;
    }

    private static Object getPreviousValue(Artifact prevArt, AttributeId attrId) {
        for (Attribute<?> attr : prevArt.getAttributes()) {
            if (!attrId.equals(attr)) continue;
            return attr.getValue();
        }
        return null;
    }

    public static TransactionId getPreviousTransactionId(Artifact art, TransactionId trans) {
        return (TransactionId)ConnectionHandler.getJdbcClient().fetch((Object)TransactionId.SENTINEL, SELECT_ART_TRANSACTION_IDS, new Object[]{art.getBranch(), art, trans});
    }

    private static List<RelationRow> getRelationsFromArtifactAndTransaction(Artifact art, TransactionId trans) {
        LinkedList<RelationRow> relationChanges = new LinkedList<RelationRow>();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(SELECT_RELATIONS_FROM_ART_IN_TRANS_ID, new Object[]{art.getBranch(), art, art, trans});
            while (chStmt.next()) {
                relationChanges.add(TransactionManager.loadRelationChange(chStmt));
            }
        }
        return relationChanges;
    }

    private static List<RelationRow> getRelations2FromArtifactAndTransaction(Artifact art, TransactionId trans) {
        LinkedList<RelationRow> relationChanges = new LinkedList<RelationRow>();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(SELECT_RELATIONS2_FROM_ART_IN_TRANS_ID, new Object[]{art.getBranch(), art, art, trans});
            while (chStmt.next()) {
                relationChanges.add(TransactionManager.loadRelation2Change(chStmt));
            }
        }
        return relationChanges;
    }

    public static List<AttributeRow> getAttributesFromArtifactAndTransaction(Artifact art, TransactionId trans) {
        LinkedList<AttributeRow> attributeChanges = new LinkedList<AttributeRow>();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(SELECT_ATTRIBUTES_FROM_ART_IN_TRANS_ID, new Object[]{art.getBranch(), art, trans});
            while (chStmt.next()) {
                attributeChanges.add(TransactionManager.loadAttributeChange(chStmt));
            }
        }
        return attributeChanges;
    }

    private static RelationRow loadRelationChange(JdbcStatement chStmt) {
        OrcsTokenService tokenService = (OrcsTokenService)OsgiUtil.getService(TransactionManager.class, OrcsTokenService.class);
        RelationTypeToken relationType = tokenService.getRelationType(Long.valueOf(chStmt.getLong("rel_link_type_id")));
        BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
        GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
        ArtifactId aArtId = ArtifactId.valueOf((Long)chStmt.getLong("a_art_id"));
        ArtifactId bArtId = ArtifactId.valueOf((Long)chStmt.getLong("b_art_id"));
        RelationId relId = RelationId.valueOf((Long)chStmt.getLong("rel_link_id"));
        String rationale = chStmt.getString("rationale");
        return new RelationRow(branch, relId, relationType, aArtId, bArtId, rationale, gammaId);
    }

    private static RelationRow loadRelation2Change(JdbcStatement chStmt) {
        OrcsTokenService tokenService = (OrcsTokenService)OsgiUtil.getService(TransactionManager.class, OrcsTokenService.class);
        RelationTypeToken relationType = tokenService.getRelationType(Long.valueOf(chStmt.getLong("rel_type")));
        BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
        GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
        ArtifactId aArtId = ArtifactId.valueOf((Long)chStmt.getLong("a_art_id"));
        ArtifactId bArtId = ArtifactId.valueOf((Long)chStmt.getLong("b_art_id"));
        ArtifactId relArtId = ArtifactId.valueOf((Long)chStmt.getLong("rel_art_id"));
        int relOrder = chStmt.getInt("rel_order");
        return new RelationRow(branch, relationType, aArtId, bArtId, relArtId, relOrder, gammaId);
    }

    private static AttributeRow loadAttributeChange(JdbcStatement chStmt) {
        OrcsTokenService tokenService = (OrcsTokenService)OsgiUtil.getService(TransactionManager.class, OrcsTokenService.class);
        AttributeTypeGeneric attributeType = tokenService.getAttributeTypeOrCreate(Long.valueOf(chStmt.getLong("attr_type_id")));
        BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
        GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
        ArtifactId artId = ArtifactId.valueOf((Long)chStmt.getLong("art_id"));
        ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
        AttributeId attrId = AttributeId.valueOf((Long)chStmt.getLong("attr_id"));
        String value = chStmt.getString("value");
        return new AttributeRow(branch, gammaId, artId, modType, value, attrId, (AttributeTypeToken)attributeType);
    }

    public static void persistInTransaction(String comment, Collection<? extends Artifact> artifacts) {
        TransactionManager.persistInTransaction(comment, artifacts.toArray(new Artifact[artifacts.size()]));
    }

    public static void persistInTransaction(String comment, Artifact ... artifacts) {
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)artifacts[0].getBranch(), comment);
        Artifact[] artifactArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact art = artifactArray[n2];
            art.persist(transaction);
            ++n2;
        }
        transaction.execute();
    }
}

