/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.messaging.event.res.RemoteArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.ChangeArtifactType;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicAttributeChangeTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerRemote;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class RemoteArtifactTopicEventHandler
implements EventHandlerRemote<RemoteArtifactTopicEvent> {
    private final OrcsTokenService tokenService;

    public RemoteArtifactTopicEventHandler(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Override
    public void handle(Transport transport, Sender sender, RemoteArtifactTopicEvent remoteEvent) {
        RemoteArtifactTopicEvent event1 = remoteEvent;
        ArtifactTopicEvent transEvent = FrameworkEventUtil.getPersistTopicEvent(event1, this.tokenService);
        this.updateArtifacts(sender, transEvent.getArtifacts(), TransactionId.valueOf((Long)remoteEvent.getTransactionId()));
        this.updateRelations(sender, transEvent.getRelations());
        transport.send(sender, transEvent);
    }

    private void updateArtifacts(Sender sender, Collection<EventTopicArtifactTransfer> artifacts, TransactionId transactionId) {
        for (EventTopicArtifactTransfer transArt : artifacts) {
            EventUtil.eventLog((String)String.format("REM: updateArtifact -> [%s]", transArt.toString()), (Object[])new Object[0]);
            EventModType eventModType = transArt.getEventModType();
            switch (eventModType) {
                case Added: {
                    break;
                }
                case Modified: {
                    this.updateModifiedArtifact(transArt, transactionId);
                    break;
                }
                case ChangeType: {
                    ArtifactTypeToken type = this.tokenService.getArtifactType(transArt.getArtifactTypeId().getId());
                    Artifact art = ArtifactCache.getActive(transArt.getArtifactToken());
                    ChangeArtifactType.handleRemoteChangeByArtAndType(art, type);
                    break;
                }
                case Deleted: 
                case Purged: {
                    this.updateDeletedArtifact(ArtifactCache.getActive(transArt.getArtifactToken()));
                    break;
                }
                default: {
                    EventUtil.eventLog((String)String.format("REM: updateArtifacts - Unhandled mod type [%s]", new Object[]{transArt.getEventModType()}), (Object[])new Object[0]);
                }
            }
        }
    }

    private void updateDeletedArtifact(Artifact artifact) {
        try {
            if (artifact != null && !artifact.isHistorical()) {
                artifact.internalSetDeletedFromRemoteEvent();
            }
        }
        catch (OseeCoreException ex) {
            EventUtil.eventLog((String)"REM: updateDeletedArtifact", (Throwable)ex);
        }
    }

    private void updateModifiedArtifact(EventTopicArtifactTransfer transArt, TransactionId transactionId) {
        try {
            Artifact artifact = ArtifactCache.getActive(transArt.getArtifactToken());
            if (artifact != null && !artifact.isHistorical()) {
                artifact.setTransactionId(TransactionManager.getTransaction(transactionId));
                for (EventTopicAttributeChangeTransfer attrChange : transArt.getAttributeChanges()) {
                    if (OseeEventManager.getPreferences().isEnableRemoteEventLoopback()) continue;
                    ModificationType modificationType = ModificationType.valueOf((long)attrChange.getModType());
                    AttributeTypeGeneric attributeType = this.tokenService.getAttributeType(attrChange.getAttrTypeId().getId());
                    try {
                        Attribute<?> attribute = artifact.getAttributeById(attrChange.getAttrId(), true);
                        if (attribute != null) {
                            if (attribute.isDirty()) {
                                EventUtil.eventLog((String)String.format("%s's attribute %d [/n%s/n] has been overwritten.", artifact.getSafeName(), attribute.getId(), attribute.toString()), (Object[])new Object[0]);
                            }
                            try {
                                if (modificationType == null) {
                                    EventUtil.eventLog((String)String.format("REM: updateModifiedArtifact - Can't get mod type for %s's attribute %s.", artifact.getArtifactTypeName(), attrChange.getAttrId()), (Object[])new Object[0]);
                                    continue;
                                }
                                if (modificationType.isDeleted()) {
                                    attribute.internalSetModType(modificationType, false, false);
                                } else {
                                    attribute.getAttributeDataProvider().loadData(attrChange.getDataContent(), attrChange.getDataLocator());
                                }
                                attribute.setNotDirty();
                                attribute.internalSetGammaId(attrChange.getGammaId());
                            }
                            catch (OseeCoreException ex) {
                                EventUtil.eventLog((String)String.format("REM: Exception updating %s's attribute %d [/n%s/n].", artifact.getSafeName(), attribute.getId(), attribute.toString()), (Throwable)ex);
                            }
                            continue;
                        }
                        if (modificationType == null) {
                            EventUtil.eventLog((String)String.format("REM: Can't get mod type for %s's attribute %s.", artifact.getArtifactTypeName(), attrChange.getAttrId()), (Object[])new Object[0]);
                            continue;
                        }
                        artifact.internalInitializeAttribute((AttributeTypeToken)attributeType, attrChange.getAttrId(), attrChange.getGammaId(), modificationType, attrChange.getApplicabilityId(), false, attrChange.getDataContent(), attrChange.getDataLocator());
                    }
                    catch (OseeCoreException ex) {
                        EventUtil.eventLog((String)String.format("REM: Exception updating %s's attribute change for attributeTypeId %d.", artifact.getSafeName(), attributeType.getId()), (Throwable)ex);
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            EventUtil.eventLog((String)"REM: updateModifiedArtifact", (Throwable)ex);
        }
    }

    private void updateRelations(Sender sender, Collection<EventTopicRelationTransfer> relations) {
        block8: for (EventTopicRelationTransfer transRel : relations) {
            try {
                boolean bArtifactLoaded;
                EventUtil.eventLog((String)String.format("REM: updateRelation -> [%s]", transRel.toString()), (Object[])new Object[0]);
                RelationTypeToken relationType = this.tokenService.getRelationType(transRel.getRelTypeId());
                Artifact aArtifact = ArtifactCache.getActive(transRel.getArtAToken());
                Artifact bArtifact = ArtifactCache.getActive(transRel.getArtBToken());
                if (aArtifact == null && bArtifact == null) continue;
                boolean aArtifactLoaded = aArtifact != null;
                boolean bl = bArtifactLoaded = bArtifact != null;
                if (!aArtifactLoaded && !bArtifactLoaded) continue;
                BranchToken branch = BranchManager.getBranchToken((BranchId)transRel.getArtAToken().getBranch());
                ArtifactToken artifactIdA = transRel.getArtAToken();
                ArtifactToken artifactIdB = transRel.getArtBToken();
                RelationLink relation = RelationManager.getLoadedRelationById(transRel.getRelationId(), (ArtifactId)artifactIdA, (ArtifactId)artifactIdB, branch);
                RelationEventType eventType = transRel.getRelationEventType();
                switch (eventType) {
                    case Added: {
                        if (relation != null && relation.getModificationType() != ModificationType.DELETED && relation.getModificationType() != ModificationType.ARTIFACT_DELETED) continue block8;
                        ApplicabilityId appId = relation == null ? ApplicabilityId.BASE : relation.getApplicabilityId();
                        relation = RelationManager.getOrCreate(artifactIdA, artifactIdB, relationType, transRel.getRelationId(), transRel.getGammaId(), transRel.getRationale(), ModificationType.NEW, appId, 0, ArtifactId.SENTINEL);
                        break;
                    }
                    case ModifiedRationale: {
                        if (relation == null) continue block8;
                        relation.internalSetRationale(transRel.getRationale());
                        relation.setNotDirty();
                        break;
                    }
                    case Deleted: 
                    case Purged: {
                        if (relation == null) continue block8;
                        relation.internalRemoteEventDelete();
                        break;
                    }
                    case Undeleted: {
                        if (relation == null) continue block8;
                        relation.undelete();
                        relation.setNotDirty();
                        break;
                    }
                    default: {
                        EventUtil.eventLog((String)String.format("REM: updateRelations - Unhandled mod type [%s]", new Object[]{eventType}), (Object[])new Object[0]);
                        break;
                    }
                }
            }
            catch (OseeCoreException ex) {
                EventUtil.eventLog((String)"REM: updateRelations", (Throwable)ex);
            }
        }
    }
}

