/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.validation.IOseeValidator;

public class OseeEnumerationValidation
implements IOseeValidator {
    @Override
    public int getQualityOfService() {
        return 10;
    }

    @Override
    public boolean isApplicable(Artifact artifact, AttributeTypeToken attributeType) {
        return attributeType.isEnumerated();
    }

    @Override
    public XResultData validate(Artifact artifact, AttributeTypeToken attributeType, Object proposedObject) {
        AttributeTypeEnum enumType = (AttributeTypeEnum)attributeType;
        if (proposedObject != null && enumType.isValidEnum(proposedObject.toString())) {
            return XResultData.OK_STATUS;
        }
        XResultData rd = new XResultData();
        rd.logStr(XResultData.Type.Severe, "The enumerated value [%s] is not valid for the attribute type [%s]", new Object[]{proposedObject.toString(), enumType});
        return rd;
    }
}

