/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import org.eclipse.osee.framework.core.client.QueryBuilder;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactSearchCriteria;

public class RelationCriteria
implements ArtifactSearchCriteria {
    private final RelationTypeToken relationType;
    private final RelationSide relationSide;
    private final ArtifactId artifactId;

    public RelationCriteria(RelationTypeSide relationEnum) {
        this((RelationTypeToken)relationEnum, relationEnum.getSide());
    }

    public RelationCriteria(RelationTypeToken relationType) {
        this(relationType, null);
    }

    public RelationCriteria(RelationTypeToken relationType, RelationSide relationSide) {
        this(ArtifactId.SENTINEL, relationType, relationSide);
    }

    public RelationCriteria(ArtifactId artifactId, RelationTypeToken relationType, RelationSide relationSide) {
        this.artifactId = artifactId;
        this.relationType = relationType;
        this.relationSide = relationSide;
    }

    @Override
    public void addToQueryBuilder(QueryBuilder builder) {
        if (this.artifactId.isValid()) {
            RelationTypeSide rts = RelationTypeSide.create((RelationTypeToken)this.relationType, (RelationSide)this.relationSide);
            builder.andRelatedTo(rts, new ArtifactId[]{this.artifactId});
        } else if (this.relationSide == null) {
            builder.andExists(this.relationType);
        } else {
            RelationTypeSide rts = RelationTypeSide.create((RelationTypeToken)this.relationType, (RelationSide)this.relationSide);
            builder.andExists(rts);
        }
    }
}

