/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;

public abstract class ArtifactFactory {
    private final Set<ArtifactTypeToken> artifactTypes = new HashSet<ArtifactTypeToken>(5);

    protected ArtifactFactory(ArtifactTypeToken ... artifactTypes) {
        ArtifactTypeToken[] artifactTypeTokenArray = artifactTypes;
        int n = artifactTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeToken artifactType = artifactTypeTokenArray[n2];
            this.artifactTypes.add(artifactType);
            ++n2;
        }
    }

    public Artifact makeNewArtifact(BranchToken branch, ArtifactTypeToken artifactTypeId, String artifactName, String guid) {
        return this.makeNewArtifact(branch, artifactTypeId, artifactName, guid, null);
    }

    public Artifact makeNewArtifact(BranchToken branch, ArtifactTypeToken artifactTypeId, String artifactName, String guid, Long uuid) {
        if (guid == null) {
            guid = GUID.create();
        } else {
            Conditions.checkExpressionFailOnTrue((!GUID.isValid((String)guid) ? 1 : 0) != 0, (String)"Invalid guid [%s] during artifact creation [name: %s]", (Object[])new Object[]{guid, artifactName});
        }
        Artifact artifact = this.getArtifactInstance(ArtifactFactory.getNextArtifactId(uuid), guid, branch, artifactTypeId, false);
        artifact.meetMinimumAttributeCounts(true);
        ArtifactCache.cache(artifact);
        artifact.setLinksLoaded(true);
        if (Strings.isValid((String)artifactName)) {
            artifact.setName(artifactName);
        }
        return artifact;
    }

    public static Long getNextArtifactId(Long uuid) {
        if (ArtifactToken.USE_LONG_IDS) {
            return uuid == null ? Lib.generateUuid() : uuid;
        }
        return uuid == null ? ConnectionHandler.getNextSequence("SKYNET_ART_ID_SEQ", true) : uuid;
    }

    public synchronized Artifact reflectExisitingArtifact(ArtifactId artId, String guid, ArtifactTypeToken artifactType, GammaId gammaId, BranchToken branch, ModificationType modificationType, ApplicabilityId applicabilityId) {
        Artifact toReturn = this.internalExistingArtifact(artId, guid, artifactType, gammaId, branch, modificationType, applicabilityId, false, TransactionToken.SENTINEL, true);
        ArtifactCache.cache(toReturn);
        return toReturn;
    }

    private Artifact internalExistingArtifact(ArtifactId artId, String guid, ArtifactTypeToken artifactType, GammaId gammaId, BranchToken branch, ModificationType modType, ApplicabilityId applicabilityId, boolean historical, TransactionToken transactionId, boolean useBackingData) {
        Artifact artifact = this.getArtifactInstance(artId.getId(), guid, branch, artifactType, true);
        artifact.internalSetPersistenceData(gammaId, transactionId, modType, applicabilityId, historical, useBackingData);
        return artifact;
    }

    public synchronized Artifact loadExisitingArtifact(ArtifactId artId, String guid, ArtifactTypeToken artifactType, GammaId gammaId, BranchToken branch, TransactionToken transactionId, ModificationType modType, ApplicabilityId applicabilityId, boolean historical) {
        return this.internalExistingArtifact(artId, guid, artifactType, gammaId, branch, modType, applicabilityId, historical, transactionId, false);
    }

    protected abstract Artifact getArtifactInstance(Long var1, String var2, BranchToken var3, ArtifactTypeToken var4, boolean var5);

    public String toString() {
        return this.getClass().getName();
    }

    public boolean isResponsibleFor(ArtifactTypeToken artifactType) {
        return this.artifactTypes.contains(artifactType);
    }

    public Collection<ArtifactTypeId> getEternalArtifactTypes() {
        return Collections.emptyList();
    }

    public abstract boolean isUserCreationEnabled(ArtifactTypeToken var1);
}

