/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.Adaptable;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EditState;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleArtifactsExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicUuidRelationReorder;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.util.RelationOrderUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.FullyNamed;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactPersistenceManager;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.IntroduceArtifactOperation;
import org.eclipse.osee.framework.skynet.core.artifact.PurgeArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.ArtifactReferenceAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.event.model.AttributeChange;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;

public class Artifact
extends NamedIdBase
implements ArtifactToken,
Adaptable,
FullyNamed {
    public static final Artifact SENTINEL = new Artifact(Id.SENTINEL, CoreBranches.COMMON, CoreArtifactTypes.Artifact);
    public static final String UNNAMED = "Unnamed";
    public static final String BEFORE_GUID_STRING = "/BeforeGUID/PrePend";
    public static final String AFTER_GUID_STRING = "/AfterGUID";
    private final HashCollection<AttributeTypeId, Attribute<?>> attributes = new HashCollection(true);
    private final Set<DefaultBasicUuidRelationReorder> relationOrderRecords = new HashSet<DefaultBasicUuidRelationReorder>();
    private final BranchToken branch;
    private TransactionToken transaction = TransactionRecord.SENTINEL;
    private GammaId gammaId;
    private boolean linksLoaded;
    private boolean historical;
    private ModificationType modType;
    private ModificationType lastValidModType;
    private EditState objectEditState;
    private boolean useBackingData;
    private ArtifactTypeToken artifactType;
    private ApplicabilityId applicabilityId;
    private final String guid;
    private static final Pattern safeNamePattern = Pattern.compile("[^A-Za-z0-9 ]");
    private static final String[] NUMBER = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};

    public Artifact(String guid, BranchToken branch, ArtifactTypeToken artifactTypeId) {
        this(Lib.generateArtifactIdAsInt(), guid, branch, artifactTypeId);
    }

    public Artifact(Long id, BranchToken branch, ArtifactTypeToken artifactTypeId) {
        this(id, null, branch, artifactTypeId);
    }

    public Artifact(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType) {
        super(id, null);
        this.guid = GUID.checkOrCreate((String)guid);
        this.artifactType = artifactType;
        this.objectEditState = EditState.NO_CHANGE;
        this.internalSetModType(ModificationType.NEW, false);
        this.internalSetApplicablityId(ApplicabilityId.BASE);
        this.branch = branch;
    }

    public Artifact(BranchToken branch, ArtifactTypeToken artifactType, String name) {
        this((String)null, branch, artifactType);
        this.setName(name);
    }

    public Artifact(BranchToken branch) {
        this(branch, CoreArtifactTypes.Artifact);
    }

    public Artifact(BranchToken branch, String name) {
        this(branch, CoreArtifactTypes.Artifact, name);
    }

    public Artifact(BranchToken branch, ArtifactTypeToken artifactType) {
        this((String)null, branch, artifactType);
    }

    public Artifact(Long id, BranchToken branch) {
        this(id, null, branch, CoreArtifactTypes.Artifact);
    }

    public String getGuid() {
        return this.guid;
    }

    public final boolean isInDb() {
        return this.transaction.isValid();
    }

    public final boolean isHistorical() {
        return this.historical;
    }

    @Deprecated
    public final List<Artifact> getRelatedArtifacts(RelationTypeToken relationType) {
        return RelationManager.getRelatedArtifacts(this, new RelationTypeSide(relationType, RelationSide.SIDE_B));
    }

    public @NonNull List<Artifact> getRelatedArtifacts(RelationTypeSide relationTypeSide) {
        return RelationManager.getRelatedArtifacts(this, relationTypeSide);
    }

    public final List<Artifact> getRelatedArtifactsUnSorted(RelationTypeSide relationEnum) {
        return RelationManager.getRelatedArtifactsUnSorted(this, relationEnum);
    }

    public final List<Artifact> getRelatedArtifacts(RelationTypeSide relationEnum, DeletionFlag deletionFlag) {
        return RelationManager.getRelatedArtifacts(this, relationEnum, deletionFlag);
    }

    public final String getRelationRationale(Artifact artifact, RelationTypeSide relationTypeSide) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical.  Historical relations are only supported on server", new Object[]{artifact});
        }
        Pair<Artifact, Artifact> sides = this.determineArtifactSides(artifact, relationTypeSide);
        RelationLink link = RelationManager.getRelationLink((Artifact)((Object)sides.getFirst()), (Artifact)((Object)sides.getSecond()), (RelationTypeToken)relationTypeSide);
        return link.getRationale();
    }

    public final void setRelationRationale(Artifact artifact, RelationTypeSide relationTypeSide, String rationale) {
        Pair<Artifact, Artifact> sides = this.determineArtifactSides(artifact, relationTypeSide);
        RelationLink link = RelationManager.getRelationLink((Artifact)((Object)sides.getFirst()), (Artifact)((Object)sides.getSecond()), (RelationTypeToken)relationTypeSide);
        link.setRationale(rationale);
    }

    public final void setRelationRelOrder(Artifact artifact, RelationTypeSide relationTypeSide, int relOrder) {
        Pair<Artifact, Artifact> sides = this.determineArtifactSides(artifact, relationTypeSide);
        RelationLink link = RelationManager.getRelationLink((Artifact)((Object)sides.getFirst()), (Artifact)((Object)sides.getSecond()), (RelationTypeToken)relationTypeSide);
        link.setRelOrder(relOrder);
    }

    private Pair<Artifact, Artifact> determineArtifactSides(Artifact artifact, RelationTypeSide relationSide) {
        boolean sideA = relationSide.getSide().isSideA();
        Artifact artifactA = sideA ? artifact : this;
        Artifact artifactB = sideA ? this : artifact;
        return new Pair((Object)artifactA, (Object)artifactB);
    }

    public final boolean isRelated(RelationTypeSide relationEnum, ArtifactId other) {
        List<Artifact> relatedArtifacts = this.getRelatedArtifacts(relationEnum);
        return relatedArtifacts.contains(other);
    }

    public final Artifact getRelatedArtifact(RelationTypeSide relationEnum) {
        return RelationManager.getRelatedArtifact(this, relationEnum);
    }

    public final int getRelatedArtifactsCount(RelationTypeSide relationEnum) {
        return RelationManager.getRelatedArtifactsCount(this, (RelationTypeToken)relationEnum, relationEnum.getSide());
    }

    public final <A extends Artifact> List<A> getRelatedArtifactsUnSorted(RelationTypeSide side, Class<A> clazz) {
        return Collections.castAll(this.getRelatedArtifactsUnSorted(side));
    }

    public final <A extends Artifact> List<A> getRelatedArtifacts(RelationTypeSide side, Class<A> clazz) {
        return Collections.castAll(this.getRelatedArtifacts(side));
    }

    public final <A extends Artifact> List<A> getRelatedArtifactsOfType(RelationTypeSide side, Class<A> clazz) {
        ArrayList<Artifact> objs = new ArrayList<Artifact>();
        for (Artifact art : this.getRelatedArtifacts(side)) {
            if (!clazz.isInstance((Object)art)) continue;
            objs.add(art);
        }
        return objs;
    }

    @Deprecated
    public final int getArtId() {
        return this.getIdIntValue();
    }

    public final BranchToken getBranch() {
        return this.branch;
    }

    public final BranchToken getBranchToken() {
        return BranchManager.getBranchToken((BranchId)this.branch);
    }

    public final String getArtifactTypeName() {
        return this.getArtifactType().getName();
    }

    public String toString() {
        return this.getName();
    }

    public final Artifact getParent() {
        Artifact toReturn = null;
        List<Artifact> artifacts = this.getRelatedArtifactsUnSorted(CoreRelationTypes.DefaultHierarchical_Parent);
        int parentCount = artifacts.size();
        if (parentCount == 1) {
            toReturn = artifacts.iterator().next();
        } else if (parentCount > 1) {
            throw new MultipleArtifactsExist("artifact %s branch [%s]-[%s] has %s parents", new Object[]{this.toStringWithId(), this.getBranchToken().getName(), this.getBranchIdString(), parentCount});
        }
        return toReturn;
    }

    public final List<Artifact> getAncestors() {
        ArrayList<Artifact> ancestors = new ArrayList<Artifact>();
        Artifact parent = this.getParent();
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    public final Attribute<?> getAttributeById(long attributeId, boolean includeDeleted) {
        return this.getAttributeById(AttributeId.valueOf((Long)attributeId), includeDeleted);
    }

    public final Attribute<?> getAttributeById(AttributeId attributeId, boolean includeDeleted) {
        for (Attribute<?> attribute : this.getAttributes(includeDeleted)) {
            if (!attributeId.equals(attribute)) continue;
            return attribute;
        }
        return null;
    }

    public final List<AttributeId> getAttributeIds(AttributeTypeId attributeType) {
        ArrayList<AttributeId> items = new ArrayList<AttributeId>();
        List data = this.getAttributes(attributeType);
        for (Attribute attribute : data) {
            items.add((AttributeId)attribute);
        }
        return items;
    }

    public final boolean hasParent() {
        int parentCount = this.getRelatedArtifactsUnSorted(CoreRelationTypes.DefaultHierarchical_Parent).size();
        if (parentCount > 1) {
            throw new MultipleArtifactsExist("artifact [%s] has %d parents", new Object[]{this.getGuid(), parentCount});
        }
        return parentCount == 1;
    }

    public final boolean isNotRootedInDefaultRoot() {
        Artifact root = OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)this.getBranch());
        return !root.equals((Object)this.getTopContainer());
    }

    private Artifact getTopContainer() {
        Artifact root = null;
        if (this.equals((Object)OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)this.getBranch()))) {
            root = this;
        } else {
            HashSet<Artifact> set = new HashSet<Artifact>();
            set.add(this);
            Artifact parent = this.getParent();
            while (parent != null) {
                if (!set.add(parent)) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)String.format("Cycle detected with artifact: %s", new Object[]{parent}));
                    root = null;
                    break;
                }
                root = parent;
                parent = parent.getParent();
            }
        }
        return root;
    }

    public final Artifact getChild(String descriptiveName) {
        for (Artifact artifact : this.getChildren()) {
            if (!artifact.getName().equals(descriptiveName)) continue;
            return artifact;
        }
        throw new ArtifactDoesNotExist("artifact [%s] has no child with the name [%s]", new Object[]{this, descriptiveName});
    }

    public final boolean hasChild(String descriptiveName) {
        for (Artifact artifact : this.getChildren()) {
            if (!artifact.getName().equals(descriptiveName)) continue;
            return true;
        }
        return false;
    }

    public final @NonNull List<Artifact> getChildren() {
        return this.getRelatedArtifacts(CoreRelationTypes.DefaultHierarchical_Child);
    }

    public final List<Artifact> getChildren(DeletionFlag deletionFlag) {
        return this.getRelatedArtifacts(CoreRelationTypes.DefaultHierarchical_Child, deletionFlag);
    }

    public final List<Artifact> getDescendants(DeletionFlag includeDeleted) {
        LinkedList<Artifact> descendants = new LinkedList<Artifact>();
        this.getDescendants(descendants, includeDeleted);
        return descendants;
    }

    public final List<Artifact> getDescendants() {
        LinkedList<Artifact> descendants = new LinkedList<Artifact>();
        this.getDescendants(descendants, DeletionFlag.EXCLUDE_DELETED);
        return descendants;
    }

    public final List<Artifact> getDescendants(ArtifactTypeToken[] excludedArtifacts) {
        LinkedList<Artifact> descendants = new LinkedList<Artifact>();
        this.getDescendants(descendants, excludedArtifacts, DeletionFlag.EXCLUDE_DELETED);
        return descendants;
    }

    private void getDescendants(Collection<Artifact> descendants, DeletionFlag includeDeleted) {
        for (Artifact child : this.getChildren(includeDeleted)) {
            descendants.add(child);
            child.getDescendants(descendants, includeDeleted);
        }
    }

    private void getDescendants(Collection<Artifact> descendants, ArtifactTypeToken[] excludedArtifacts, DeletionFlag includeDeleted) {
        for (Artifact child : this.getChildren(includeDeleted)) {
            if (child.isOfType((ArtifactTypeId[])excludedArtifacts)) continue;
            descendants.add(child);
            child.getDescendants(descendants, excludedArtifacts, includeDeleted);
        }
    }

    public final void addChild(Artifact artifact) {
        this.addChild(RelationSorter.PREEXISTING, artifact);
    }

    public final void addChild(RelationSorter sorterId, Artifact artifact) {
        this.addRelation(sorterId, CoreRelationTypes.DefaultHierarchical_Child, artifact);
    }

    public final Artifact addNewChild(RelationSorter sorterId, ArtifactTypeToken artifactType, String name) {
        Artifact child = ArtifactTypeManager.addArtifact(artifactType, this.branch);
        child.setName(name);
        this.addChild(sorterId, child);
        return child;
    }

    private <T> Attribute<T> createAttribute(AttributeTypeId attributeType) {
        Class<Attribute<?>> attributeClass = AttributeTypeManager.getAttributeBaseClass(attributeType);
        Attribute<?> attribute = null;
        try {
            attribute = attributeClass.newInstance();
            this.attributes.put((Object)attributeType, attribute);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return attribute;
    }

    private <T> Attribute<T> initializeAttribute(AttributeTypeId attributeType, ModificationType modificationType, boolean markDirty, boolean setDefaultValue) {
        Attribute<T> attribute = this.createAttribute(attributeType);
        attribute.internalInitialize(attributeType, this, modificationType, ApplicabilityId.BASE, markDirty, setDefaultValue);
        return attribute;
    }

    public final <T> Attribute<T> internalInitializeAttribute(AttributeTypeToken attributeType, int attributeId, GammaId gammaId, ModificationType modificationType, ApplicabilityId applicabilityId, boolean markDirty, Object ... data) {
        return this.internalInitializeAttribute(attributeType, AttributeId.valueOf((int)attributeId), gammaId, modificationType, applicabilityId, markDirty, data);
    }

    public final <T> Attribute<T> internalInitializeAttribute(AttributeTypeToken attributeType, AttributeId attributeId, GammaId gammaId, ModificationType modificationType, ApplicabilityId applicabilityId, boolean markDirty, Object ... data) {
        Attribute<T> attribute = this.createAttribute((AttributeTypeId)attributeType);
        attribute.internalInitialize((AttributeTypeId)attributeType, this, modificationType, applicabilityId, attributeId, gammaId, markDirty, false);
        attribute.getAttributeDataProvider().loadData(data);
        return attribute;
    }

    public final boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        if (attributeType.equals(CoreAttributeTypes.Name)) {
            return true;
        }
        return this.artifactType.isValidAttributeType(attributeType);
    }

    public final <T> List<Attribute<T>> getAttributesByValue(AttributeTypeId attributeType, Object value) {
        ArrayList<Attribute<T>> filteredList = new ArrayList<Attribute<T>>();
        for (Attribute<T> attribute : this.getAttributes(attributeType)) {
            if (!attribute.getValue().equals(value)) continue;
            filteredList.add(attribute);
        }
        return Collections.castAll(filteredList);
    }

    public final <T> List<Attribute<T>> getAttributes(AttributeTypeId attributeType, DeletionFlag deletionFlag) {
        ArrayList<Attribute<T>> filteredList = new ArrayList<Attribute<T>>();
        for (Attribute<T> attribute : this.getAttributes(attributeType)) {
            if (deletionFlag == DeletionFlag.INCLUDE_DELETED) {
                filteredList.add(attribute);
                continue;
            }
            if (deletionFlag != DeletionFlag.EXCLUDE_DELETED || attribute.isDeleted()) continue;
            filteredList.add(attribute);
        }
        return Collections.castAll(filteredList);
    }

    public final List<Attribute<?>> getAllAttributesIncludingHardDeleted(AttributeTypeId attributeType) {
        this.ensureAttributesLoaded();
        return this.getAttributes((List)this.attributes.getValues((Object)attributeType), true);
    }

    public final List<Attribute<?>> getAttributes() {
        return this.getAttributes(false);
    }

    public final List<Attribute<?>> getAttributes(boolean includeDeleted) {
        this.ensureAttributesLoaded();
        return this.getAttributes(this.attributes.getValues(), includeDeleted);
    }

    private List<Attribute<?>> getAttributes(List<Attribute<?>> attributes, boolean includeDeleted) {
        if (attributes == null) {
            return java.util.Collections.emptyList();
        }
        if (includeDeleted) {
            return attributes;
        }
        return attributes.stream().filter(a -> !a.getModificationType().isHardDeleted()).collect(Collectors.toList());
    }

    public final <T> List<Attribute<T>> getAttributes(AttributeTypeId attributeType) {
        this.ensureAttributesLoaded();
        return Collections.castAll(this.getAttributes((List)this.attributes.getValues((Object)attributeType), false));
    }

    public final List<Attribute<?>> internalGetAttributes() {
        return this.attributes.getValues();
    }

    public final void deleteAttributes(AttributeTypeId attributeType) {
        for (Attribute attribute : this.getAttributes(attributeType)) {
            attribute.delete();
        }
    }

    private void ensureAttributesLoaded() {
        if (!this.isAttributesLoaded() && this.isInDb()) {
            ArtifactLoader.loadArtifactData(this, LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA, BranchManager.isArchived((BranchId)this.getBranch()));
        }
    }

    public final boolean isAttributesLoaded() {
        return !this.attributes.isEmpty();
    }

    public final Collection<AttributeTypeToken> getAttributeTypes() {
        return this.artifactType.getValidAttributeTypes();
    }

    public final Collection<ComputedCharacteristicToken<?>> getComputedCharacteristics() {
        return this.artifactType.getValidComputedCharacteristics();
    }

    public final <T> Attribute<T> getSoleAttribute(AttributeTypeId attributeType) {
        this.ensureAttributesLoaded();
        return (Attribute)Collections.oneOrSentinel(this.getAttributes(attributeType), null);
    }

    private <T> Attribute<T> getOrCreateSoleAttribute(AttributeTypeId attributeType) {
        Attribute<T> attribute = this.getSoleAttribute(attributeType);
        if (attribute == null) {
            if (!this.isAttributeTypeValid(attributeType)) {
                throw new OseeArgumentException("The attribute type %s is not valid for artifacts of type [%s]", new Object[]{attributeType, this.getArtifactTypeName()});
            }
            attribute = this.initializeAttribute(attributeType, ModificationType.NEW, true, true);
        }
        return attribute;
    }

    public <T> List<T> getEnumAttributeValues(AttributeTypeToken attributeType) {
        ArrayList<EnumToken> attributeValues = new ArrayList<EnumToken>();
        if (attributeType.isEnumerated()) {
            ArrayList<T> enumAttributeValues = new ArrayList<T>();
            AttributeTypeEnum attributeTypeEnum = (AttributeTypeEnum)attributeType;
            enumAttributeValues.addAll(this.getAttributeValues((AttributeTypeId)attributeType));
            for (String s : enumAttributeValues) {
                attributeValues.add(attributeTypeEnum.valueFromStorageString(s));
            }
        }
        return attributeValues;
    }

    public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> computedCharacteristic) {
        ArrayList<T> attributeValues = new ArrayList<T>();
        if (!this.artifactType.isComputedCharacteristicValid(computedCharacteristic)) {
            throw new OseeCoreException("Attribute Types on Artifact Type %s do not have valid multiplicity for computed characteristic %s", new Object[]{this.artifactType.getName(), computedCharacteristic.getName()});
        }
        for (AttributeTypeGeneric attributeType : computedCharacteristic.getAttributeTypesToCompute()) {
            if (attributeType.isEnumerated()) {
                attributeValues.addAll(this.getEnumAttributeValues((AttributeTypeToken)attributeType));
                continue;
            }
            attributeValues.addAll(this.getAttributeValues((AttributeTypeId)attributeType));
        }
        return (T)computedCharacteristic.calculate(attributeValues);
    }

    public final <T> T getOrInitializeSoleAttributeValue(AttributeTypeId attributeType) {
        Attribute<T> attribute = this.getOrCreateSoleAttribute(attributeType);
        return (T)attribute.getValue();
    }

    public final <T> T getSoleAttributeValue(AttributeTypeId attributeType) {
        List<Attribute<T>> soleAttributes = this.getAttributes(attributeType);
        if (soleAttributes.isEmpty()) {
            if (!this.isAttributeTypeValid(attributeType)) {
                throw new OseeArgumentException("The attribute type %s is not valid for artifacts of type [%s] on artifact %s on branch [%s]", new Object[]{attributeType, this.getArtifactTypeName(), this.toStringWithId(), this.getBranch()});
            }
            throw new AttributeDoesNotExist("Attribute of type [%s] could not be found on artifact [%s] on branch [%s]", new Object[]{attributeType, this.toStringWithId(), this.getBranch()});
        }
        if (soleAttributes.size() > 1) {
            String errMsg = String.format("Attribute [%s] must have exactly one instance.  It currently has %d for artifact %s; Attributes [%s]", attributeType, soleAttributes.size(), this.toStringWithId(), this.getAttributeString(soleAttributes));
            throw new MultipleAttributesExist(errMsg, new Object[0]);
        }
        return (T)soleAttributes.iterator().next().getValue();
    }

    private <T> String getAttributeString(List<Attribute<T>> attributes) {
        StringBuilder sb = new StringBuilder();
        for (Attribute<T> attr : attributes) {
            sb.append("attribute id=[");
            sb.append(attr.getId());
            sb.append("] gamma=[");
            sb.append(attr.getGammaId());
            sb.append("] ");
        }
        String result = sb.toString();
        return result;
    }

    public final String getSoleAttributeValueAsString(AttributeTypeToken attributeType, String defaultReturnValue) throws MultipleAttributesExist {
        String toReturn = defaultReturnValue;
        if (attributeType.isArtifactId()) {
            List soleAttributes = this.getAttributes((AttributeTypeId)attributeType);
            if (soleAttributes.size() == 1) {
                String value = (String)soleAttributes.iterator().next().getAttributeDataProvider().getData()[0];
                if (value == null) {
                    return defaultReturnValue;
                }
                return value;
            }
            if (soleAttributes.size() > 1) {
                throw new MultipleAttributesExist("Attribute [%s] must have exactly one instance.  It currently has %d for artifact %s on branch [%s]", new Object[]{attributeType, soleAttributes.size(), this.toStringWithId(), this.getBranch()});
            }
            return defaultReturnValue;
        }
        String value = this.getSoleAttributeValue((AttributeTypeId)attributeType, defaultReturnValue);
        if (value instanceof InputStream) {
            InputStream inputStream = (InputStream)((Object)value);
            try {
                try {
                    toReturn = Lib.inputStreamToString((InputStream)inputStream);
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex2) {
                        OseeCoreException.wrapAndThrow((Throwable)ex2);
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        } else if (value != null) {
            toReturn = value.toString();
        }
        return toReturn;
    }

    public final <T> T getSoleAttributeValue(AttributeTypeId attributeType, T defaultReturnValue) {
        List<Attribute<T>> soleAttributes = this.getAttributes(attributeType);
        if (soleAttributes.size() == 1) {
            Object value = soleAttributes.iterator().next().getValue();
            if (value == null) {
                if (!(soleAttributes.iterator().next() instanceof ArtifactReferenceAttribute)) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Attribute \"" + attributeType + "\" has null value for Artifact " + this.getGuid() + " \"" + this.getName() + "\""));
                }
                return defaultReturnValue;
            }
            return (T)value;
        }
        if (soleAttributes.size() > 1) {
            throw new MultipleAttributesExist("Attribute [%s] must have exactly one instance.  It currently has %d for artifact %s on branch [%s]", new Object[]{attributeType, soleAttributes.size(), this.toStringWithId(), this.getBranch()});
        }
        return defaultReturnValue;
    }

    public final void deleteSoleAttribute(AttributeTypeId attributeType) {
        Attribute attribute = this.getSoleAttribute(attributeType);
        if (attribute != null) {
            this.deleteAttribute(attribute);
        }
    }

    public final void deleteAttribute(AttributeTypeId attributeType, Object value) {
        for (Attribute attribute : this.getAttributes(attributeType)) {
            if (!attribute.getValue().equals(value)) continue;
            this.deleteAttribute(attribute);
            break;
        }
    }

    public final void deleteAttribute(AttributeId attributeId) {
        for (Attribute<?> attribute : this.getAttributes()) {
            if (!attributeId.getId().equals(attribute.getId())) continue;
            this.deleteAttribute(attribute);
            break;
        }
    }

    public final void deleteAttribute(Attribute<?> attribute) {
        if (attribute.isInDb()) {
            attribute.delete();
        } else {
            this.attributes.removeValue((Object)attribute.getAttributeType(), attribute);
        }
    }

    public final <T> void setSoleAttributeValue(AttributeTypeId attributeType, T value) {
        this.getOrCreateSoleAttribute(attributeType).setValue(value);
    }

    public final <T> void setSoleAttributeFromString(AttributeTypeId attributeType, String value) {
        this.getOrCreateSoleAttribute(attributeType).setFromString(value);
    }

    public final void setSoleAttributeFromStream(AttributeTypeGeneric<?> attributeType, InputStream stream) {
        this.getOrCreateSoleAttribute((AttributeTypeId)attributeType).setValueFromInputStream(stream);
    }

    public final String getAttributesToStringSorted(AttributeTypeId attributeType) {
        return this.getAttributesToString(attributeType, true);
    }

    public final String getAttributesToString(AttributeTypeId attributeType) {
        return this.getAttributesToString(attributeType, false);
    }

    public final String getAttributesToString(AttributeTypeId attributeType, boolean sorted) {
        ArrayList<String> strs = new ArrayList<String>();
        List attributes = this.getAttributes(attributeType);
        if (sorted) {
            java.util.Collections.sort(attributes);
        }
        for (Attribute attr : attributes) {
            strs.add(String.valueOf(attr));
        }
        return Collections.toString((String)", ", strs);
    }

    public final String getAttributesToStringUnique(AttributeTypeId attributeType, String separator) {
        HashSet<String> strs = new HashSet<String>();
        for (Attribute attr : this.getAttributes(attributeType)) {
            strs.add(String.valueOf(attr));
        }
        return Collections.toString((String)separator, strs);
    }

    public void setSingletonAttributeValue(AttributeTypeId attributeType, String value) {
        List attributes = this.getAttributesByValue(attributeType, value);
        if (attributes.isEmpty()) {
            this.addAttribute(attributeType, value);
        } else if (attributes.size() > 1) {
            int x = 1;
            while (x < attributes.size()) {
                Attribute attr = attributes.get(x);
                attr.delete();
                ++x;
            }
        }
    }

    public void deleteSingletonAttributeValue(AttributeTypeId attributeType, String value) {
        for (Attribute attribute : this.getAttributesByValue(attributeType, value)) {
            attribute.delete();
        }
    }

    public final void setAttributeValues(AttributeTypeId attributeType, Collection<String> newValues) {
        this.ensureAttributesLoaded();
        HashSet<String> uniqueNewValues = new HashSet<String>(newValues);
        List remainingAttributes = this.getAttributes(attributeType);
        ArrayList<String> remainingNewValues = new ArrayList<String>(uniqueNewValues.size());
        for (String string : uniqueNewValues) {
            boolean found = false;
            for (Attribute attribute : remainingAttributes) {
                if (!attribute.getValue().toString().equals(string)) continue;
                remainingAttributes.remove(attribute);
                found = true;
                break;
            }
            if (found) continue;
            remainingNewValues.add(string);
        }
        for (String string : remainingNewValues) {
            if (remainingAttributes.isEmpty()) {
                this.setOrAddAttribute(attributeType, string);
                continue;
            }
            int index = remainingAttributes.size() - 1;
            remainingAttributes.get(index).setFromString(string);
            remainingAttributes.remove(index);
        }
        for (Attribute attribute : remainingAttributes) {
            attribute.delete();
        }
    }

    public final <T> void setAttributeFromValues(AttributeTypeId attributeType, Collection<T> values) {
        this.ensureAttributesLoaded();
        Set uniqueItems = Collections.toSet(values);
        List<Attribute<T>> remainingAttributes = this.getAttributes(attributeType);
        ArrayList remainingNewValues = new ArrayList(uniqueItems.size());
        for (Object e : uniqueItems) {
            boolean found = false;
            for (Attribute<T> attribute : remainingAttributes) {
                if (!e.equals(attribute.getValue())) continue;
                remainingAttributes.remove(attribute);
                found = true;
                break;
            }
            if (found) continue;
            remainingNewValues.add(e);
        }
        for (Object e : remainingNewValues) {
            if (remainingAttributes.isEmpty()) {
                this.setOrAddAttribute(attributeType, e);
                continue;
            }
            int index = remainingAttributes.size() - 1;
            remainingAttributes.get(index).setValue(e);
            remainingAttributes.remove(index);
        }
        for (Attribute attribute : remainingAttributes) {
            attribute.delete();
        }
    }

    public final void setBinaryAttributeFromValues(AttributeTypeId attributeType, Collection<InputStream> values) {
        this.ensureAttributesLoaded();
        List remainingAttributes = this.getAttributes(attributeType);
        for (InputStream inputStream : values) {
            if (remainingAttributes.isEmpty()) {
                this.initializeAttribute(attributeType, ModificationType.NEW, true, false).setValueFromInputStream(inputStream);
                continue;
            }
            int index = remainingAttributes.size() - 1;
            remainingAttributes.get(index).setValueFromInputStream(inputStream);
            remainingAttributes.remove(index);
        }
        for (Attribute attribute : remainingAttributes) {
            attribute.delete();
        }
    }

    public final <T> void addAttribute(AttributeTypeId attributeType, T value) {
        Conditions.checkNotNull(value, (String)"Attribute value", (String)"attribute type [%s]", (Object[])new Object[]{attributeType});
        this.initializeAttribute(attributeType, ModificationType.NEW, true, false).setValue(value);
    }

    public final void addAttribute(AttributeTypeId attributeType) {
        this.initializeAttribute(attributeType, ModificationType.NEW, true, true);
    }

    public final void addAttribute(AttributeTypeToken attributeType) {
        this.initializeAttribute((AttributeTypeId)attributeType, ModificationType.NEW, true, true);
    }

    public final void addAttributeFromString(AttributeTypeId attributeType, String value) {
        Conditions.checkNotNull((Object)value, (String)"Attribute value", (String)"attribute type [%s]", (Object[])new Object[]{attributeType});
        this.initializeAttribute(attributeType, ModificationType.NEW, true, false).setFromString(value);
    }

    private final <T> void setOrAddAttribute(AttributeTypeId attributeType, T value) {
        Conditions.checkNotNull(value, (String)"Attribute value", (String)"attribute type [%s]", (Object[])new Object[]{attributeType});
        List<Attribute<T>> attributes = this.getAttributes(attributeType);
        for (Attribute<T> canidateAttribute : attributes) {
            if (!canidateAttribute.getValue().equals(value)) continue;
            return;
        }
        this.addAttribute(attributeType, value);
    }

    public final List<String> getAttributesToStringList(AttributeTypeId attributeType) {
        this.ensureAttributesLoaded();
        ArrayList<String> items = new ArrayList<String>();
        for (Attribute attribute : this.getAttributes(attributeType)) {
            items.add(attribute.getDisplayableString());
        }
        return items;
    }

    public List<String> getAttributesToStringList(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        this.ensureAttributesLoaded();
        ArrayList<String> items = new ArrayList<String>();
        for (Attribute attribute : this.getAttributes((AttributeTypeId)attributeType, deletionFlag)) {
            items.add(attribute.getDisplayableString());
        }
        return items;
    }

    public final <T> List<T> getAttributeValues(AttributeTypeId attributeType) {
        this.ensureAttributesLoaded();
        ArrayList<Object> items = new ArrayList<Object>();
        List<Attribute<T>> data = this.getAttributes(attributeType);
        for (Attribute<T> attribute : data) {
            Object value = attribute.getValue();
            if (value == null) continue;
            items.add(value);
        }
        return items;
    }

    public String getName() {
        String name = null;
        try {
            this.ensureAttributesLoaded();
            for (Attribute<?> attribute : this.internalGetAttributes()) {
                if (!attribute.isOfType((AttributeTypeId)CoreAttributeTypes.Name)) continue;
                name = (String)attribute.getValue();
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        if (!Strings.isValid(name)) {
            return UNNAMED;
        }
        return name;
    }

    public final void setName(String name) {
        this.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Name, name);
    }

    public void replaceWithVersion(GammaId gammaId) {
        this.replaceWithVersion(gammaId, ModificationType.REPLACED_WITH_VERSION);
    }

    public void replaceWithVersion(GammaId gammaId, ModificationType modType) {
        this.internalSetGammaId(gammaId);
        this.internalSetModType(modType, true);
    }

    private final void internalSetGammaId(GammaId gammaId) {
        this.gammaId = gammaId;
    }

    public final void internalSetApplicablityId(ApplicabilityId applicabilityId) {
        this.applicabilityId = applicabilityId;
    }

    protected final void internalSetModType(ModificationType modType, boolean useBackingData) {
        this.lastValidModType = this.modType;
        this.modType = modType;
        this.useBackingData = useBackingData;
    }

    public final void internalSetDeleted() {
        this.internalSetModType(ModificationType.DELETED, true);
        for (Attribute<?> attribute : this.getAttributes()) {
            attribute.setArtifactDeleted();
        }
    }

    public final void internalSetDeletedFromRemoteEvent() {
        if (!this.isHistorical()) {
            this.modType = ModificationType.DELETED;
            ArtifactCache.deCache(this);
            RelationManager.deCache(this);
            for (Attribute<?> attribute : this.getAttributes()) {
                attribute.internalSetModType(ModificationType.DELETED, true, false);
            }
        }
    }

    public final void resetToPreviousModType() {
        this.modType = this.lastValidModType;
        for (Attribute attribute : this.attributes.getValues()) {
            if (attribute.getModificationType() != ModificationType.ARTIFACT_DELETED) continue;
            attribute.resetModType();
        }
    }

    public final boolean hasDirtyAttributes() {
        for (Attribute<?> attribute : this.internalGetAttributes()) {
            if (!attribute.isDirty()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasDirtyRelations() {
        return RelationManager.hasDirtyLinks(this);
    }

    public final EditState getEditState() {
        return this.objectEditState;
    }

    public final boolean hasDirtyArtifactType() {
        return this.objectEditState.isArtifactTypeChange();
    }

    public final boolean isDirty() {
        return this.hasDirtyAttributes() || this.hasDirtyRelations() || this.hasDirtyArtifactType();
    }

    public final boolean isReadOnly() {
        boolean result = ServiceUtil.getOseeClient().getAccessControlService().isReadOnly((ArtifactToken)this);
        return result;
    }

    public final Artifact reloadAttributesAndRelations() {
        if (!this.isInDb()) {
            return this;
        }
        return ArtifactQuery.reloadArtifactFromId((ArtifactId)this, (BranchId)this.getBranch());
    }

    void prepareForReload() {
        this.attributes.clear();
        this.linksLoaded = false;
        RelationManager.prepareRelationsForReload(this);
    }

    public final TransactionId persist(String comment) {
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.branch, comment);
        this.persist(transaction);
        return transaction.execute();
    }

    public void persistInThread(final String comment) {
        Thread persistThread = new Thread("Persist: [" + comment + "]"){

            @Override
            public void run() {
                Artifact.this.persist(comment);
            }
        };
        persistThread.start();
    }

    public final void persist(SkynetTransaction managedTransaction) {
        managedTransaction.addArtifact(this);
    }

    public final Artifact getDescendant(String ... names) {
        if (names.length == 0) {
            throw new OseeArgumentException("Must suply at least one name to getDescendant()", new Object[0]);
        }
        Artifact descendant = this;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            descendant = descendant.getChild(name);
            ++n2;
        }
        return descendant;
    }

    public final void deleteAndPersist(String comment) {
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.branch, comment);
        this.deleteAndPersist(transaction);
        transaction.execute();
    }

    public final void delete() {
        XResultData rd = ArtifactPersistenceManager.deleteArtifact(null, false, new XResultData(), this);
        rd.exceptionIfErrors("Exception deleting artifact");
    }

    public final void deleteAndPersist(SkynetTransaction transaction, boolean overrideChecks) {
        XResultData rd = ArtifactPersistenceManager.deleteArtifact(transaction, overrideChecks, new XResultData(), this);
        rd.exceptionIfErrors("Exception deleting artifact");
    }

    public final void deleteAndPersist(SkynetTransaction transaction) {
        XResultData rd = ArtifactPersistenceManager.deleteArtifact(transaction, false, new XResultData(), this);
        rd.exceptionIfErrors("Exception deleting artifact");
    }

    public final void purgeFromBranch(boolean purgeChildren) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        artifacts.add(this);
        if (purgeChildren) {
            artifacts.addAll(this.getDescendants());
        }
        Operations.executeWorkAndCheckStatus((IOperation)new PurgeArtifacts(artifacts));
    }

    public final void purgeFromBranch() {
        this.purgeFromBranch(false);
    }

    public final boolean isDeleted() {
        return this.modType == ModificationType.DELETED;
    }

    public final void setLinksLoaded(boolean loaded) {
        this.linksLoaded = loaded;
    }

    public final void addRelation(RelationSorter sorterId, RelationTypeSide relationTypeSide, Artifact artifact, String rationale) {
        Pair<Artifact, Artifact> sides = this.determineArtifactSides(artifact, relationTypeSide);
        int relOrder = 0;
        if (relationTypeSide.getRelationType().isNewRelationTable()) {
            relOrder = this.getNewRelOrder(this.getRelations(relationTypeSide), relationTypeSide, null, artifact);
        }
        RelationManager.addRelation(sorterId, relationTypeSide.getRelationType(), (Artifact)((Object)sides.getFirst()), (Artifact)((Object)sides.getSecond()), rationale, relOrder, ArtifactId.SENTINEL);
    }

    public final void addRelation(RelationSorter sorterId, RelationTypeSide relationTypeSide, Artifact artifact, int relOrder, ArtifactId relArtId) {
        Pair<Artifact, Artifact> sides = this.determineArtifactSides(artifact, relationTypeSide);
        RelationManager.addRelation(sorterId, relationTypeSide.getRelationType(), (Artifact)((Object)sides.getFirst()), (Artifact)((Object)sides.getSecond()), "", relOrder, relArtId);
    }

    public final void addRelation(RelationTypeSide relationSide, Artifact artifact) {
        this.addRelation(RelationSorter.PREEXISTING, relationSide, artifact, null);
    }

    public final void addRelation(RelationSorter sorterId, RelationTypeSide relationSide, Artifact artifact) {
        this.addRelation(sorterId, relationSide, artifact, null);
    }

    public final void addRelation(RelationSorter sorterId, RelationTypeSide relationEnumeration, Artifact targetArtifact, boolean insertAfterTarget, Artifact itemToAdd, String rationale) {
        boolean sideA = relationEnumeration.getSide().isSideA();
        Artifact artifactA = sideA ? itemToAdd : this;
        Artifact artifactB = sideA ? this : itemToAdd;
        RelationManager.addRelation(sorterId, (RelationTypeToken)relationEnumeration, artifactA, artifactB, rationale, 0, ArtifactId.SENTINEL);
        this.setRelationOrder(relationEnumeration, targetArtifact, insertAfterTarget, itemToAdd);
    }

    public final void addRelation(RelationSorter sorterId, RelationTypeSide relationEnumeration, Artifact targetArtifact, boolean insertAfterTarget, Artifact itemToAdd, int relOrder, ArtifactId relArtId) {
        boolean sideA = relationEnumeration.getSide().isSideA();
        Artifact artifactA = sideA ? itemToAdd : this;
        Artifact artifactB = sideA ? this : itemToAdd;
        RelationManager.addRelation(sorterId, (RelationTypeToken)relationEnumeration, artifactA, artifactB, "", relOrder, relArtId);
        this.setRelationOrder(relationEnumeration, targetArtifact, insertAfterTarget, itemToAdd);
    }

    public final void setRelationOrder(RelationTypeSide relationSide, List<Artifact> artifactsInNewOrder) {
        RelationManager.setRelationOrder(this, (RelationTypeToken)relationSide, relationSide.getSide(), RelationSorter.USER_DEFINED, artifactsInNewOrder);
    }

    public final void setRelationOrder(RelationTypeSide relationEnumeration, RelationSorter orderId) {
        if (RelationSorter.USER_DEFINED == orderId) {
            this.setRelationOrder(relationEnumeration, this.getRelatedArtifacts(relationEnumeration));
        } else {
            List<Artifact> empty = java.util.Collections.emptyList();
            RelationManager.setRelationOrder(this, (RelationTypeToken)relationEnumeration, relationEnumeration.getSide(), orderId, empty);
        }
    }

    public final void setRelationOrder(RelationTypeSide relationEnumeration, Artifact targetArtifact, boolean insertAfterTarget, Artifact itemToAdd) {
        boolean result;
        List<Artifact> currentOrder = this.getRelatedArtifacts(relationEnumeration, Artifact.class);
        if (!currentOrder.contains((Object)targetArtifact)) {
            throw new OseeStateException("Could not set Relation Order: target not in list", new Object[0]);
        }
        if (!currentOrder.contains((Object)itemToAdd)) {
            currentOrder.add(itemToAdd);
        }
        if (!(result = Collections.moveItem(currentOrder, (Object)((Object)itemToAdd), (Object)((Object)targetArtifact), (boolean)insertAfterTarget))) {
            throw new OseeStateException("Could not set Relation Order", new Object[0]);
        }
        if (relationEnumeration.getRelationType().isNewRelationTable()) {
            List<RelationLink> relations = this.getRelations(relationEnumeration);
            RelationLink modRelation = relations.stream().filter(a -> a.getArtifactB().equals((Object)itemToAdd)).findFirst().get();
            int relOrder = this.getNewRelOrder(relations, relationEnumeration, targetArtifact, itemToAdd);
            modRelation.setRelOrder(relOrder);
        } else {
            RelationManager.setRelationOrder(this, (RelationTypeToken)relationEnumeration, relationEnumeration.getSide(), RelationSorter.USER_DEFINED, currentOrder);
        }
    }

    private int getNewRelOrder(List<RelationLink> relations, RelationTypeSide relationEnumeration, Artifact targetArtifact, Artifact itemToAdd) {
        String insertType = "end";
        int afterIndex = 0;
        int beforeIndex = 0;
        int maxOrder = 0;
        int minOrder = 0;
        if (!relations.isEmpty()) {
            RelationLink priorRelation;
            maxOrder = relations.stream().max(Comparator.comparing(RelationLink::getRelOrder)).get().getRelOrder();
            minOrder = relations.stream().min(Comparator.comparing(RelationLink::getRelOrder)).get().getRelOrder();
            if (targetArtifact != null && (priorRelation = relations.stream().filter(a -> a.getArtifactB().equals((Object)targetArtifact)).findFirst().get()).isValid()) {
                if (relations.get(0).equals(priorRelation)) {
                    insertType = "first";
                } else {
                    insertType = "insert";
                    afterIndex = relations.get(relations.indexOf(priorRelation) - 1).getRelOrder();
                    beforeIndex = priorRelation.getRelOrder();
                }
            }
        }
        return RelationOrderUtil.getRelOrder((RelationTypeToken)relationEnumeration.getRelationType(), (String)insertType, (int)afterIndex, (int)beforeIndex, (int)minOrder, (int)maxOrder);
    }

    public final void deleteRelation(RelationTypeSide relationTypeSide, Artifact artifact) {
        Pair<Artifact, Artifact> sides = this.determineArtifactSides(artifact, relationTypeSide);
        XResultData rd = ArtifactPersistenceManager.performDeleteRelationChecks(artifact, (RelationTypeToken)relationTypeSide, new XResultData());
        rd.exceptionIfErrors("deleteRelation");
        RelationManager.deleteRelation((RelationTypeToken)relationTypeSide, (Artifact)((Object)sides.getFirst()), (Artifact)((Object)sides.getSecond()));
    }

    public final void deleteRelations(RelationTypeSide relationSide) {
        for (Artifact art : this.getRelatedArtifacts(relationSide)) {
            XResultData rd = ArtifactPersistenceManager.performDeleteRelationChecks(art, (RelationTypeToken)relationSide, new XResultData());
            rd.exceptionIfErrors("deleteRelation");
            this.deleteRelation(relationSide, art);
        }
    }

    public final void setRelations(RelationSorter sorterId, RelationTypeSide relationSide, Collection<? extends Artifact> artifacts) {
        List<Artifact> currentlyRelated = this.getRelatedArtifacts(relationSide, Artifact.class);
        for (Artifact artifact : currentlyRelated) {
            if (artifacts.contains((Object)artifact)) continue;
            this.deleteRelation(relationSide, artifact);
        }
        for (Artifact artifact : artifacts) {
            if (currentlyRelated.contains((Object)artifact)) continue;
            this.addRelation(sorterId, relationSide, artifact);
        }
    }

    public final void setRelations(RelationTypeSide relationSide, Collection<? extends Artifact> artifacts) {
        this.setRelations(RelationSorter.PREEXISTING, relationSide, artifacts);
    }

    public final boolean isLinksLoaded() {
        return this.linksLoaded;
    }

    public final ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public final String getVersionedName() {
        String name = this.getName();
        if (this.isHistorical()) {
            name = String.valueOf(name) + " [Rev:" + this.transaction + "]";
        }
        return name;
    }

    public final String isRelationsAndArtifactsDirty(Set<RelationTypeSide> links) {
        block8: {
            if (!this.hasDirtyAttributes()) break block8;
            for (Attribute<?> attribute : this.internalGetAttributes()) {
                if (!attribute.isDirty()) continue;
                return "===> Dirty Attribute - " + attribute.getAttributeType().getName() + "\n";
            }
            return "Artifact isDirty == true??";
        }
        try {
            for (RelationTypeSide side : links) {
                for (Artifact art : this.getRelatedArtifacts(side)) {
                    if (art.hasDirtyAttributes()) {
                        return String.valueOf(art.getArtifactTypeName()) + " \"" + (Object)((Object)art) + "\" => dirty\n";
                    }
                    for (RelationLink link : this.getRelations(side, art)) {
                        if (!link.isDirty()) continue;
                        return "Link \"" + link + "\" => dirty\n";
                    }
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    public final Artifact duplicate(BranchToken branch) {
        return this.duplicate(branch, new ArrayList<AttributeTypeId>());
    }

    public final Artifact duplicate(BranchToken branch, Collection<AttributeTypeId> excludeAttributeTypes) {
        return this.duplicate(branch, this.getArtifactType(), excludeAttributeTypes);
    }

    public final Artifact duplicate(BranchToken branch, ArtifactTypeToken newType, Collection<AttributeTypeId> excludeAttributeTypes) {
        Artifact newArtifact = ArtifactTypeManager.addArtifact(newType, branch);
        List typesToClear = Collections.setComplement((Collection)newArtifact.attributes.keySet(), excludeAttributeTypes);
        for (AttributeTypeId type : typesToClear) {
            newArtifact.attributes.removeValues((Object)type);
        }
        this.copyAttributes(newArtifact, excludeAttributeTypes);
        return newArtifact;
    }

    public void copyApplicability(Artifact destination) {
        ApplicabilityEndpoint applEndpoint = ServiceUtil.getOseeClient().getApplicabilityEndpoint((BranchId)this.branch);
        try {
            ApplicabilityToken applic = applEndpoint.getApplicabilityToken((ArtifactId)this);
            if (!applic.equals((Object)ApplicabilityId.BASE)) {
                applEndpoint.setApplicability((ApplicabilityId)applic, Arrays.asList(destination));
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void copyAttributes(Artifact artifact, Collection<AttributeTypeId> excludeAttributeTypes) {
        for (Attribute<?> attribute : this.getAttributes()) {
            if (excludeAttributeTypes.contains(attribute.getAttributeType()) || !this.isCopyAllowed(attribute) || !artifact.isAttributeTypeValid((AttributeTypeId)attribute.getAttributeType())) continue;
            artifact.addAttribute((AttributeTypeId)attribute.getAttributeType(), attribute.getValue());
        }
    }

    private boolean isCopyAllowed(Attribute<?> attribute) {
        return attribute != null && !attribute.isOfType((AttributeTypeId)CoreAttributeTypes.RelationOrder);
    }

    public final Artifact reflect(BranchToken destinationBranch) {
        return new IntroduceArtifactOperation(destinationBranch).introduce(this);
    }

    Artifact introduceShallowArtifact(BranchToken destinationBranch) {
        Artifact shallowArt = ArtifactTypeManager.getFactory(this.artifactType).reflectExisitingArtifact((ArtifactId)this, this.getGuid(), this.getArtifactType(), this.gammaId, destinationBranch, this.modType, this.applicabilityId);
        return shallowArt;
    }

    void introduce(Artifact sourceArtifact) {
        this.replaceWithVersion(sourceArtifact.getGammaId(), sourceArtifact.getModType());
    }

    public boolean isUseBackingdata() {
        return this.useBackingData;
    }

    public final TransactionToken getTransaction() {
        return this.transaction;
    }

    public final GammaId getGammaId() {
        return this.gammaId;
    }

    public final ApplicabilityId getApplicablityId() {
        return this.applicabilityId;
    }

    public final Collection<AttributeChange> getDirtyFrameworkAttributeChanges() {
        LinkedList<AttributeChange> dirtyAttributes = new LinkedList<AttributeChange>();
        for (Attribute<?> attribute : this.internalGetAttributes()) {
            if (!attribute.isDirty()) continue;
            AttributeChange change = attribute.createAttributeChangeFromSelf();
            dirtyAttributes.add(change);
        }
        return dirtyAttributes;
    }

    public final void setArtifactType(ArtifactTypeToken artifactType) {
        if (this.artifactType.notEqual((Id)artifactType)) {
            this.artifactType = artifactType;
            this.objectEditState = EditState.ARTIFACT_TYPE_MODIFIED;
            if (this.isInDb()) {
                this.internalSetModType(ModificationType.MODIFIED, false);
            }
        }
    }

    public final void clearEditState() {
        this.objectEditState = EditState.NO_CHANGE;
        this.resetToPreviousModType();
    }

    public final String getSafeName() {
        String elementName = safeNamePattern.matcher(this.getName()).replaceAll("_");
        char firstChar = elementName.charAt(0);
        if (firstChar >= '0' && firstChar <= '9') {
            elementName = String.valueOf(NUMBER[firstChar - 48]) + elementName.substring(1);
        }
        if (elementName.length() > 75) {
            elementName = elementName.substring(0, 75);
        }
        return elementName;
    }

    public final boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals && obj instanceof HasBranch && ((HasBranch)obj).getBranch().isValid()) {
            return this.isOnSameBranch((HasBranch)obj);
        }
        return equals;
    }

    public final int getRemainingAttributeCount(AttributeTypeToken attributeType) {
        return this.artifactType.getMax(attributeType) - this.getAttributeCount((AttributeTypeId)attributeType);
    }

    public final int getAttributeCount(AttributeTypeId attributeType) {
        this.ensureAttributesLoaded();
        return this.getAttributes(attributeType).size();
    }

    public final ArrayList<RelationLink> internalGetRelations(Artifact artifact) {
        ArrayList<RelationLink> relations = new ArrayList<RelationLink>();
        for (RelationLink relation : this.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
            try {
                if (!relation.getOtherSideArtifact((ArtifactId)this).equals((Object)artifact)) continue;
                relations.add(relation);
            }
            catch (ArtifactDoesNotExist ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return relations;
    }

    public final List<RelationLink> getRelations(RelationTypeSide relationEnum) {
        return RelationManager.getRelations(this, (RelationTypeToken)relationEnum, relationEnum.getSide());
    }

    @Deprecated
    public final ArrayList<RelationLink> getRelations(RelationTypeSide side, Artifact artifact) {
        ArrayList<RelationLink> relations = new ArrayList<RelationLink>();
        for (RelationLink relation : this.getRelations(side)) {
            try {
                if (!relation.getOtherSideArtifact((ArtifactId)this).equals((Object)artifact)) continue;
                relations.add(relation);
            }
            catch (ArtifactDoesNotExist ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return relations;
    }

    public final List<RelationLink> getRelationsAll(DeletionFlag deletionFlag) {
        return RelationManager.getRelationsAll(this, deletionFlag);
    }

    void internalSetPersistenceData(GammaId gammaId, TransactionToken transactionId, ModificationType modType, ApplicabilityId applicabilityId, boolean historical, boolean useBackingData) {
        this.gammaId = gammaId;
        this.transaction = transactionId;
        this.historical = historical;
        this.internalSetApplicablityId(applicabilityId);
        this.internalSetModType(modType, useBackingData);
        this.objectEditState = EditState.NO_CHANGE;
    }

    public final void setTransactionId(TransactionRecord transaction) {
        if (transaction.isInvalid()) {
            throw new OseeArgumentException("Transaction can not be set invalid for %s", new Object[]{this.toStringWithId()});
        }
        this.transaction = transaction;
    }

    public final Date getLastModified() {
        if (this.transaction.isValid()) {
            return TransactionManager.getTransaction((TransactionId)this.transaction).getTimeStamp();
        }
        return new Date();
    }

    public final UserToken getLastModifiedBy() {
        if (this.transaction.isInvalid()) {
            return SystemUser.OseeSystem;
        }
        TransactionRecord transactionRecord = TransactionManager.getTransaction((TransactionId)this.transaction);
        return transactionRecord.getAuthor();
    }

    void meetMinimumAttributeCounts(boolean isNewArtifact) {
        if (this.modType == ModificationType.DELETED) {
            return;
        }
        for (AttributeTypeToken attributeType : this.artifactType.getValidAttributeTypes()) {
            int missingCount = this.artifactType.getMin(attributeType) - this.getAttributeCount((AttributeTypeId)attributeType);
            int i = 0;
            while (i < missingCount) {
                this.initializeAttribute((AttributeTypeId)attributeType, ModificationType.NEW, isNewArtifact, true);
                ++i;
            }
        }
    }

    public final ModificationType getModType() {
        return this.modType;
    }

    public final DefaultBasicGuidArtifact getBasicGuidArtifact() {
        return new DefaultBasicGuidArtifact((BranchId)this.getBranch(), (ArtifactToken)this);
    }

    public final EventTopicArtifactTransfer getArtifactTransfer(EventModType eventModType) {
        EventTopicArtifactTransfer transferArt = new EventTopicArtifactTransfer();
        transferArt.setArtifactId((ArtifactId)this);
        transferArt.setBranch((BranchId)this.getBranch());
        transferArt.setArtifactTypeId((ArtifactTypeId)this.getArtifactType());
        transferArt.setEventModType(eventModType);
        return transferArt;
    }

    public final Set<DefaultBasicUuidRelationReorder> getRelationOrderRecords() {
        return this.relationOrderRecords;
    }

    public Set<AttributeTypeToken> getAttributeTypesUsed() {
        HashSet<AttributeTypeToken> types = new HashSet<AttributeTypeToken>();
        for (Attribute<?> attr : this.getAttributes()) {
            types.add(attr.getAttributeType());
        }
        return types;
    }

    public Artifact getRelatedArtifactOrNull(RelationTypeSide relationSide) {
        Artifact artifact = null;
        try {
            artifact = this.getRelatedArtifact(relationSide);
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return artifact;
    }

    public String getGammaIdString() {
        return String.valueOf(this.getGammaId());
    }

    public Collection<String> getTags() {
        return this.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.StaticId);
    }

    public boolean hasTag(String tag) {
        return this.getTags().contains(tag);
    }
}

