/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.ws;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public final class AWorkspace {
    private AWorkspace() {
    }

    public static String getWorkspacePath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public static File iFileToFile(IFile iFile) {
        return new File(iFile.getLocation().toString());
    }

    public static IFile fileToIFile(File file) {
        String p = file.getAbsolutePath();
        Path path = new Path(p);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (iFile.exists()) {
            return iFile;
        }
        p = p.replace('\\', '/');
        IProject[] projs = AWorkspace.getProjects();
        int i = 0;
        while (i < projs.length) {
            IProject proj = projs[i];
            String projLoc = proj.getLocation().toString();
            if (p.equals(projLoc)) {
                return null;
            }
            if (p.startsWith(projLoc)) {
                p = p.replaceFirst(projLoc, "");
                p = "/" + proj.getName() + p;
                path = new Path(p);
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (iFile.exists()) {
                    return iFile;
                }
            }
            ++i;
        }
        return null;
    }

    public static IFile getIFile(String filename) {
        return AWorkspace.fileToIFile(new File(filename));
    }

    public static IProject[] getProjects() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProjects();
    }

    public static boolean showInResourceNavigator(IFile file) {
        if (file == null) {
            return false;
        }
        IWorkbenchPage page = AWorkbench.getActivePage();
        try {
            IViewPart viewPart = page.showView("org.eclipse.ui.views.ResourceNavigator", null, 1);
            if (viewPart != null && viewPart instanceof ResourceNavigator) {
                ResourceNavigator resourceNavigator = (ResourceNavigator)viewPart;
                StructuredSelection ss = new StructuredSelection((Object)file);
                resourceNavigator.selectReveal((ISelection)ss);
                return true;
            }
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean openEditor(String filename) {
        IFile iFile = AWorkspace.getIFile(filename);
        return AWorkspace.openEditor(iFile);
    }

    public static boolean openEditor(IFile iFile) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (boolean)true);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean showInPackageExplorer(IFile file) {
        if (file == null) {
            return false;
        }
        IViewPart p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.jdt.ui.PackageExplorer");
        if (p != null && p instanceof IPackagesViewPart) {
            StructuredSelection ss = new StructuredSelection((Object)file);
            IPackagesViewPart rn = (IPackagesViewPart)p;
            rn.selectAndReveal((Object)ss);
        }
        return true;
    }

    public static void refreshResource(IResource resource) {
        IContainer parentResource = resource.getParent();
        try {
            parentResource.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Refresh Navigator", (String)("Can't refresh \"" + resource.getName() + "\"\n\nYou must refresh Manually"));
            return;
        }
    }

    public static StructuredSelection getSelection() {
        IViewReference[] parts = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < parts.length) {
            StructuredSelection sel = AWorkspace.getSelection(parts[i].getPart(false));
            if (sel != null) {
                return sel;
            }
            ++i;
        }
        return null;
    }

    public static StructuredSelection getSelection(IWorkbenchPart targetPart) {
        if (targetPart instanceof IResourceNavigator) {
            IResourceNavigator navigator = (IResourceNavigator)targetPart;
            return (StructuredSelection)navigator.getViewer().getSelection();
        }
        if (targetPart instanceof IPackagesViewPart) {
            IPackagesViewPart navigator = (IPackagesViewPart)targetPart;
            return (StructuredSelection)navigator.getTreeViewer().getSelection();
        }
        if (targetPart instanceof CommonNavigator) {
            CommonNavigator navigator = (CommonNavigator)targetPart;
            return (StructuredSelection)navigator.getCommonViewer().getSelection();
        }
        return null;
    }

    public static IResource findWorkspaceFile(String fileName) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        AWorkspace.recursiveFileFind(fileName, (IResource)ws, resources);
        return !resources.isEmpty() ? (IResource)resources.iterator().next() : null;
    }

    public static void recursiveFileFind(String fileName, IResource resource, List<IResource> matches) {
        if (resource.getName().equalsIgnoreCase(fileName)) {
            matches.add(resource);
        }
        if (resource instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)resource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    AWorkspace.recursiveFileFind(fileName, res, matches);
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public static List<IResource> findWorkspaceFileMatch(String regex) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        AWorkspace.recursiveFileFindMatch(regex, (IResource)ws, resources);
        return resources;
    }

    private static void recursiveFileFindMatch(String regex, IResource resource, List<IResource> matches) {
        if (1 == resource.getType() && resource.getName().length() > 0 && resource.getName().matches(regex)) {
            matches.add(resource);
        }
        if (resource instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)resource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    AWorkspace.recursiveFileFindMatch(regex, res, matches);
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

