/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.demo.DemoUtil;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.review.DecisionReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.util.Result;

public class Pdd92CreateDemoReviews {
    public void run() {
        this.createPeerToPeerReviews();
        this.createDecisionReviews();
    }

    public void createDecisionReviews() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getClass().getSimpleName());
        Date createdDate = new Date();
        AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
        IAtsDecisionReview review = AtsApiService.get().getReviewService().createValidateReview((IAtsTeamWorkflow)DemoUtil.getButtonWDoesntWorkOnSituationPageWf(), true, createdDate, createdBy, changes);
        Result result = AtsApiService.get().getReviewService().transitionDecisionTo((IAtsDecisionReview)((DecisionReviewArtifact)review.getStoreObject()), DecisionReviewState.Followup, createdBy, false, changes);
        if (result.isFalse()) {
            throw new IllegalStateException("Failed transitioning review to Followup: " + result.getText());
        }
        changes.add((Object)review);
        review = AtsApiService.get().getReviewService().createValidateReview((IAtsTeamWorkflow)DemoUtil.getProblemInDiagramTree_TeamWfWf(), true, createdDate, createdBy, changes);
        AtsApiService.get().getReviewService().transitionDecisionTo((IAtsDecisionReview)((DecisionReviewArtifact)review.getStoreObject()), DecisionReviewState.Completed, createdBy, false, changes);
        if (result.isFalse()) {
            throw new IllegalStateException("Failed transitioning review to Completed: " + result.getText());
        }
        changes.add((Object)review);
        changes.execute();
    }

    public void createPeerToPeerReviews() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Populate Demo DB - Create PeerToPeer Reviews 1");
        TeamWorkFlowArtifact firstCodeArt = DemoUtil.getSawCodeCommittedWf();
        TeamWorkFlowArtifact secondCodeArt = DemoUtil.getSawCodeUnCommittedWf();
        PeerToPeerReviewArtifact reviewArt = (PeerToPeerReviewArtifact)AtsApiService.get().getReviewService().createNewPeerToPeerReview((IAtsTeamWorkflow)firstCodeArt, "Peer Review first set of code changes", firstCodeArt.getCurrentStateName(), changes);
        reviewArt = (PeerToPeerReviewArtifact)AtsApiService.get().getReviewService().createNewPeerToPeerReview((IAtsTeamWorkflow)firstCodeArt, "Peer Review algorithm used in code", firstCodeArt.getCurrentStateName(), changes);
        changes.setSoleAttributeValue((ArtifactId)reviewArt, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"description");
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        roles.add(new UserRole(ReviewRole.Author, DemoUsers.Joe_Smith));
        roles.add(new UserRole(ReviewRole.Reviewer, DemoUsers.Kay_Jones));
        roles.add(new UserRole(ReviewRole.Reviewer, DemoUsers.Alex_Kay, Double.valueOf(2.0), Boolean.valueOf(true)));
        Result result = AtsApiService.get().getReviewService().transitionTo((IAtsPeerToPeerReview)reviewArt, PeerToPeerReviewState.Review, roles, null, AtsApiService.get().getUserService().getCurrentUser(), false, changes);
        if (result.isFalse()) {
            throw new IllegalStateException("Failed transitioning review to Review: " + result.getText());
        }
        changes.add((Object)reviewArt);
        reviewArt = (PeerToPeerReviewArtifact)AtsApiService.get().getReviewService().createNewPeerToPeerReview((IAtsTeamWorkflow)secondCodeArt, "Review new logic", secondCodeArt.getCurrentStateName(), new Date(), AtsApiService.get().getUserService().getUserById((ArtifactId)DemoUsers.Kay_Jones), changes);
        changes.setSoleAttributeValue((ArtifactId)reviewArt, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"description");
        roles = new ArrayList();
        roles.add(new UserRole(ReviewRole.Author, DemoUsers.Kay_Jones, Double.valueOf(2.3), Boolean.valueOf(true)));
        roles.add(new UserRole(ReviewRole.Reviewer, DemoUsers.Joe_Smith, Double.valueOf(4.5), Boolean.valueOf(true)));
        roles.add(new UserRole(ReviewRole.Reviewer, DemoUsers.Alex_Kay, Double.valueOf(2.0), Boolean.valueOf(true)));
        ArrayList<ReviewDefectItem> defects = new ArrayList<ReviewDefectItem>();
        defects.add(new ReviewDefectItem(DemoUsers.Alex_Kay, ReviewDefectItem.Severity.Issue, ReviewDefectItem.Disposition.Accept, ReviewDefectItem.InjectionActivity.Code, "Problem with logic", "Fixed", "Line 234", new Date(), ""));
        defects.add(new ReviewDefectItem(DemoUsers.Alex_Kay, ReviewDefectItem.Severity.Issue, ReviewDefectItem.Disposition.Accept, ReviewDefectItem.InjectionActivity.Code, "Using getInteger instead", "Fixed", "MyWorld.java:Line 33", new Date(), ""));
        defects.add(new ReviewDefectItem(DemoUsers.Alex_Kay, ReviewDefectItem.Severity.Major, ReviewDefectItem.Disposition.Reject, ReviewDefectItem.InjectionActivity.Code, "Spelling incorrect", "Is correct", "MyWorld.java:Line 234", new Date(), ""));
        defects.add(new ReviewDefectItem(DemoUsers.Joe_Smith, ReviewDefectItem.Severity.Minor, ReviewDefectItem.Disposition.Reject, ReviewDefectItem.InjectionActivity.Code, "Remove unused code", "", "Here.java:Line 234", new Date(), ""));
        defects.add(new ReviewDefectItem(DemoUsers.Joe_Smith, ReviewDefectItem.Severity.Major, ReviewDefectItem.Disposition.Accept, ReviewDefectItem.InjectionActivity.Code, "Negate logic", "Fixed", "There.java:Line 234", new Date(), ""));
        for (ReviewDefectItem defect : defects) {
            defect.setClosed(true);
            defect.setClosedUserId(AtsApiService.get().getUserService().getCurrentUserId());
        }
        changes.execute();
        changes = AtsApiService.get().createChangeSet("Populate Demo DB - Create PeerToPeer Reviews 2");
        AtsApiService.get().getReviewService().setPrepareStateData(false, (IAtsPeerToPeerReview)reviewArt, roles, "here", 100, 2.5, changes);
        changes.execute();
        result = AtsApiService.get().getReviewService().transitionTo((IAtsPeerToPeerReview)reviewArt, PeerToPeerReviewState.Completed, roles, defects, AtsApiService.get().getUserService().getCurrentUser(), false, changes);
        if (result.isTrue()) {
            changes.add((Object)reviewArt);
        }
        if (result.isFalse()) {
            throw new IllegalStateException("Failed transitioning review to Completed: " + result.getText());
        }
        changes.execute();
    }
}

