/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCscis;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.ats.ide.demo.config.DemoDbUtil;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.demo.populate.IPopulateDemoDatabase;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class Pdd21CreateUnCommittedAction
implements IPopulateDemoDatabase {
    private ActionResult actionResult;

    @Override
    public void run() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getClass().getSimpleName());
        String title = "SAW (uncommitted) More Reqt Changes for Diagram View";
        Collection<IAtsActionableItem> aias = DemoDbUtil.getActionableItems(new ArtifactToken[]{DemoArtifactToken.SAW_Code_AI, DemoArtifactToken.SAW_SW_Design_AI, DemoArtifactToken.SAW_Requirements_AI, DemoArtifactToken.SAW_Test_AI});
        Date createdDate = new Date();
        AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
        String priority = "3";
        this.actionResult = AtsApiService.get().getActionService().createAction(null, title, "Problem with the Diagram View", ChangeTypes.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        for (IAtsTeamWorkflow teamWf : this.actionResult.getTeamWfs()) {
            Result result;
            boolean isSwDesign = teamWf.getTeamDefinition().getName().contains("SW Design");
            TeamWorkFlowManager dtwm = new TeamWorkFlowManager(teamWf, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.None});
            if (isSwDesign) {
                result = dtwm.transitionTo(TeamState.Analyze, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
                if (result.isFalse()) {
                    throw new OseeCoreException("Error transitioning [%s] to Analyze state [%s] error [%s]", new Object[]{teamWf.toStringWithId(), toState.getName(), result.getText()});
                }
                if (AtsApiService.get().getReviewService().getReviews(teamWf).size() != 1) {
                    throw new OseeCoreException("Error, 1 review should have been created instead of " + AtsApiService.get().getReviewService().getReviews(teamWf).size(), new Object[0]);
                }
                for (IAtsAbstractReview review : AtsApiService.get().getReviewService().getReviews(teamWf)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
                }
                result = dtwm.transitionTo(TeamState.Authorize, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
                if (result.isFalse()) {
                    throw new OseeCoreException("Error transitioning [%s] to Authorize state: [%s]", new Object[]{teamWf.toStringWithId(), toState.getName(), result.getText()});
                }
                if (AtsApiService.get().getReviewService().getReviews(teamWf).size() != 2) {
                    throw new OseeCoreException("Error, 2 AtsApiService.get().getReviewService().getReviews(teamWf) should exist instead of " + AtsApiService.get().getReviewService().getReviews(teamWf).size(), new Object[0]);
                }
                for (IAtsAbstractReview review : AtsApiService.get().getReviewService().getReviews(teamWf)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
                }
            }
            if (isSwDesign) {
                changes.execute();
                changes = AtsApiService.get().createChangeSet(String.valueOf(this.getClass().getSimpleName()) + "- 2");
            }
            if ((result = dtwm.transitionTo(toState, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes)).isFalse()) {
                throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), toState.getName(), result.getText()});
            }
            if (!teamWf.isCompletedOrCancelled()) {
                teamWf.getStateMgr().setAssignees(AtsApiService.get().getTeamDefinitionService().getLeads(teamWf.getTeamDefinition()));
            }
            this.setVersion(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2, changes);
            changes.add((Object)teamWf);
        }
        changes.execute();
        TeamWorkFlowArtifact reqTeamArt = null;
        for (IAtsTeamWorkflow teamWf : this.actionResult.getTeamWfs()) {
            if (!teamWf.getTeamDefinition().getName().contains("Req")) continue;
            reqTeamArt = (TeamWorkFlowArtifact)teamWf.getStoreObject();
        }
        if (reqTeamArt == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
        Result result = AtsApiService.get().getBranchServiceIde().createWorkingBranch_Validate(reqTeamArt);
        if (result.isFalse()) {
            throw new OseeArgumentException("Error creating working branch: " + result.getText(), new Object[0]);
        }
        AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)reqTeamArt, true);
        for (Artifact art : DemoDbUtil.getSoftwareRequirements(false, DemoDbUtil.SoftwareRequirementStrs.Functional, (BranchId)reqTeamArt.getWorkingBranch())) {
            art.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.CSCI, (Object)DemoCscis.Interface.name());
            art.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            Artifact comArt = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Component, (String)DemoSubsystems.Robot_API.name(), (BranchId)reqTeamArt.getWorkingBranch());
            art.addRelation(CoreRelationTypes.Allocation_Component, comArt);
            art.persist(this.getClass().getSimpleName());
        }
        for (Artifact art : DemoDbUtil.getSoftwareRequirements(false, DemoDbUtil.SoftwareRequirementStrs.CISST, (BranchId)reqTeamArt.getWorkingBranch())) {
            art.deleteAndPersist(this.getClass().getSimpleName());
        }
        Artifact parentArt = DemoDbUtil.getInterfaceInitializationSoftwareRequirement(false, (BranchId)reqTeamArt.getWorkingBranch());
        int x = 15;
        while (x < 17) {
            String name = "Claw Interface Init " + x;
            Artifact newArt = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.SoftwareRequirementMsWord, (BranchToken)parentArt.getBranch(), (String)name);
            newArt.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            parentArt.addChild(newArt);
            newArt.persist(this.getClass().getSimpleName());
            ++x;
        }
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Test_AI)) {
                return DemoArtifactToken.SAW_UnCommited_Test_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Code_AI)) {
                return DemoArtifactToken.SAW_UnCommited_Code_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Requirements_AI)) {
                return DemoArtifactToken.SAW_UnCommited_Req_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_SW_Design_AI)) {
                return DemoArtifactToken.SAW_UnCommited_SWDesign_TeamWf;
            }
            throw new UnsupportedOperationException();
        }
    }
}

