/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.config.AtsConfig2ExampleNavigateItem;
import org.eclipse.osee.ats.ide.config.version.CreateNewVersionItem;
import org.eclipse.osee.ats.ide.config.version.ReleaseVersionItem;
import org.eclipse.osee.ats.ide.demo.DemoUtil;
import org.eclipse.osee.ats.ide.demo.internal.Activator;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.demo.navigate.CreateGoalTestDemoArtifacts;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.navigate.ToggleAtsAdmin;
import org.eclipse.osee.ats.ide.util.CreateActionUsingAllActionableItems;
import org.eclipse.osee.ats.ide.world.search.ArtifactTypeSearchItem;
import org.eclipse.osee.ats.ide.world.search.ArtifactTypeWithInheritenceSearchItem;
import org.eclipse.osee.ats.ide.world.search.ILazyTeamDefinitionProvider;
import org.eclipse.osee.ats.ide.world.search.NextVersionSearchItem;
import org.eclipse.osee.ats.ide.world.search.OpenWorkflowsByTeamDefSearchItem;
import org.eclipse.osee.ats.ide.world.search.VersionTargetedForTeamSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemFolder;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateUrlItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class DemoNavigateViewItems
implements XNavigateItemProvider {
    private static final XNavItemCat JOHN_HOPKINS_UNIV_JHU = new XNavItemCat("John Hopkins Univ (JHU)");
    private static final XNavItemCat JHU_ADMIN = new XNavItemCat(JOHN_HOPKINS_UNIV_JHU + ".Admin");
    private static final XNavItemCat JHU_HEALTH = new XNavItemCat(JOHN_HOPKINS_UNIV_JHU + ".Health");
    private final List<ArtifactToken> teams = Arrays.asList(DemoArtifactToken.Process_Team, DemoArtifactToken.Tools_Team, DemoArtifactToken.SAW_SW, DemoArtifactToken.CIS_SW);
    private final List<ArtifactToken> swTeams = Arrays.asList(DemoArtifactToken.SAW_HW, DemoArtifactToken.SAW_Code, DemoArtifactToken.SAW_Test, DemoArtifactToken.SAW_SW_Design, DemoArtifactToken.SAW_Requirements);
    private final List<ArtifactToken> cisTeams = Arrays.asList(DemoArtifactToken.CIS_Code, DemoArtifactToken.CIS_Test, DemoArtifactToken.Facilities_Team);

    public boolean isApplicable() {
        return DemoNavigateViewItems.getTeamDef((ArtifactToken)DemoArtifactToken.Process_Team) != null;
    }

    public List<XNavigateItem> getNavigateItems(List<XNavigateItem> items) {
        if (DemoUtil.isDbPopulatedWithDemoData().isTrue()) {
            items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.DEMO.getName(), (OseeImage)AtsImage.DEMO, new XNavItemCat[]{XNavItemCat.MID_TOP}));
            items.add((XNavigateItem)new XNavigateItemFolder(JOHN_HOPKINS_UNIV_JHU.getName(), new XNavItemCat[]{JOHN_HOPKINS_UNIV_JHU, XNavItemCat.PROG}));
            items.add((XNavigateItem)new ToggleAtsAdmin());
            this.addTeamItems(items);
            items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new ArtifactTypeSearchItem("Show all Actions", AtsArtifactTypes.Action), new XNavItemCat[]{JHU_ADMIN}));
            items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new ArtifactTypeSearchItem("Show all Decision Review", AtsArtifactTypes.DecisionReview), new XNavItemCat[]{JHU_ADMIN}));
            items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new ArtifactTypeSearchItem("Show all PeerToPeer Review", AtsArtifactTypes.PeerToPeerReview), new XNavItemCat[]{JHU_ADMIN}));
            items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new ArtifactTypeWithInheritenceSearchItem("Show all Team Workflows", AtsArtifactTypes.TeamWorkflow), new XNavItemCat[]{JHU_ADMIN, XNavItemCat.OSEE_ADMIN}));
            items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new ArtifactTypeSearchItem("Show all Tasks", AtsArtifactTypes.Task), new XNavItemCat[]{JHU_ADMIN}));
            items.add((XNavigateItem)new CreateGoalTestDemoArtifacts(JHU_HEALTH));
            items.add((XNavigateItem)new CreateActionUsingAllActionableItems(new XNavItemCat[]{XNavigateItem.DEMO}));
            items.add((XNavigateItem)new AtsConfig2ExampleNavigateItem());
        }
        return items;
    }

    private void addTeamItems(List<XNavigateItem> items) {
        List<ArtifactToken> progTeams;
        for (ArtifactToken artifactToken : this.teams) {
            String teamCatName = this.getTeamCategoryName(artifactToken);
            XNavItemCat teamCat = new XNavItemCat(teamCatName);
            items.add((XNavigateItem)new XNavigateItemFolder(artifactToken.getName(), new XNavItemCat[]{teamCat, XNavItemCat.SUBCAT}));
        }
        for (ArtifactToken artifactToken : Arrays.asList(DemoArtifactToken.SAW_SW, DemoArtifactToken.CIS_SW)) {
            progTeams = null;
            progTeams = artifactToken.equals(DemoArtifactToken.SAW_SW) ? this.swTeams : this.cisTeams;
            for (ArtifactToken team : progTeams) {
                String teamCatName = this.getProgTeamCategoryName(artifactToken, team);
                XNavItemCat teamCat = new XNavItemCat(teamCatName);
                items.add((XNavigateItem)new XNavigateItemFolder(team.getName(), new XNavItemCat[]{teamCat, XNavItemCat.SUBCAT}));
            }
        }
        items.add((XNavigateItem)new XNavigateItemFolder("JHU Admin", (KeyedImage)FrameworkImage.LASER, new XNavItemCat[]{JHU_ADMIN, XNavItemCat.SUBCAT}));
        items.add((XNavigateItem)new XNavigateItemFolder("Health", (KeyedImage)FrameworkImage.HEALTH, new XNavItemCat[]{JHU_HEALTH, XNavItemCat.SUBCAT}));
        items.add((XNavigateItem)new XNavigateUrlItem("Open JHU Website - Externally", "http://www.jhu.edu/", true, JOHN_HOPKINS_UNIV_JHU));
        items.add((XNavigateItem)new XNavigateUrlItem("Open JHU Website - Internally", "http://www.jhu.edu/", false, JOHN_HOPKINS_UNIV_JHU));
        for (ArtifactToken artifactToken : this.teams) {
            try {
                IAtsTeamDefinition teamDef = DemoNavigateViewItems.getTeamDef(artifactToken);
                String teamCatName = this.getTeamCategoryName(artifactToken);
                XNavItemCat teamCat = new XNavItemCat(teamCatName);
                if (teamDef == null) continue;
                items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Open " + teamDef + " Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(teamDef))), new XNavItemCat[]{teamCat}));
                if (!AtsApiService.get().getVersionService().isTeamUsesVersions(teamDef)) continue;
                if (artifactToken.getName().contains("SAW")) {
                    items.add((XNavigateItem)new XNavigateUrlItem("Open SAW Website", "http://www.cisst.org/cisst/saw/", false, teamCat));
                } else if (artifactToken.getName().contains("CIS")) {
                    items.add((XNavigateItem)new XNavigateUrlItem("Open CIS Website", "http://www.cisst.org/cisst/cis/", false, teamCat));
                }
                items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new NextVersionSearchItem(teamDef, WorldSearchItem.LoadView.WorldEditor), new XNavItemCat[]{teamCat}));
                items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new VersionTargetedForTeamSearchItem(teamDef, null, false, WorldSearchItem.LoadView.WorldEditor), new XNavItemCat[]{teamCat}));
                items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Un-Released Team Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(teamDef)), true, ReleasedOption.UnReleased), new XNavItemCat[]{teamCat}));
                items.add((XNavigateItem)new ReleaseVersionItem(teamDef, teamCat));
                items.add((XNavigateItem)new CreateNewVersionItem(teamDef, teamCat));
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        for (ArtifactToken artifactToken : Arrays.asList(DemoArtifactToken.SAW_SW, DemoArtifactToken.CIS_SW)) {
            progTeams = null;
            progTeams = artifactToken.equals(DemoArtifactToken.SAW_SW) ? this.swTeams : this.cisTeams;
            for (ArtifactToken team : progTeams) {
                try {
                    IAtsTeamDefinition teamDef = DemoNavigateViewItems.getTeamDef(team);
                    String teamCatName = this.getProgTeamCategoryName(artifactToken, team);
                    XNavItemCat teamCat = new XNavItemCat(teamCatName);
                    items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Open " + teamDef + " Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(teamDef))), new XNavItemCat[]{teamCat}));
                    if (teamDef == null || !AtsApiService.get().getVersionService().isTeamUsesVersions(teamDef)) continue;
                    items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Un-Released Team Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(teamDef)), true, ReleasedOption.UnReleased), new XNavItemCat[]{teamCat}));
                    items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new NextVersionSearchItem(teamDef, WorldSearchItem.LoadView.WorldEditor), new XNavItemCat[]{teamCat}));
                    items.add((XNavigateItem)new SearchNavigateItem((WorldSearchItem)new VersionTargetedForTeamSearchItem(teamDef, null, false, WorldSearchItem.LoadView.WorldEditor), new XNavItemCat[]{teamCat}));
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
    }

    private String getTeamCategoryName(ArtifactToken team) {
        return JOHN_HOPKINS_UNIV_JHU + "." + team.getName().replaceAll("_", " ");
    }

    private String getProgTeamCategoryName(ArtifactToken prog, ArtifactToken team) {
        return JOHN_HOPKINS_UNIV_JHU + "." + prog.getName().replaceAll("_", "") + "." + team.getName().replaceAll("_", " ");
    }

    private static IAtsTeamDefinition getTeamDef(ArtifactToken team) {
        TeamDefinition results = null;
        if (!ClientSessionManager.isProductionDataStore()) {
            try {
                results = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)team);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return results;
    }

    private class SimpleTeamDefinitionProvider
    implements ILazyTeamDefinitionProvider {
        private final Collection<IAtsTeamDefinition> teamDefs;

        public SimpleTeamDefinitionProvider(Collection<IAtsTeamDefinition> teamDefs) {
            this.teamDefs = teamDefs;
        }

        public Collection<IAtsTeamDefinition> getTeamDefs() {
            return this.teamDefs;
        }
    }
}

