/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt.hex;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.hex.CustomTextCellEditor;
import org.eclipse.osee.framework.ui.swt.hex.HexTableRow;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HexEditingSupport
extends EditingSupport {
    private final TextCellEditor textEditor;
    private final int column;
    private final TableViewer viewer;

    public HexEditingSupport(Font font, TableViewer viewer, int column) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.textEditor = new CustomTextCellEditor((Composite)viewer.getTable(), 4);
        ((Text)this.textEditor.getControl()).setTextLimit(2);
        this.textEditor.getControl().setFont(font);
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        return ((HexTableRow)element).length > this.column;
    }

    protected CellEditor getCellEditor(Object element) {
        HexTableRow row = (HexTableRow)element;
        int index = row.offset / row.length;
        Rectangle rect = this.viewer.getTable().getItem(index).getBounds(this.column);
        rect.width = 20;
        this.textEditor.getControl().setBounds(rect);
        return this.textEditor;
    }

    protected Object getValue(Object element) {
        HexTableRow row = (HexTableRow)element;
        return String.format("%02X", row.array[row.offset + this.column] & 0xFF);
    }

    protected void setValue(Object element, Object value) {
        HexTableRow row = (HexTableRow)element;
        String strValue = value.toString();
        try {
            int val = Integer.parseInt(strValue, 16);
            if (val < 0 || val > 255) {
                throw new NumberFormatException("value out of range. Must be between 00 and FF");
            }
            row.array[row.offset + this.column] = (byte)val;
            this.getViewer().update((Object)row, null);
        }
        catch (NumberFormatException e) {
            MessageDialog.openError((Shell)Displays.getActiveShell(), (String)"Numeric Entry Error", (String)e.getMessage());
        }
    }
}

