/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeViewerUtility {
    private static final Object dummy = new Object();

    public static <A> void getPreorderSelection(TreeViewer treeViewer, List<A> selectedTreeItems) {
        HashMap expansionHash = new HashMap();
        HashMap selectionHash = new HashMap();
        TreeViewerUtility.populateSelectionHash(treeViewer, selectionHash);
        TreeViewerUtility.populateExpansionHash(treeViewer, expansionHash);
        TreeViewerUtility.traverseTree(((ITreeContentProvider)treeViewer.getContentProvider()).getChildren(treeViewer.getInput()), (ITreeContentProvider)treeViewer.getContentProvider(), selectedTreeItems, selectionHash, expansionHash);
    }

    private static <A> void populateExpansionHash(TreeViewer tree, Map<A, Object> selectionHash) {
        Object[] objectArray = tree.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            selectionHash.put(obj, dummy);
            ++n2;
        }
    }

    private static <A> void populateSelectionHash(TreeViewer tree, Map<A, Object> selectionHash) {
        Iterator iterator = ((IStructuredSelection)tree.getSelection()).iterator();
        while (iterator.hasNext()) {
            selectionHash.put(iterator.next(), dummy);
        }
    }

    private static <A> void traverseTree(Object[] items, ITreeContentProvider contentProvider, List<A> selectedTreeItems, Map<A, Object> selectionHash, Map<A, Object> expandedHash) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (selectionHash.containsKey(item)) {
                selectedTreeItems.add(item);
            }
            if (expandedHash.containsKey(item)) {
                expandedHash.remove(item);
                TreeViewerUtility.traverseTree(contentProvider.getChildren(item), contentProvider, selectedTreeItems, selectionHash, expandedHash);
            }
            ++n2;
        }
    }
}

