/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Network;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.osgi.service.prefs.BackingStoreException;

public class CorePreferences {
    public static final String INETADDRESS_KEY = "org.eclipse.osee.framework.plugin.core.preferences.InetAddressDefault";

    private CorePreferences() {
    }

    public static InetAddress getDefaultInetAddress() throws UnknownHostException {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("org.eclipse.osee.framework.plugin.core");
        String inetaddress = prefs.get(INETADDRESS_KEY, Network.getValidIP().getHostAddress());
        if (Strings.isValid((String)inetaddress)) {
            return InetAddress.getByName(inetaddress);
        }
        return Network.getValidIP();
    }

    public static void setDefaultAddress(String hostAddress) {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("org.eclipse.osee.framework.plugin.core");
        node.put(INETADDRESS_KEY, hostAddress);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new OseeCoreException("Error saving OSEE Preferences", (Throwable)e);
        }
    }
}

