/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.FilenameFactory;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class RendererUtil {
    private static String[] BAD_PATH_SEGMENTS = new String[]{".", ".."};
    private static Pattern PATH_SPLITTER_PATTERN = Pattern.compile("/|\\\\");
    private static EnumMap<PresentationType, IFolder> workingFolderCache = new EnumMap(PresentationType.class);

    public static Optional<IFolder> ensureRenderFolderExists(PresentationType presentationType) {
        return Objects.nonNull((Object)presentationType) && presentationType.isSubFolderDefined() ? Optional.ofNullable(RendererUtil.getOrCreateFolder(presentationType)) : Optional.empty();
    }

    private static IFolder getFolderWithCreate(IFolder iFolder, String subFolderName) {
        try {
            IFolder subFolder = iFolder.getFolder(subFolderName);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            return subFolder;
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"RendererUtil::getFolderWithCreate, Failed to create a sub-folder.").indentInc().segment((CharSequence)"Root Folder", (Object)iFolder).segment((CharSequence)"Subfolder Name", (Object)subFolderName).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IFolder getOrCreateFolder(PresentationType presentationType) {
        try {
            EnumMap<PresentationType, IFolder> enumMap = workingFolderCache;
            synchronized (enumMap) {
                IFolder folder;
                IFolder cachedFolder = workingFolderCache.get((Object)presentationType);
                IFolder iFolder = folder = Objects.nonNull(cachedFolder) && cachedFolder.exists() ? cachedFolder : OseeData.getFolder(presentationType.getSubFolder());
                if (Objects.isNull(cachedFolder)) {
                    workingFolderCache.put(presentationType, folder);
                }
                return folder;
            }
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"RendererUtil::getOrCreateFolder, Failed to test or create a workspace presentation sub-folder.").indentInc().segment((CharSequence)"Presentation Type", (Object)presentationType).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    public static IFile getRenderFile(PresentationType presentationType, IPath folderSubPath, String fileName) {
        Objects.requireNonNull(presentationType, "RendererUtil::getRenderFile, The parameter \"presentationType\" cannot be null.");
        Objects.requireNonNull(fileName, "RendererUtil::getRenderFile, The parameter \"fileName\" cannot be null.");
        IFolder cursorFolder = RendererUtil.ensureRenderFolderExists(presentationType).orElseThrow(() -> new OseeCoreException(new Message().title((CharSequence)"RendererUtil::getRenderFile, Cannot locate presentation folder.").indentInc().segment((CharSequence)"Presentation Type", (Object)presentationType).segment((CharSequence)"Presentation Folder SubPath", (Object)folderSubPath).segment((CharSequence)"Filename", (Object)fileName).toString(), new Object[0]));
        if (Objects.nonNull(folderSubPath)) {
            if (folderSubPath.isAbsolute()) {
                throw new IllegalArgumentException("RendererUtil::getRenderFile, The parameter \"presentationFolderSubPath\" cannot be absolute.");
            }
            int i = 0;
            int l = folderSubPath.segmentCount();
            while (i < l) {
                String segment = folderSubPath.segment(i);
                cursorFolder = RendererUtil.getFolderWithCreate(cursorFolder, segment);
                ++i;
            }
        }
        return cursorFolder.getFile(fileName);
    }

    public static Optional<IFile> getRenderFile(PresentationType presentationType, String subFolder, String fileName) {
        Objects.requireNonNull(presentationType, "RendererUtil::getRenderFile, The parameter \"presentationType\" cannot be null.");
        if (Strings.isInvalidOrBlank((String)fileName)) {
            return Optional.empty();
        }
        if (Strings.isInvalidOrBlank((String)subFolder)) {
            return RendererUtil.ensureRenderFolderExists(presentationType).map(iFolderWorkspace -> iFolderWorkspace.getFile(fileName));
        }
        return RendererUtil.ensureRenderFolderExists(presentationType).map(iFolderWorkspace -> iFolderWorkspace.getFolder(subFolder)).map(iFolderSubFolder -> {
            if (!iFolderSubFolder.exists()) {
                try {
                    iFolderSubFolder.create(true, true, null);
                }
                catch (Exception e) {
                    throw new OseeCoreException(new Message().title((CharSequence)"RendererUtil::getRenderFile, Failed to create a sub-directory.").indentInc().segment((CharSequence)"IFolder", iFolderSubFolder).reasonFollows((Throwable)e).toString(), (Throwable)e);
                }
            }
            return iFolderSubFolder.getFile(fileName);
        });
    }

    public static IPath makeRenderPath(CharSequence pathString) {
        if (Strings.isInvalid((CharSequence[])new CharSequence[]{pathString})) {
            return null;
        }
        IPath[] pathArray = new IPath[]{new Path("")};
        PATH_SPLITTER_PATTERN.splitAsStream(pathString).map(FilenameFactory::makeNameSafer).filter(Strings::isValidAndNonBlank).filter(pathSegment -> Strings.notEquals((String)pathSegment, (String[])BAD_PATH_SEGMENTS)).forEach(sb -> {
            iPathArray[0] = pathArray[0].append(sb);
        });
        IPath path = pathArray[0];
        if (path.segmentCount() == 0) {
            return null;
        }
        return path;
    }
}

