/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.impl.manager.AbstractPrototypeRefPair;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.osgi.framework.ServiceReference;

public class MultiplePrototypeRefPair<S, T>
extends AbstractPrototypeRefPair<S, T> {
    private final ConcurrentMap<ComponentContextImpl<S>, T> instances = new ConcurrentHashMap<ComponentContextImpl<S>, T>();

    public MultiplePrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public String toString() {
        return "[MultiplePrototypeRefPair: ref: [" + this.getRef() + "] has service: [" + !this.instances.isEmpty() + "]]";
    }

    @Override
    public T getServiceObject(ComponentContextImpl<S> key) {
        return (T)this.instances.get(key);
    }

    @Override
    public boolean setServiceObject(ComponentContextImpl<S> key, T serviceObject) {
        return this.instances.putIfAbsent(key, serviceObject) == null;
    }

    @Override
    protected T remove(ComponentContextImpl<S> key) {
        return (T)this.instances.remove(key);
    }

    @Override
    protected Collection<Map.Entry<ComponentContextImpl<S>, T>> clearEntries() {
        ArrayList<Map.Entry<ComponentContextImpl<S>, T>> result = new ArrayList<Map.Entry<ComponentContextImpl<S>, T>>(this.instances.entrySet());
        this.instances.clear();
        return result;
    }
}

