/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.operation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.access.AccessControlData;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.access.operation.ArtifactAclOperations;
import org.eclipse.osee.framework.core.access.operation.BranchAclOperations;
import org.eclipse.osee.framework.core.access.operation.UserGroupOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;

public class AccessCache {
    public final Map<Long, IUserGroup> idToUserGroup = new HashMap<Long, IUserGroup>();
    public final DoubleKeyHashMap<Long, AccessObject, PermissionEnum> accessControlListCache = new DoubleKeyHashMap();
    public final HashCollection<AccessObject, ArtifactId> objectToSubjectCache = new HashCollection(true);
    public final HashCollection<Long, ArtifactId> subjectToGroupCache = new HashCollection(true);
    public final HashCollection<Long, ArtifactId> groupToSubjectsCache = new HashCollection(true);
    public final CompositeKeyHashMap<BranchId, ArtifactId, ArtifactId> artifactLockCache = new CompositeKeyHashMap();
    private ArtifactAclOperations artAclOps;
    private BranchAclOperations brchAclOps;
    private UserGroupOperations userGrpOps;
    private final IAccessControlService accessService;

    public AccessCache(IAccessControlService accessService) {
        this.accessService = accessService;
    }

    public void cacheAccessObject(ArtifactId subjectId, PermissionEnum permission, AccessObject accessObject) {
        this.accessControlListCache.put((Object)subjectId.getId(), (Object)accessObject, (Object)permission);
        this.objectToSubjectCache.put((Object)accessObject, (Object)subjectId);
    }

    public void initializeCaches() {
        this.accessControlListCache.clear();
        this.objectToSubjectCache.clear();
        this.subjectToGroupCache.clear();
        this.groupToSubjectsCache.clear();
        this.artifactLockCache.clear();
    }

    public void cacheAccessControlData(AccessControlData data) {
        AccessObject accessObject = data.getObject();
        PermissionEnum permission = data.getPermission();
        ArtifactToken subject = data.getSubject();
        if (!permission.equals((Object)PermissionEnum.USER_LOCK)) {
            this.accessControlListCache.put((Object)data.getSubject().getId(), (Object)accessObject, (Object)permission);
            this.objectToSubjectCache.put((Object)accessObject, (Object)subject);
            this.accessService.populateGroupMembers(subject);
        }
    }

    public void deCacheAccessControlData(AccessControlData data) {
        if (data == null) {
            throw new IllegalArgumentException("Can not remove a null AccessControlData.");
        }
        AccessObject accessObject = data.getObject();
        ArtifactToken subject = data.getSubject();
        this.accessControlListCache.remove((Object)data.getSubject().getId(), (Object)accessObject);
        this.objectToSubjectCache.removeValue((Object)accessObject, (Object)subject);
        Collection members = this.groupToSubjectsCache.getValues((Object)subject.getId());
        if (members != null) {
            for (ArtifactId member : members) {
                this.subjectToGroupCache.removeValue((Object)member.getId(), (Object)subject);
            }
        }
        this.groupToSubjectsCache.removeValues((Object)subject.getId());
        if (!this.objectToSubjectCache.containsKey((Object)accessObject)) {
            accessObject.removeFromCache();
        }
    }

    public ArtifactAclOperations getArtAclOps() {
        return this.artAclOps;
    }

    public BranchAclOperations getBrchAclOps() {
        return this.brchAclOps;
    }

    public UserGroupOperations getUserGrpOps() {
        return this.userGrpOps;
    }

    public void setArtAclOps(ArtifactAclOperations artAclOps) {
        this.artAclOps = artAclOps;
    }

    public void setBrchAclOps(BranchAclOperations brchAclOps) {
        this.brchAclOps = brchAclOps;
    }

    public void setUserGrpOps(UserGroupOperations userGrpOps) {
        this.userGrpOps = userGrpOps;
    }
}

