/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.CellData;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSheetWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelColumn;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;

public final class ExcelXmlWriter
extends AbstractSheetWriter {
    public static final String WrappedStyle = "OseeWraped";
    public static final Pattern stylePattern = Pattern.compile("<Style.*</Style>\\s*", 32);
    public static final String defaultEmptyStringXmlRep = "&#248;";
    public static final String defaultEmptyString = "\u00f8";
    public static final String blobMessage = "data stored in EmbeddedClob since longer than 32767 chars";
    public static final int DEFAULT_FONT_SIZE = 11;
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>\n<?mso-application progid=\"Excel.Sheet\"?>\n<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n xmlns:html=\"http://www.w3.org/TR/REC-html40\">\n";
    public static final String DEFAULT_OSEE_STYLES = "<Style ss:ID=\"Default\" ss:Name=\"Normal\">\n <Alignment ss:Vertical=\"Bottom\"/>\n <Borders/>\n <Font ss:FontName=\"Calibri\" x:Family=\"Swiss\" ss:Size=\"%d\" ss:Color=\"#000000\"/>\n <Interior/>\n <NumberFormat/>\n <Protection/>\n</Style>\n<Style ss:ID=\"OseeDate\"><NumberFormat ss:Format=\"Short Date\"/></Style>\n<Style ss:ID=\"OseeDateGoodBackground\"><NumberFormat ss:Format=\"Short Date\"/><Interior ss:Color=\"#C6EFCE\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeDateNeutralBackground\"><NumberFormat ss:Format=\"Short Date\"/><Interior ss:Color=\"#FFEB9C\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeBoldStyle\"><Font x:Family=\"Swiss\" ss:Bold=\"1\"/></Style>\n<Style ss:ID=\"OseeBoldGoodBackground\"><Font x:Family=\"Swiss\" ss:Bold=\"1\"/><Interior ss:Color=\"#C6EFCE\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeBoldNeutralBackground\"><Font x:Family=\"Swiss\" ss:Bold=\"1\"/><Interior ss:Color=\"#FFEB9C\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeItalicStyle\"><Font x:Family=\"Swiss\" ss:Italic=\"1\"/></Style>\n<Style ss:ID=\"OseeErrorStyle\"><Font x:Family=\"Swiss\" ss:Color=\"#FF0000\" ss:Bold=\"1\"/></Style>\n<Style ss:ID=\"OseeCentered\"><Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/></Style>\n<Style ss:ID=\"OseeWraped\"><Alignment ss:Vertical=\"Top\" ss:WrapText=\"1\"/></Style>\n<Style ss:ID=\"OseeGoodBackground\"><Interior ss:Color=\"#C6EFCE\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeNeutralBackground\"><Interior ss:Color=\"#FFEB9C\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeHyperlink\" ss:Name=\"Hyperlink\"><Font ss:FontName=\"Calibri\" x:Family=\"Swiss\" ss:Color=\"#0563C1\" ss:Underline=\"Single\"/></Style>\n<Style ss:ID=\"OseeHyperlinkGoodBackground\" ss:Name=\"HyperlinkGoodBg\"><Font ss:FontName=\"Calibri\" x:Family=\"Swiss\" ss:Color=\"#0563C1\" ss:Underline=\"Single\"/><Interior ss:Color=\"#C6EFCE\" ss:Pattern=\"Solid\"/></Style>\n<Style ss:ID=\"OseeHyperlinkNeutralBackground\" ss:Name=\"HyperlinkNeutralBg\"><Font ss:FontName=\"Calibri\" x:Family=\"Swiss\" ss:Color=\"#0563C1\" ss:Underline=\"Single\"/><Interior ss:Color=\"#FFEB9C\" ss:Pattern=\"Solid\"/></Style>";
    private final BufferedWriter out;
    private boolean inSheet;
    private final String emptyStringRepresentation;
    private int previouslyWrittenCellIndex;
    private boolean applyStyle = false;
    private final Map<Integer, String> mStyleMap;
    private final Map<Integer, Integer> mColSpanMap = new HashMap<Integer, Integer>();
    private String[] rowBuffer;
    private int numColumns = -1;
    private double rowHeight;
    private int richTextCell = -1;
    private int numSheetsWritten = 0;
    private int activeSheetNum = -1;

    public ExcelXmlWriter(File file) throws IOException {
        this(new FileWriter(file));
    }

    public ExcelXmlWriter(Writer writer) throws IOException {
        this(writer, null);
    }

    public ExcelXmlWriter(String fileName, String style) throws IOException {
        this(fileName, null, defaultEmptyStringXmlRep, 11);
    }

    public ExcelXmlWriter(Writer writer, String style) throws IOException {
        this(writer, style, defaultEmptyStringXmlRep);
    }

    public ExcelXmlWriter(Writer writer, String style, String emptyStringRepresentation) throws IOException {
        this(writer, style, emptyStringRepresentation, 11);
    }

    public ExcelXmlWriter(Writer writer, String style, String emptyStringRepresentation, int defaultFontSize) throws IOException {
        this.out = new BufferedWriter(writer);
        this.mStyleMap = new HashMap<Integer, String>();
        this.emptyStringRepresentation = emptyStringRepresentation;
        this.out.write(XML_HEADER);
        this.out.write("<Styles>\n");
        this.out.write(String.format(DEFAULT_OSEE_STYLES, defaultFontSize));
        if (Strings.isValid(style)) {
            if (stylePattern.matcher(style).matches()) {
                this.out.write(style);
            } else {
                throw new IllegalArgumentException("incomingStyle must match the pattern " + stylePattern);
            }
        }
        this.out.write("</Styles>\n");
    }

    public ExcelXmlWriter(String filePath, String style, String emptyStringRepresentation, int defaultFontSize) throws IOException {
        FileWriter file = new FileWriter(filePath);
        this.out = new BufferedWriter(file);
        this.mStyleMap = new HashMap<Integer, String>();
        this.emptyStringRepresentation = emptyStringRepresentation;
        this.out.write(XML_HEADER);
        this.out.write("<Styles>\n");
        this.out.write(String.format(DEFAULT_OSEE_STYLES, defaultFontSize));
        if (Strings.isValid(style)) {
            if (stylePattern.matcher(style).matches()) {
                this.out.write(style);
            } else {
                throw new IllegalArgumentException("incomingStyle must match the pattern " + stylePattern);
            }
        }
        this.out.write("</Styles>\n");
    }

    @Override
    public void startSheet(String worksheetName, int columnCount) throws IOException {
        this.startSheet(worksheetName, ExcelColumn.newEmptyColumns(columnCount));
    }

    public void startSheet(String worksheetName, ExcelColumn ... columns) throws IOException {
        ExcelColumn column;
        if (this.inSheet) {
            throw new OseeCoreException("Cannot start a new sheet until the current sheet is closed", new Object[0]);
        }
        if (worksheetName.length() > 31) {
            worksheetName = worksheetName.substring(0, 31);
        }
        this.numColumns = columns.length;
        this.out.write(" <Worksheet ss:Name=\"");
        this.out.write(worksheetName);
        this.out.write("\">\n");
        this.out.write("  <Table x:FullColumns=\"1\" x:FullRows=\"1\" ss:ExpandedColumnCount=\"");
        this.out.write(String.valueOf(this.numColumns));
        this.out.write("\">\n");
        ExcelColumn[] excelColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            column = excelColumnArray[n2];
            column.writeColumnDefinition(this.out);
            ++n2;
        }
        if (columns[0].getName() != null) {
            this.rowBuffer = new String[this.numColumns];
            excelColumnArray = columns;
            n = columns.length;
            n2 = 0;
            while (n2 < n) {
                column = excelColumnArray[n2];
                this.writeCell(column.getName());
                ++n2;
            }
            this.endRow();
        }
        this.inSheet = true;
    }

    @Override
    public void endSheet() throws IOException {
        this.out.write("  </Table>\n");
        this.out.write(" </Worksheet>\n");
        this.inSheet = false;
        this.numColumns = -1;
        ++this.numSheetsWritten;
    }

    @Override
    public void endWorkbook() throws IOException {
        try {
            if (this.inSheet) {
                this.endSheet();
            }
            if (this.activeSheetNum >= 0) {
                this.out.write(" <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">\n");
                this.out.write("  <ActiveSheet>" + this.activeSheetNum + "</ActiveSheet>\n");
                this.out.write(" </ExcelWorkbook>\n");
            }
            this.out.write("</Workbook>\n");
        }
        finally {
            Lib.close(this.out);
        }
    }

    @Override
    public void endWorkbook(boolean close) throws IOException {
        try {
            if (this.inSheet) {
                this.endSheet();
            }
            if (this.activeSheetNum >= 0) {
                this.out.write(" <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">\n");
                this.out.write("  <ActiveSheet>" + this.activeSheetNum + "</ActiveSheet>\n");
                this.out.write(" </ExcelWorkbook>\n");
            }
            this.out.write("</Workbook>\n");
        }
        finally {
            if (close) {
                Lib.close(this.out);
            } else {
                this.out.flush();
            }
        }
    }

    @Override
    protected void startRow() throws IOException {
        this.out.write("   <Row");
        if (this.rowHeight != 0.0) {
            this.out.write(String.format(" ss:AutoFitHeight=\"0\" ss:Height=\"%f\"", this.rowHeight));
        }
        this.out.write(">\n");
        this.rowBuffer = new String[this.numColumns];
        this.previouslyWrittenCellIndex = -1;
    }

    @Override
    public void writeEndRow() throws IOException {
        int i = 0;
        while (i < this.numColumns) {
            if (this.rowBuffer[i] != null && this.rowBuffer[i].length() > 0) {
                this.out.write(this.rowBuffer[i]);
            }
            ++i;
        }
        this.out.write("   </Row>\n");
        this.rowBuffer = null;
    }

    @Override
    public void writeCellText(Object cellData, int cellIndex) throws IOException {
        if (cellIndex >= this.numColumns) {
            throw new OseeCoreException("ExcelWriter out of bounds: %d, index %d", this.numColumns, cellIndex);
        }
        if (cellData == null) {
            this.rowBuffer[cellIndex] = null;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("    <Cell");
            if (cellData instanceof Date) {
                sb.append(" ss:StyleID=\"OseeDate\"");
            } else if (this.applyStyle) {
                this.applyStyleToCell(sb, cellIndex);
            }
            if (this.previouslyWrittenCellIndex + 1 != cellIndex) {
                sb.append(" ss:Index=\"" + (cellIndex + 1) + "\"");
            }
            this.previouslyWrittenCellIndex = cellIndex;
            if (cellData instanceof String) {
                this.writeString(cellData, cellIndex, sb);
            } else if (cellData instanceof Number) {
                Number cellDataNum = (Number)cellData;
                sb.append("><Data ss:Type=\"Number\">");
                Xml.writeWhileHandlingCdata(sb, cellDataNum.toString());
                sb.append("</Data>");
            } else if (cellData instanceof Date) {
                Date cellDataDate = (Date)cellData;
                sb.append("><Data ss:Type=\"DateTime\">");
                String dateString = String.valueOf(DateUtil.get(cellDataDate, "yyyy-MM-dd")) + "T00:00:00.000";
                Xml.writeWhileHandlingCdata(sb, dateString);
                sb.append("</Data>");
            } else if (cellData instanceof CellData) {
                if (!((CellData)cellData).getHyperlink().isEmpty()) {
                    if (!((CellData)cellData).getStyle().isEmpty()) {
                        sb.append(" ss:StyleID=\"" + ((CellData)cellData).getStyle() + "\" ss:HRef=\"#'" + ((CellData)cellData).getHyperlink() + "'!A1\"");
                    } else {
                        sb.append(" ss:StyleID=\"OseeHyperlink\" ss:HRef=\"#'" + ((CellData)cellData).getHyperlink() + "'!A1\"");
                    }
                } else if (!((CellData)cellData).getStyle().isEmpty()) {
                    sb.append(" ss:StyleID=\"" + ((CellData)cellData).getStyle() + "\"");
                }
                if (!((CellData)cellData).getMergeAcross().isEmpty()) {
                    sb.append(" ss:MergeAcross=\"" + ((CellData)cellData).getMergeAcross() + "\"");
                }
                if (!((CellData)cellData).getMergeDown().isEmpty()) {
                    sb.append(" ss:MergeDown=\"" + ((CellData)cellData).getMergeDown() + "\"");
                }
                this.writeString(((CellData)cellData).getText(), cellIndex, sb);
            } else {
                sb.append("><Data ss:Type=\"String\">");
                Xml.writeWhileHandlingCdata(sb, cellData.toString());
                sb.append("</Data>");
            }
            sb.append("</Cell>\n");
            this.rowBuffer[cellIndex] = sb.toString();
        }
    }

    private void writeString(Object cellData, int cellIndex, StringBuilder sb) throws IOException {
        String cellDataStr = (String)cellData;
        if (!cellDataStr.equals("") && cellDataStr.charAt(0) == '=') {
            String value = cellDataStr.replaceAll("\"", "&quot;");
            sb.append(" ss:Formula=\"" + value + "\">");
        } else {
            boolean isRichText;
            boolean bl = isRichText = this.richTextCell == cellIndex;
            if (isRichText) {
                sb.append("><ss:Data ss:Type=\"String\" xmlns=\"http://www.w3.org/TR/REC-html40\">");
            } else {
                sb.append("><Data ss:Type=\"String\">");
            }
            if (cellDataStr.equals("")) {
                sb.append(this.emptyStringRepresentation);
            } else if (cellDataStr.length() > Short.MAX_VALUE) {
                sb.append(blobMessage);
            } else if (isRichText) {
                Xml.writeData(sb, cellDataStr);
            } else {
                Xml.writeWhileHandlingCdata(sb, cellDataStr);
            }
            if (isRichText) {
                this.richTextCell = -1;
                sb.append("</ss:Data>");
            } else {
                sb.append("</Data>");
            }
            if (cellDataStr.length() > Short.MAX_VALUE) {
                sb.append("<EmbeddedClob>");
                Xml.writeWhileHandlingCdata(sb, cellDataStr);
                sb.append("</EmbeddedClob>");
            }
        }
    }

    public void setCellStyle(STYLE style, int cellIndex) {
        this.applyStyle = true;
        if (style != STYLE.NONE) {
            this.mStyleMap.put(cellIndex, style.getText());
        }
    }

    public void setRichTextCell(int cellIndex) {
        this.richTextCell = cellIndex;
    }

    public void setCellStyle(String style, int cellIndex) {
        this.applyStyle = true;
        this.mStyleMap.put(cellIndex, style);
    }

    public void setCellColSpanWidth(int cellIndex, int colWidth) {
        this.applyStyle = true;
        this.mColSpanMap.put(cellIndex, colWidth);
    }

    public void setRowHeight(double rowHeight) {
        this.rowHeight = rowHeight;
    }

    private void applyStyleToCell(StringBuilder sb, int cellIndex) {
        Integer colSpanWidth;
        String applyThisStyle = this.mStyleMap.remove(cellIndex);
        if (applyThisStyle != null) {
            sb.append(" ss:StyleID=\"" + applyThisStyle + "\"");
        }
        if ((colSpanWidth = this.mColSpanMap.remove(cellIndex)) != null) {
            sb.append(" ss:MergeAcross=\"" + colSpanWidth + "\"");
        }
        this.applyStyle = this.mStyleMap.size() > 0 || this.mColSpanMap.size() > 0;
    }

    public BufferedWriter getOut() {
        return this.out;
    }

    @Override
    public void setActiveSheet(int sheetNum) {
        if (sheetNum < 0 || sheetNum >= this.numSheetsWritten) {
            if (sheetNum < 0) {
                throw new OseeArgumentException("Cannot set active sheet less than zero", new Object[0]);
            }
            throw new OseeArgumentException("Cannot set active sheet higher than the number of sheets written", new Object[0]);
        }
        this.activeSheetNum = sheetNum;
    }

    public void writeHeaderRow(Object ... row) throws IOException {
        int i = 0;
        while (i < row.length) {
            this.writeCell(new CellData((String)row[i], "", "", "", "OseeBoldStyle"));
            ++i;
        }
        this.endRow();
    }

    public static enum STYLE {
        NONE(""),
        BOLD("OseeBoldStyle"),
        BOLD_GOOD_BG("OseeBoldGoodBackground"),
        BOLD_NEUTRAL_BG("OseeBoldNeutralBackground"),
        CENTERED("OseeCentered"),
        DATE("OseeDate"),
        DATE_GOOD_BG("OseeDateGoodBackground"),
        DATE_NEUTRAL_BG("OseeDateNeutralBackground"),
        ERROR("OseeErrorStyle"),
        GOOD_BG("OseeGoodBackground"),
        HYPERLINK_GOOD_BG("OseeHyperlinkGoodBackground"),
        HYPERLINK_NEUTRAL_BG("OseeHyperlinkNeutralBackground"),
        ITALICS("OseeItalicStyle"),
        NEUTRAL_BG("OseeNeutralBackground"),
        WRAPPED("OseeWraped");

        private String text;

        private STYLE(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

