/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class PropertyStoreWriter {
    private static final String TAG_SECTION = "store";
    private static final String TAG_NAME = "id";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIST = "list";
    private static final String TAG_ITEM = "item";
    private static final String TAG_INNER = "inner.store";

    public void load(PropertyStore store, Reader reader) throws Exception {
        XMLReader xmlReader = new XMLReader();
        xmlReader.load(store, reader);
    }

    public void load(PropertyStore store, InputStream inputStream) throws Exception {
        this.load(store, new BufferedReader(new InputStreamReader(inputStream, "utf-8")));
    }

    public void save(PropertyStore store, OutputStream stream) throws IOException {
        XMLWriter writer = new XMLWriter(stream);
        this.internalSave(store, writer);
        writer.close();
    }

    public void save(PropertyStore store, Writer writer) {
        XMLWriter internalWriter = new XMLWriter(writer);
        this.internalSave(store, internalWriter);
    }

    private void internalSave(PropertyStore store, XMLWriter out) {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        String name = store.getId();
        attributes.put(TAG_NAME, name == null ? "" : name);
        out.startTag(TAG_SECTION, attributes);
        attributes.clear();
        Map<String, Object> items = store.getItems();
        for (Map.Entry<String, Object> entry : items.entrySet()) {
            String key = entry.getKey();
            attributes.put(TAG_KEY, key == null ? "" : key);
            String value = (String)entry.getValue();
            attributes.put(TAG_VALUE, value == null ? "" : value);
            out.printTag(TAG_ITEM, attributes, true);
        }
        attributes.clear();
        Map<String, Object> arrayItems = store.getArrays();
        for (Map.Entry<String, Object> entry : arrayItems.entrySet()) {
            String key = entry.getKey();
            attributes.put(TAG_KEY, key == null ? "" : key);
            out.startTag(TAG_LIST, attributes);
            String[] value = (String[])entry.getValue();
            attributes.clear();
            if (value != null) {
                int index = 0;
                while (index < value.length) {
                    String item = value[index];
                    attributes.put(TAG_VALUE, item == null ? "" : item);
                    out.printTag(TAG_ITEM, attributes, true);
                    ++index;
                }
            }
            out.endTag(TAG_LIST);
            attributes.clear();
        }
        attributes.clear();
        this.processInnerStores(store, out);
        out.endTag(TAG_SECTION);
    }

    private void processInnerStores(PropertyStore store, XMLWriter out) {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        Map<String, Object> properties = store.getPropertyStores();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            attributes.put(TAG_KEY, key == null ? "" : key);
            out.startTag(TAG_INNER, attributes);
            PropertyStore innerStore = (PropertyStore)entry.getValue();
            this.internalSave(innerStore, out);
            out.endTag(TAG_INNER);
        }
    }

    private static class XMLReader {
        private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        private List<String> valueList = null;
        private String tagListKey = null;
        private boolean isInTagList = false;
        private final Stack<Pair<String, PropertyStore>> innerStoreStack = new Stack();
        private String name;
        private String uri;

        private boolean isInNestedStore() {
            return !this.innerStoreStack.isEmpty();
        }

        private PropertyStore getCurrentInnerStore() {
            return this.innerStoreStack.peek().getSecond();
        }

        public void load(PropertyStore store, Reader input) throws Exception {
            try {
                XMLStreamReader streamReader = inputFactory.createXMLStreamReader(input);
                while (streamReader.hasNext()) {
                    this.process(store, streamReader);
                    streamReader.next();
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }

        private void process(PropertyStore store, XMLStreamReader reader) {
            int eventType = reader.getEventType();
            switch (eventType) {
                case 1: {
                    this.name = reader.getLocalName();
                    this.uri = reader.getNamespaceURI();
                    if (PropertyStoreWriter.TAG_SECTION.equals(this.name)) {
                        if (this.isInNestedStore()) {
                            this.getCurrentInnerStore().setId(reader.getAttributeValue(this.uri, PropertyStoreWriter.TAG_NAME));
                            break;
                        }
                        store.setId(reader.getAttributeValue(this.uri, PropertyStoreWriter.TAG_NAME));
                        break;
                    }
                    if (PropertyStoreWriter.TAG_ITEM.equals(this.name)) {
                        if (this.isInNestedStore()) {
                            this.processTagItemSection(this.uri, this.getCurrentInnerStore(), reader);
                            break;
                        }
                        this.processTagItemSection(this.uri, store, reader);
                        break;
                    }
                    if (PropertyStoreWriter.TAG_LIST.equals(this.name)) {
                        this.isInTagList = true;
                        this.tagListKey = reader.getAttributeValue(this.uri, PropertyStoreWriter.TAG_KEY);
                        break;
                    }
                    if (!PropertyStoreWriter.TAG_INNER.equals(this.name)) break;
                    String key = reader.getAttributeValue(this.uri, PropertyStoreWriter.TAG_KEY);
                    this.innerStoreStack.add(new Pair<String, PropertyStore>(key, new PropertyStore()));
                    break;
                }
                case 2: {
                    this.name = reader.getLocalName();
                    this.uri = reader.getNamespaceURI();
                    if (PropertyStoreWriter.TAG_LIST.equals(this.name)) {
                        this.isInTagList = false;
                        if (Strings.isValid(this.tagListKey) && this.valueList != null && !this.valueList.isEmpty()) {
                            String[] value = this.valueList.toArray(new String[this.valueList.size()]);
                            if (this.isInNestedStore()) {
                                this.getCurrentInnerStore().put(this.tagListKey, value);
                            } else {
                                store.put(this.tagListKey, value);
                            }
                        }
                        this.valueList = null;
                        this.tagListKey = null;
                        break;
                    }
                    if (!PropertyStoreWriter.TAG_INNER.equals(this.name)) break;
                    Pair<String, PropertyStore> completedPair = this.innerStoreStack.pop();
                    String completedKey = completedPair.getFirst();
                    PropertyStore completedStore = completedPair.getSecond();
                    if (this.isInNestedStore()) {
                        this.getCurrentInnerStore().put(completedKey, completedStore);
                        break;
                    }
                    store.put(completedKey, completedStore);
                    break;
                }
                case 9: {
                    this.name = reader.getLocalName();
                    this.uri = reader.getNamespaceURI();
                    break;
                }
            }
        }

        private void processTagItemSection(String uri, PropertyStore store, XMLStreamReader reader) {
            String value = reader.getAttributeValue(uri, PropertyStoreWriter.TAG_VALUE);
            if (this.isInTagList) {
                if (this.valueList == null) {
                    this.valueList = new ArrayList<String>();
                }
                this.valueList.add(value);
            } else {
                String key = reader.getAttributeValue(uri, PropertyStoreWriter.TAG_KEY);
                if (Strings.isValid(key)) {
                    store.put(key, value);
                }
            }
        }
    }

    private static class XMLWriter
    extends PrintWriter {
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private int tab = 0;

        public XMLWriter(Writer writer) {
            super(writer);
            this.println(XML_VERSION);
        }

        public XMLWriter(OutputStream output) throws UnsupportedEncodingException {
            this(new OutputStreamWriter(output, "UTF8"));
        }

        public void endTag(String name) {
            --this.tab;
            this.printTag("/" + name, null, false);
        }

        private void printTabulation() {
            int i = 0;
            while (i < this.tab) {
                super.print('\t');
                ++i;
            }
        }

        public void printTag(String name, Map<String, String> parameters, boolean close) {
            this.printTag(name, parameters, false, false, close);
        }

        private void printTag(String name, Map<String, String> parameters, boolean shouldTab, boolean newLine, boolean close) {
            StringBuffer sb = new StringBuffer();
            sb.append('<');
            sb.append(name);
            if (parameters != null) {
                Enumeration<String> e = Collections.enumeration(parameters.keySet());
                while (e.hasMoreElements()) {
                    sb.append(" ");
                    String key = e.nextElement();
                    sb.append(key);
                    sb.append("=\"");
                    sb.append(XMLWriter.getEscaped(String.valueOf(parameters.get(key))));
                    sb.append("\"");
                }
            }
            if (close) {
                sb.append('/');
            }
            sb.append('>');
            if (shouldTab) {
                this.printTabulation();
            }
            if (newLine) {
                this.println(sb.toString());
            } else {
                this.print(sb.toString());
            }
        }

        public void startTag(String name, Map<String, String> parameters) {
            this.startTag(name, parameters, true);
            ++this.tab;
        }

        private void startTag(String name, Map<String, String> parameters, boolean newLine) {
            this.printTag(name, parameters, true, newLine, false);
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = XMLWriter.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            int i = 0;
            while (i < s.length()) {
                XMLWriter.appendEscapedChar(result, s.charAt(i));
                ++i;
            }
            return result.toString();
        }

        private static String getReplacement(char character) {
            switch (character) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

