/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.builder;

import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.StateEventType;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.ats.api.workdef.model.DecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.core.workdef.builder.DecisionReviewOptionBuilder;
import org.eclipse.osee.framework.core.data.UserToken;

public class DecisionReviewDefinitionBuilder {
    DecisionReviewDefinition decRev = new DecisionReviewDefinition();

    public DecisionReviewDefinitionBuilder(String name) {
        this.decRev.setName(name);
    }

    public DecisionReviewDefinitionBuilder andTitle(String title) {
        this.decRev.setReviewTitle(title);
        return this;
    }

    public DecisionReviewDefinitionBuilder andDescription(String desc) {
        this.decRev.setDescription(desc);
        return this;
    }

    public DecisionReviewDefinitionBuilder andRelatedToState(StateToken state) {
        this.decRev.setRelatedToState(state.getName());
        return this;
    }

    public DecisionReviewDefinitionBuilder andBlockingType(ReviewBlockType blockType) {
        this.decRev.setBlockingType(blockType);
        return this;
    }

    public DecisionReviewDefinitionBuilder andEvent(StateEventType stateEventType) {
        this.decRev.setStateEventType(stateEventType);
        return this;
    }

    public DecisionReviewDefinitionBuilder andAssignees(AtsUser ... assignees) {
        AtsUser[] atsUserArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            AtsUser assignee = atsUserArray[n2];
            this.decRev.addAssignee(assignee);
            ++n2;
        }
        return this;
    }

    public DecisionReviewDefinitionBuilder andAutoTransitionToDecision() {
        this.decRev.setAutoTransitionToDecision(true);
        return this;
    }

    public DecisionReviewDefinition getDecisionReview() {
        return this.decRev;
    }

    public DecisionReviewDefinition getReviewDefinition() {
        return this.decRev;
    }

    public DecisionReviewOptionBuilder andOption(String name) {
        return new DecisionReviewOptionBuilder(name, this);
    }

    public DecisionReviewDefinitionBuilder andAssignees(UserToken user) {
        this.decRev.assignees.add(user.getUserId());
        return this;
    }
}

