/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.program;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.program.IAtsProgramManager;
import org.eclipse.osee.ats.api.program.IAtsProgramService;
import org.eclipse.osee.ats.api.program.ProgramVersions;
import org.eclipse.osee.ats.api.program.ProjectType;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.config.Country;
import org.eclipse.osee.ats.core.config.Program;
import org.eclipse.osee.ats.core.insertion.Insertion;
import org.eclipse.osee.ats.core.insertion.InsertionActivity;
import org.eclipse.osee.ats.core.program.operations.AtsProgramOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsProgramService
implements IAtsProgramService {
    private AtsApi atsApi;
    private CacheLoader<IAtsTeamDefinition, IAtsProgram> teamDefToAtsProgramCacheLoader;
    private LoadingCache<IAtsTeamDefinition, IAtsProgram> teamDefToAtsProgramCache;
    AtsProgramOperations programOps;
    private static final List<IAtsProgramManager> programMgrs = new ArrayList<IAtsProgramManager>();

    public AtsProgramService() {
    }

    public AtsProgramService(AtsApi atsApi) {
        this.atsApi = atsApi;
        this.teamDefToAtsProgramCacheLoader = new CacheLoader<IAtsTeamDefinition, IAtsProgram>(){

            public IAtsProgram load(IAtsTeamDefinition teamDef) {
                return AtsProgramService.this.loadProgram(teamDef);
            }
        };
        this.teamDefToAtsProgramCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(this.teamDefToAtsProgramCacheLoader);
    }

    public void addProgramManager(IAtsProgramManager programMgr) {
        programMgrs.add(programMgr);
    }

    private AtsProgramOperations getProgramOps() {
        if (this.programOps == null) {
            this.programOps = new AtsProgramOperations(this.atsApi);
        }
        return this.programOps;
    }

    public IAtsCountry getCountryById(ArtifactId countryId) {
        IAtsCountry country = null;
        if (countryId instanceof IAtsCountry) {
            country = (IAtsCountry)countryId;
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(countryId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Country})) {
                country = new Country(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return country;
    }

    public IAtsInsertion getInsertionById(ArtifactId insertionId) {
        IAtsInsertion insertion = null;
        if (insertionId instanceof IAtsInsertion) {
            insertion = (IAtsInsertion)insertionId;
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(insertionId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
                insertion = new Insertion(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return insertion;
    }

    public IAtsInsertionActivity getInsertionActivityById(ArtifactId insertionActivityId) {
        IAtsInsertionActivity insertionActivity = null;
        if (insertionActivityId instanceof IAtsInsertionActivity) {
            insertionActivity = (IAtsInsertionActivity)insertionActivityId;
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(insertionActivityId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.InsertionActivity})) {
                insertionActivity = new InsertionActivity(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return insertionActivity;
    }

    public Collection<IAtsInsertionActivity> getInsertionActivities(IAtsInsertion insertion) {
        ArrayList<IAtsInsertionActivity> insertionActivitys = new ArrayList<IAtsInsertionActivity>();
        for (ArtifactId artifact : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.atsApi.getQueryService().getArtifact(insertion.getId()), AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
            insertionActivitys.add(this.atsApi.getProgramService().getInsertionActivityById(artifact));
        }
        return insertionActivitys;
    }

    public IAtsInsertionActivity getInsertionActivity(Long insertionActivityId) {
        return this.atsApi.getProgramService().getInsertionActivityById((ArtifactId)this.atsApi.getQueryService().getArtifact(insertionActivityId));
    }

    public IAtsWorkPackage getWorkPackage(Long workPackageId) {
        return this.atsApi.getEarnedValueService().getWorkPackage((ArtifactId)this.atsApi.getQueryService().getArtifact(workPackageId));
    }

    public IAtsInsertionActivity getInsertionActivity(IAtsWorkPackage workPackage) {
        ArtifactToken wpArt = this.atsApi.getQueryService().getArtifact(workPackage.getId());
        Collection related = this.atsApi.getRelationResolver().getRelated((ArtifactId)wpArt, AtsRelationTypes.InsertionActivityToWorkPackage_InsertionActivity);
        if (related.size() > 0) {
            return this.atsApi.getProgramService().getInsertionActivityById((ArtifactId)related.iterator().next());
        }
        return null;
    }

    public IAtsInsertion getInsertion(IAtsInsertionActivity activity) {
        Collection related = this.atsApi.getRelationResolver().getRelated((ArtifactId)activity.getStoreObject(), AtsRelationTypes.InsertionToInsertionActivity_Insertion);
        if (related.size() > 0) {
            return this.atsApi.getProgramService().getInsertionById((ArtifactId)related.iterator().next());
        }
        return null;
    }

    public IAtsProgram getProgram(IAtsInsertion insertion) {
        Collection related;
        if (insertion != null && (related = this.atsApi.getRelationResolver().getRelated((ArtifactId)insertion.getStoreObject(), AtsRelationTypes.ProgramToInsertion_Program)).size() > 0) {
            return this.atsApi.getProgramService().getProgramById((ArtifactId)related.iterator().next());
        }
        return null;
    }

    public void setWorkPackage(IAtsWorkPackage workPackage, List<IAtsWorkItem> workItems, AtsUser asUser) {
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Set Work Package", asUser);
        for (IAtsWorkItem workItem : workItems) {
            if (workPackage == null) {
                changes.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference);
                continue;
            }
            changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)workPackage.getStoreObject());
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
    }

    public IAtsInsertion getInsertion(Long insertionId) {
        return this.atsApi.getProgramService().getInsertionById((ArtifactId)this.atsApi.getQueryService().getArtifact(insertionId));
    }

    public Collection<IAtsInsertion> getInsertions(IAtsProgram program) {
        ArrayList<IAtsInsertion> insertions = new ArrayList<IAtsInsertion>();
        for (ArtifactId artifact : this.atsApi.getRelationResolver().getRelated((IAtsObject)program, AtsRelationTypes.ProgramToInsertion_Insertion)) {
            insertions.add(this.atsApi.getProgramService().getInsertionById(artifact));
        }
        return insertions;
    }

    public Collection<IAtsProgram> getPrograms() {
        ArrayList<IAtsProgram> programs = new ArrayList<IAtsProgram>();
        for (ArtifactId artifact : this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.Program}).getArtifacts()) {
            programs.add(this.atsApi.getProgramService().getProgramById(artifact));
        }
        return programs;
    }

    public IAtsProgram getProgramById(ArtifactId programId) {
        IAtsProgram program = null;
        if (programId instanceof IAtsProgram) {
            program = (IAtsProgram)programId;
        } else if (programId instanceof ArtifactToken) {
            program = new Program(this.atsApi.getLogger(), this.atsApi, (ArtifactToken)programId);
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(programId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
                program = new Program(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return program;
    }

    public List<IAtsProgram> getPrograms(IAtsCountry atsCountry) {
        LinkedList<IAtsProgram> programs = new LinkedList<IAtsProgram>();
        ArtifactToken artifact = atsCountry.getStoreObject();
        if (artifact != null) {
            for (ArtifactId related : this.atsApi.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.CountryToProgram_Program)) {
                programs.add(this.atsApi.getProgramService().getProgramById(related));
            }
        }
        return programs;
    }

    public IAtsCountry getCountry(IAtsProgram atsProgram) {
        ArtifactToken countryArt;
        IAtsCountry country = null;
        ArtifactToken artifact = atsProgram.getStoreObject();
        if (artifact != null && (countryArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)artifact, AtsRelationTypes.CountryToProgram_Country)).isValid()) {
            country = this.atsApi.getProgramService().getCountryById((ArtifactId)countryArt);
        }
        return country;
    }

    public IAtsProgram getProgram(IAtsWorkItem workItem) {
        IAtsTeamDefinition teamDef = workItem.getParentTeamWorkflow().getTeamDefinition();
        return this.getProgram(teamDef);
    }

    public IAtsProgram getProgram(IAtsTeamDefinition teamDef) {
        try {
            return (IAtsProgram)this.teamDefToAtsProgramCache.get((Object)teamDef);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IAtsProgram loadProgram(IAtsTeamDefinition teamDef) {
        IAtsTeamDefinition topTeamDef;
        ArtifactId art;
        IAtsProgram program = null;
        TeamDefinition teamDef2 = (TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamDef.getId());
        String progIdStr = teamDef2.getProgramId();
        if (Strings.isNumeric((String)progIdStr)) {
            program = this.atsApi.getProgramService().getProgramById(ArtifactId.valueOf((String)progIdStr));
        }
        if (program == null && (art = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL)).isValid()) {
            program = this.atsApi.getProgramService().getProgramById(art);
        }
        if (program == null && (topTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamDef)) != null && teamDef.notEqual((Id)topTeamDef)) {
            program = this.loadProgram((IAtsTeamDefinition)this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef));
        }
        if (program == null) {
            program = (IAtsProgram)this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.Program}).andAttr((AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, teamDef.getIdString(), new QueryOption[0]).getConfigObjectResultSet().getExactlyOne();
        }
        return program;
    }

    public String getDescription(IAtsProgram program) {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"");
    }

    public IAtsTeamDefinition getTeamDefHoldingVersions(IAtsProgram program) {
        return this.getTeamDefinition(program);
    }

    public IAtsTeamDefinition getTeamDefinition(IAtsProgram program) {
        IAtsTeamDefinition teamDefinition = null;
        ArtifactId artId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL);
        if (artId.isValid() && (teamDefinition = (IAtsTeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(artId.getId())) == null) {
            teamDefinition = (IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(artId);
        }
        return teamDefinition;
    }

    public Collection<IAtsActionableItem> getAis(IAtsProgram program) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramId, program.getIdString(), new QueryOption[0]).getConfigObjectResultSet().getList());
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(IAtsProgram program) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramId, program.getIdString(), new QueryOption[0]).getConfigObjectResultSet().getList());
    }

    public Collection<IAtsProgram> getPrograms(ArtifactTypeToken artifactType) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{artifactType}).getConfigObjectResultSet().getList());
    }

    public Collection<String> getCscis(IAtsProgram program) {
        return this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.CSCI);
    }

    public Collection<IAtsActionableItem> getAis(IAtsProgram program, WorkType workType) {
        return this.getAis(program, Collections.singleton(workType));
    }

    public Collection<IAtsActionableItem> getAis(IAtsProgram program, Collection<WorkType> workTypes) {
        IAtsConfigQuery query = this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramId, program.getIdString(), new QueryOption[0]);
        LinkedList<String> types = new LinkedList<String>();
        for (WorkType type : workTypes) {
            types.add(type.name());
        }
        query.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, types, QueryOption.EXACT_MATCH_OPTIONS);
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)query.getConfigObjectResultSet().getList());
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(IAtsProgram program, Collection<WorkType> workTypes) {
        IAtsConfigQuery query = this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramId, program.getIdString(), new QueryOption[0]);
        LinkedList<String> types = new LinkedList<String>();
        for (WorkType type : workTypes) {
            types.add(type.name());
        }
        query.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, types, QueryOption.EXACT_MATCH_OPTIONS);
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)query.getConfigObjectResultSet().getList());
    }

    public WorkType getWorkType(IAtsTeamWorkflow teamWf) {
        return this.getWorkType(teamWf.getTeamDefinition());
    }

    public WorkType getWorkType(IAtsTeamDefinition teamDef) {
        WorkType workType = WorkType.None;
        try {
            String typeStr = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkType, "");
            if (Strings.isValid((String)typeStr)) {
                workType = WorkType.valueOfOrNone((String)typeStr);
            }
        }
        catch (Exception exception) {
            workType = WorkType.Custom;
        }
        return workType;
    }

    public ProjectType getProjectType(IAtsProgram program) {
        if (this.atsApi.getAttributeResolver().getAttributeCount((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.CSCI) > 1) {
            return ProjectType.MultiProcessor;
        }
        return ProjectType.SingleProcessor;
    }

    public String getNamespace(IAtsProgram program) {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"");
    }

    public long getCountryId(IAtsProgram program) {
        long countryId = 0L;
        ArtifactToken countryArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)program, AtsRelationTypes.CountryToProgram_Country);
        if (countryArt.isValid()) {
            countryId = countryArt.getId();
        }
        return countryId;
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, WorkType workType, IAtsWorkItem workItem) {
        return this.getWorkflows(program, Collections.singleton(workType), workItem);
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program) {
        Collection<IAtsTeamDefinition> workTypeTeamDefs = this.getTeamDefs(program);
        return this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andTeam(workTypeTeamDefs).getItems(IAtsTeamWorkflow.class);
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, Collection<WorkType> workTypes, IAtsWorkItem workItem) {
        if (workTypes.contains(WorkType.All)) {
            throw new OseeArgumentException("Invalid option ALL for getWorkflow", new Object[0]);
        }
        HashSet<IAtsTeamWorkflow> teamArts = new HashSet<IAtsTeamWorkflow>();
        Collection<IAtsTeamDefinition> workTypeTeamDefs = this.getTeamDefs(program, workTypes);
        if (workTypeTeamDefs.size() > 0) {
            IAtsWorkItem useWorkItem = workItem;
            if (useWorkItem instanceof IAtsTask) {
                useWorkItem = (IAtsObject)((IAtsTask)useWorkItem).getParentAction().getStoreObject();
            }
            if (useWorkItem instanceof IAtsTeamWorkflow) {
                useWorkItem = (IAtsObject)((IAtsTeamWorkflow)useWorkItem).getParentAction().getStoreObject();
            }
            if (useWorkItem != null && useWorkItem instanceof IAtsAction) {
                for (IAtsTeamWorkflow team : this.atsApi.getWorkItemService().getTeams((Object)useWorkItem)) {
                    if (!workTypeTeamDefs.contains(team.getTeamDefinition())) continue;
                    teamArts.add(team);
                }
            }
        }
        return teamArts;
    }

    public boolean isActive(IAtsProgram program) {
        return (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(IAtsProgram program, WorkType workType) {
        return this.getTeamDefs(program, Collections.singleton(workType));
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, Collection<WorkType> workTypes) {
        Collection teamDefs = this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andProgram(program).andWorkType(workTypes).getConfigObjects();
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andTeam(teamDefs).getResults().getList());
    }

    public Collection<IAtsVersion> getVersions(IAtsProgram program) {
        IAtsTeamDefinition teamDefHoldingVersions = this.atsApi.getProgramService().getTeamDefHoldingVersions(program);
        if (teamDefHoldingVersions != null) {
            return this.atsApi.getVersionService().getVersions(teamDefHoldingVersions);
        }
        return Collections.emptyList();
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, WorkType workType) {
        return this.getWorkflows(program, Collections.singleton(workType));
    }

    public IAtsVersion getVersion(IAtsProgram program, String versionName) {
        for (IAtsVersion version : this.getVersions(program)) {
            if (!version.getName().equals(versionName)) continue;
            return version;
        }
        return null;
    }

    public List<ProgramVersions> getProgramVersions(ArtifactTypeToken artType, boolean activeOnly) {
        return this.getProgramOps().getProgramVersionsList(artType, activeOnly);
    }

    public ProgramVersions getProgramVersions(ArtifactToken program, boolean onlyActive) {
        ProgramVersions progVer = this.getProgramOps().getProgramVersions(program, onlyActive);
        return progVer;
    }

    public ArtifactToken getProgramFromVersion(ArtifactId version) {
        return this.getProgramOps().getProgramFromVersion(version);
    }

    public BranchToken getProductLineBranch(IAtsProgram program) {
        String branchIdStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.ProductLineBranchId, (Object)"");
        if (Strings.isNumeric((String)branchIdStr)) {
            Long branchId = Long.valueOf(branchIdStr);
            return this.atsApi.getBranchService().getBranch(BranchId.valueOf((Long)branchId));
        }
        return BranchToken.SENTINEL;
    }

    public IAtsProgramManager getProgramManager(IAtsTeamWorkflow teamWf) {
        for (IAtsProgramManager programMgr : programMgrs) {
            if (!programMgr.isApplicable(teamWf)) continue;
            return programMgr;
        }
        return null;
    }
}

