/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.identifier;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.define.operations.synchronization.identifier.IncorrectIdentifierTypeException;

public class Identifier {
    private final String identifierText;
    private final IdentifierType identifierType;
    private final int hashCode;
    private final Long identifierCount;

    Identifier(String text, Long count, IdentifierType type) {
        this.identifierText = text;
        this.identifierType = type;
        this.identifierCount = count;
        this.hashCode = (int)((long)((type.ordinal() << 5) - type.ordinal() << 24) ^ count * count - count);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Identifier && this.identifierCount == ((Identifier)obj).identifierCount && this.identifierType == ((Identifier)obj).identifierType;
    }

    public long getCount() {
        return this.identifierCount;
    }

    String getText() {
        return this.identifierText;
    }

    public IdentifierType getType() {
        return this.identifierType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isInGroup(IdentifierTypeGroup identifierTypeGroup) {
        return this.identifierType.isInGroup(identifierTypeGroup);
    }

    public boolean isType(IdentifierType identifierType) {
        return this.identifierType.equals(identifierType);
    }

    public void requireInGroup(IdentifierTypeGroup identifierTypeGroup) {
        if (!this.identifierType.isInGroup(identifierTypeGroup)) {
            throw new IncorrectIdentifierTypeException(this, identifierTypeGroup);
        }
    }

    public void requireInGroup(IdentifierTypeGroup identifierTypeGroup, String message) {
        if (!this.identifierType.isInGroup(identifierTypeGroup)) {
            throw new IncorrectIdentifierTypeException(this, identifierTypeGroup, message);
        }
    }

    public void requireInGroup(IdentifierTypeGroup identifierTypeGroup, Supplier<String> messageSupplier) {
        if (!this.identifierType.isInGroup(identifierTypeGroup)) {
            throw new IncorrectIdentifierTypeException(this, identifierTypeGroup, Objects.nonNull(messageSupplier) ? messageSupplier.get() : null);
        }
    }

    public void requireType(IdentifierType identifierType) {
        if (!this.identifierType.equals(identifierType)) {
            throw new IncorrectIdentifierTypeException(this, identifierType);
        }
    }

    public void requireType(IdentifierType identifierType, String message) {
        if (!this.identifierType.equals(identifierType)) {
            throw new IncorrectIdentifierTypeException(this, identifierType, message);
        }
    }

    public void requireType(IdentifierType identifierType, Supplier<String> messageSupplier) {
        if (!this.identifierType.equals(identifierType)) {
            throw new IncorrectIdentifierTypeException(this, identifierType, Objects.nonNull(messageSupplier) ? messageSupplier.get() : null);
        }
    }

    public String toString() {
        return this.identifierText;
    }
}

