/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.health;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.orcs.health.StatusKey;

public class ServerStatus {
    private final Map<String, String> data = new HashMap<String, String>();
    private final List<String> threadStats = new LinkedList<String>();
    public final List<String> garbageCollectorStats = new LinkedList<String>();

    public void set(StatusKey key, String value) {
        this.data.put(key.getShortName(), value);
    }

    @JsonIgnore
    public String get(StatusKey key) {
        return this.data.get(key.getShortName());
    }

    public void add(String keyStr, String value) {
        StatusKey key = StatusKey.Unknown;
        try {
            key = StatusKey.valueOf(keyStr);
        }
        catch (Exception exception) {}
        if (key == StatusKey.Unknown) {
            String newStr = this.data.get(StatusKey.Unknown.name());
            newStr = newStr == null ? String.format("[%s][%s]", key.name(), value) : String.valueOf(newStr) + String.format("%s - [%s][%s]", key.name(), value);
            this.data.put(StatusKey.Unknown.name(), newStr);
        }
        this.data.put(keyStr, value);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public List<String> getThreadStats() {
        return this.threadStats;
    }

    public void add(String threadStr) {
        this.threadStats.add(threadStr);
    }
}

