/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.core.internal.transaction.TransactionBuilderImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class TransactionFactoryImpl
implements TransactionFactory {
    private final OrcsSession session;
    private final TxDataManager txDataManager;
    private final TxCallableFactory txCallableFactory;
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final OrcsBranch orcsBranch;
    private final KeyValueOps keyValueOps;
    private final TxDataStore txDataStore;
    private final TransactionQuery transactionQuery;

    public TransactionFactoryImpl(OrcsSession session, TxDataManager txDataManager, TxCallableFactory txCallableFactory, OrcsApi orcsApi, OrcsBranch orcsBranch, KeyValueOps keyValueOps, TxDataStore txDataStore) {
        this.session = session;
        this.txDataManager = txDataManager;
        this.txCallableFactory = txCallableFactory;
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.orcsBranch = orcsBranch;
        this.keyValueOps = keyValueOps;
        this.txDataStore = txDataStore;
        this.transactionQuery = this.queryFactory.transactionQuery();
    }

    public CancellableCallable<Integer> purgeTransaction(Collection<? extends TransactionId> transactions) {
        return this.txCallableFactory.purgeTransactions(this.session, transactions);
    }

    public TransactionBuilder createTransaction(BranchId branch, String comment) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        if (!((BranchQuery)this.queryFactory.branchQuery().andId(branch)).exists()) {
            throw new ItemDoesNotExist("BranchId %s does not exist", new Object[]{branch});
        }
        TxData txData = this.txDataManager.createTxData(this.session, branch);
        TransactionBuilderImpl orcsTxn = new TransactionBuilderImpl(this.txCallableFactory, this.txDataManager, txData, this.orcsApi, this.keyValueOps);
        orcsTxn.setComment(comment);
        orcsTxn.setAuthor(this.orcsApi.userService().getUser());
        return orcsTxn;
    }

    public TransactionBuilder createTransaction(BranchId branch, UserId author, String comment) {
        TxData txData = this.txDataManager.createTxData(this.session, branch);
        TransactionBuilderImpl orcsTxn = new TransactionBuilderImpl(this.txCallableFactory, this.txDataManager, txData, this.orcsApi, this.keyValueOps);
        orcsTxn.setComment(comment);
        UserToken user = this.orcsApi.userService().getUser(author.getId());
        orcsTxn.setAuthor(user);
        return orcsTxn;
    }

    public Callable<Void> setTransactionComment(TransactionId transaction, String comment) {
        return this.txCallableFactory.setTransactionComment(this.session, transaction, comment);
    }

    public List<ChangeItem> compareTxs(TransactionId txId1, TransactionId txId2) {
        TransactionReadable sourceTx = this.getTx(txId1);
        TransactionReadable destinationTx = this.getTx(txId2);
        try {
            return this.orcsBranch.compareBranch((TransactionToken)sourceTx, (TransactionToken)destinationTx);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public List<ChangeItem> comparedToParent(BranchId branch) {
        BranchId parentBranch = ((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne()).getParentBranch();
        TransactionId sourceTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsHead(branch)).getResultsAsIds().getExactlyOne();
        TransactionId destionationTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsHead(parentBranch)).getResultsAsIds().getExactlyOne();
        return this.compareTxs(sourceTx, destionationTx);
    }

    public List<ChangeItem> comparedToPreviousTx(TransactionToken txId) {
        TransactionId startTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsPriorTx(txId)).getResultsAsIds().getExactlyOne();
        return this.compareTxs(startTx, (TransactionId)txId);
    }

    public boolean replaceWithBaselineTxVersion(UserId userId, BranchId branchId, TransactionId txId, ArtifactId artId, String comment) {
        boolean introduced = false;
        ArtifactReadable baselineArtifact = (ArtifactReadable)this.queryFactory.fromBranch(branchId).fromTransaction(txId).andId(artId).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (!userId.isValid() || !baselineArtifact.isValid()) {
            throw new OseeCoreException("%s Error - The user and/or baseline artifact were not found.", new Object[]{comment});
        }
        TransactionBuilder tx = this.createTransaction(branchId, userId, comment);
        ArtifactReadable destination = (ArtifactReadable)this.queryFactory.fromBranch(branchId).includeDeletedArtifacts().andId(artId).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        tx.replaceWithVersion(baselineArtifact, destination);
        tx.commit();
        introduced = true;
        return introduced;
    }

    public boolean purgeTxs(String txIds) {
        ResultSet results;
        boolean modified = false;
        List txsToDelete = Collections.fromString((String)txIds, TransactionId::valueOf);
        if (!txsToDelete.isEmpty() && !(results = ((TransactionQuery)this.transactionQuery.andTxIds((Collection)txsToDelete)).getResults()).isEmpty()) {
            this.checkAllTxsFound("Purge Transaction", txsToDelete, (ResultSet<? extends TransactionId>)results);
            ArrayList list = Lists.newArrayList((Iterable)results);
            try {
                this.purgeTransaction((Collection<? extends TransactionId>)list).call();
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
            modified = true;
        }
        return modified;
    }

    public boolean setTxComment(TransactionId txId, String comment) {
        TransactionReadable tx = this.getTx(txId);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getComment(), (Object)comment)) {
            this.setTransactionComment((TransactionId)tx, comment);
            modified = true;
        }
        return modified;
    }

    public ResultSet<TransactionReadable> getAllTxs() {
        return this.transactionQuery.getResults();
    }

    public TransactionReadable getTx(TransactionId tx) {
        if (tx instanceof TransactionReadable) {
            return (TransactionReadable)tx;
        }
        return (TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(tx)).getResults().getExactlyOne();
    }

    private void checkAllTxsFound(String opName, List<TransactionId> txIds, ResultSet<? extends TransactionId> result) {
        List difference;
        if (txIds.size() != result.size() && !(difference = Collections.setComplement(txIds, (Collection)result.getList())).isEmpty()) {
            throw new OseeNotFoundException("%s Error - The following transactions from %s were not found - txs %s - Please remove them from the request and try again.", new Object[]{opName, txIds, difference});
        }
    }

    public int[] purgeUnusedBackingDataAndTransactions() {
        return this.txDataStore.purgeUnusedBackingDataAndTransactions();
    }

    public boolean setTransactionCommitArtifact(TransactionId trans, ArtifactId commitArt) {
        TransactionReadable tx = this.getTx(trans);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getCommitArt(), (Object)commitArt)) {
            this.txCallableFactory.setTransactionCommitArtifact(this.session, trans, commitArt);
            modified = true;
        }
        return modified;
    }

    public List<ChangeItem> getArtifactHistory(ArtifactId artifact, BranchId branch) {
        try {
            return this.txDataStore.getArtifactHistory(this.session, this.queryFactory, artifact, branch).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public List<ChangeReportRowDto> getTxChangeReport(BranchId branch, TransactionId txId1, TransactionId txId2) {
        LinkedList<ChangeReportRowDto> changeReportRows = new LinkedList<ChangeReportRowDto>();
        List<ChangeItem> changeItems = this.compareTxs(txId1, txId2);
        LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
        for (ChangeItem change : changeItems) {
            if (change.getArtId().isValid() && !artIds.contains(change.getArtId())) {
                artIds.add(change.getArtId());
            }
            if (!change.getArtIdB().isValid() || artIds.contains(change.getArtIdB())) continue;
            artIds.add(change.getArtIdB());
        }
        List artifacts = this.orcsApi.getQueryFactory().fromBranch(branch).andIds(artIds).asArtifacts();
        for (ChangeItem changeItem : changeItems) {
            String itemKind;
            ArtifactReadable artA = artifacts.stream().filter(a -> ArtifactId.valueOf((Long)a.getId()).equals(changeItem.getArtId())).findFirst().orElse(ArtifactReadable.SENTINEL);
            ArtifactReadable artB = artifacts.stream().filter(a -> ArtifactId.valueOf((Long)a.getId()).equals(changeItem.getArtIdB())).findFirst().orElse(ArtifactReadable.SENTINEL);
            String ids = artA.getIdString();
            if (artB.isValid()) {
                ids = String.valueOf(ids) + " - " + artB.getIdString();
            }
            String isValue = (itemKind = changeItem.getChangeType().getName().replace("Change", "")).equals("Relation") ? "" : changeItem.getCurrentVersion().getValue();
            String wasValue = itemKind.equals("Relation") ? "" : changeItem.getBaselineVersion().getValue();
            String changeType = changeItem.getNetChange().getModType().getName();
            String names = artA.getName();
            if (itemKind.equals("Relation") && artB.isValid()) {
                names = String.valueOf(names) + " <---> " + artB.getName();
            }
            String itemType = "";
            if (itemKind.equals("Artifact")) {
                itemType = artA.getArtifactType().getName();
            } else if (itemKind.equals("Attribute")) {
                AttributeTypeToken attrToken = artA.getExistingAttributeTypes().stream().filter(a -> a.getIdString().equals(changeItem.getItemTypeId().getIdString())).findFirst().orElse((AttributeTypeToken)AttributeTypeToken.SENTINEL);
                itemType = attrToken.isValid() ? attrToken.getName() : "";
            } else if (itemKind.equals("Relation")) {
                RelationTypeToken relToken = artA.getExistingRelationTypes().stream().filter(a -> a.getIdString().equals(changeItem.getItemTypeId().getIdString())).findFirst().orElse(RelationTypeToken.SENTINEL);
                String string = itemType = relToken.isValid() ? relToken.getName() : "";
            }
            if (itemKind.equals("Artifact")) {
                ApplicabilityToken currentApplic = changeItem.getCurrentVersion().getApplicabilityToken();
                ApplicabilityToken baselineApplic = changeItem.getBaselineVersion().getApplicabilityToken();
                if (currentApplic != null && baselineApplic != null && !currentApplic.equals((Object)baselineApplic)) {
                    changeType = "Applicability";
                    isValue = currentApplic.getName();
                    wasValue = baselineApplic.getName();
                }
            }
            if (itemKind.equals("Artifact") && changeType.equals("Modified")) {
                isValue = "";
                wasValue = "";
            }
            changeReportRows.add(new ChangeReportRowDto(ids, names, itemType, itemKind, changeType, isValue, wasValue));
        }
        return changeReportRows;
    }
}

