/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.search.ApplicabilityQueryImpl;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchQueryImpl;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionQueryImpl;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.search.TupleQuery;

public class QueryFactoryImpl
implements QueryFactory {
    private final CallableQueryFactory artQueryFactory;
    private final BranchCriteriaFactory branchCriteriaFactory;
    private final TransactionCriteriaFactory txCriteriaFactory;
    private final TupleQuery tupleQuery;
    private final ApplicabilityDsQuery applicabilityDsQuery;
    private final QueryEngine queryEngine;
    private final OrcsTokenService tokenService;
    private final OrcsApi orcsApi;

    public QueryFactoryImpl(OrcsApi orcsApi, CallableQueryFactory artQueryFactory, BranchCriteriaFactory branchCriteriaFactory, TransactionCriteriaFactory txCriteriaFactory, TupleQuery tupleQuery, ApplicabilityDsQuery applicabilityDsQuery, QueryEngine queryEngine, OrcsTokenService tokenService) {
        this.orcsApi = orcsApi;
        this.artQueryFactory = artQueryFactory;
        this.branchCriteriaFactory = branchCriteriaFactory;
        this.txCriteriaFactory = txCriteriaFactory;
        this.tupleQuery = tupleQuery;
        this.applicabilityDsQuery = applicabilityDsQuery;
        this.queryEngine = queryEngine;
        this.tokenService = tokenService;
    }

    public BranchQuery branchQuery() {
        return new BranchQueryImpl(this.queryEngine, this.branchCriteriaFactory, new QueryData(this, this.queryEngine, this.artQueryFactory, this.tokenService));
    }

    public QueryBuilder fromBranch(BranchId branch) {
        return new QueryData(this, this.queryEngine, this.artQueryFactory, this.tokenService, this.tokenService.getBranch(branch));
    }

    public QueryBuilder fromBranch(BranchId branch, ArtifactId view) {
        return new QueryData((QueryFactory)this, this.queryEngine, this.artQueryFactory, this.tokenService, this.tokenService.getBranch(branch), view);
    }

    public QueryBuilder fromBranch(BranchId branch, ApplicabilityId appId) {
        return new QueryData((QueryFactory)this, this.queryEngine, this.artQueryFactory, this.tokenService, this.tokenService.getBranch(branch), appId);
    }

    public TransactionQuery transactionQuery() {
        return new TransactionQueryImpl(this.queryEngine, this.txCriteriaFactory, new QueryData(this, this.queryEngine, this.artQueryFactory, this.tokenService), this.orcsApi.userService());
    }

    public TupleQuery tupleQuery() {
        return this.tupleQuery;
    }

    public ApplicabilityQuery applicabilityQuery() {
        return new ApplicabilityQueryImpl(this.applicabilityDsQuery, this, this.orcsApi);
    }
}

