/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationNodeLoader;
import org.eclipse.osee.orcs.core.internal.relation.RelationResolver;

public class RelationResolverImpl
implements RelationResolver {
    private final RelationNodeLoader loader;

    public RelationResolverImpl(RelationNodeLoader loader) {
        this.loader = loader;
    }

    @Override
    public <T extends Artifact> List<T> resolve(OrcsSession session, GraphData graph, List<Relation> links, RelationSide ... sides) {
        List<Object> toReturn = Collections.emptyList();
        if (!links.isEmpty()) {
            LinkedHashSet<ArtifactId> toLoad = null;
            LinkedHashMap<ArtifactId, Artifact> items = new LinkedHashMap<ArtifactId, Artifact>();
            for (Relation relation : links) {
                RelationSide[] relationSideArray = sides;
                int n = sides.length;
                int n2 = 0;
                while (n2 < n) {
                    RelationSide side = relationSideArray[n2];
                    ArtifactId artifactId = relation.getIdForSide(side);
                    Artifact node = (Artifact)graph.getNode(artifactId);
                    if (node == null) {
                        if (toLoad == null) {
                            toLoad = new LinkedHashSet<ArtifactId>();
                        }
                        toLoad.add(artifactId);
                    } else {
                        items.put(artifactId, node);
                    }
                    ++n2;
                }
            }
            if (toLoad != null && !toLoad.isEmpty()) {
                Iterable result = this.loader.loadNodes(session, graph, (Collection<ArtifactId>)toLoad, LoadLevel.ALL);
                for (Artifact item : result) {
                    items.put(ArtifactId.valueOf((Long)item.getId()), item);
                }
            }
            toReturn = this.toList(items.values());
        }
        return toReturn;
    }

    private <T> List<T> toList(Collection<T> values) {
        List<Object> list = values instanceof ArrayList ? (ArrayList)values : (values instanceof LinkedList ? (LinkedList)values : (values == null ? Collections.emptyList() : Lists.newLinkedList(values)));
        return list;
    }

    @Override
    public void resolve(OrcsSession session, GraphData graph, Artifact node) {
        this.loader.loadNodes(session, graph, Collections.singleton(node), LoadLevel.RELATION_DATA);
    }
}

