/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.proxy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetList;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.proxy.impl.AbstractProxied;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;

public class ArtifactReadOnlyImpl
extends AbstractProxied<Artifact>
implements ArtifactReadable {
    private final RelationManager relationManager;
    private final ArtifactTypeToken artifactType;

    public ArtifactReadOnlyImpl(ExternalArtifactManager proxyManager, RelationManager relationManager, OrcsSession session, Artifact proxiedObject, ArtifactTypeToken artifactType) {
        super(proxyManager, session, proxiedObject);
        this.relationManager = relationManager;
        this.artifactType = artifactType;
    }

    private RelationManager getRelationManager() {
        return this.relationManager;
    }

    public String getGuid() {
        return ((Artifact)this.getProxiedObject()).getGuid();
    }

    public String getName() {
        try {
            return this.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Name);
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            return this.getSafeName();
        }
    }

    public boolean matches(Id ... identities) {
        return ((Artifact)this.getProxiedObject()).matches(identities);
    }

    public BranchToken getBranch() {
        return ((Artifact)this.getProxiedObject()).getBranch();
    }

    public TransactionId getTransaction() {
        return ((Artifact)this.getProxiedObject()).getTransaction();
    }

    public TransactionId getLastModifiedTransaction() {
        return ((Artifact)this.getProxiedObject()).getLastModifiedTransaction();
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public boolean isOfType(ArtifactTypeId ... otherTypes) {
        return ((Artifact)this.getProxiedObject()).isOfType(otherTypes);
    }

    public int getAttributeCount(AttributeTypeToken type) {
        return ((Artifact)this.getProxiedObject()).getAttributeCount(type);
    }

    public int getAttributeCount(AttributeTypeToken type, DeletionFlag deletionFlag) {
        return ((Artifact)this.getProxiedObject()).getAttributeCount(type, deletionFlag);
    }

    public boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        return ((Artifact)this.getProxiedObject()).isAttributeTypeValid(attributeType);
    }

    public Collection<AttributeTypeToken> getValidAttributeTypes() {
        return ((Artifact)this.getProxiedObject()).getValidAttributeTypes();
    }

    public Collection<AttributeTypeToken> getExistingAttributeTypes() {
        return ((Artifact)this.getProxiedObject()).getExistingAttributeTypes();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType) {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeValue(attributeType);
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, DeletionFlag flag, T defaultValue) {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeValue(attributeType, flag, defaultValue);
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, T defaultValue) {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeValue(attributeType, defaultValue);
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeType) {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeAsString(attributeType);
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeType, String defaultValue) {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeAsString(attributeType, defaultValue);
    }

    public AttributeId getSoleAttributeId(AttributeTypeToken attributeType) {
        return ((Artifact)this.getProxiedObject()).getSoleAttribute(attributeType);
    }

    public Long getSoleAttributeId(AttributeTypeToken attributeType, Long defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType) {
        return ((Artifact)this.getProxiedObject()).getAttributeValues(attributeType);
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        return ((Artifact)this.getProxiedObject()).getAttributeValues(attributeType, deletionFlag);
    }

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
        return ((Artifact)this.getProxiedObject()).getAttributeIterable();
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes() {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes();
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public <T> List<IAttribute<T>> getAttributeList(AttributeTypeGeneric<T> attributeType) {
        return Collections.transform((Collection)this.getAttributes((AttributeTypeToken)attributeType).getList(), a -> a);
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType) {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(attributeType);
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(deletionFlag);
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(attributeType, deletionFlag);
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public AttributeReadable<Object> getAttributeById(AttributeId attributeId) {
        Attribute attribute = ((Artifact)this.getProxiedObject()).getAttributeById(attributeId);
        return this.getProxyManager().asExternalAttribute(this.getSession(), attribute);
    }

    private <T> List<T> getEnumAttributeValues(AttributeTypeToken attributeType) {
        ArrayList<EnumToken> attributeValues = new ArrayList<EnumToken>();
        if (attributeType.isEnumerated()) {
            ArrayList<T> enumAttributeValues = new ArrayList<T>();
            AttributeTypeEnum attributeTypeEnum = (AttributeTypeEnum)attributeType;
            enumAttributeValues.addAll(this.getAttributeValues(attributeType));
            for (String s : enumAttributeValues) {
                attributeValues.add(attributeTypeEnum.valueFromStorageString(s));
            }
        }
        return attributeValues;
    }

    public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> computedCharacteristic) {
        ArrayList<T> attributeValues = new ArrayList<T>();
        if (!this.artifactType.isComputedCharacteristicValid(computedCharacteristic)) {
            throw new OseeCoreException("Attribute Types on Artifact Type %s do not have valid multiplicity for computed characteristic %s", new Object[]{this.artifactType.getName(), computedCharacteristic.getName()});
        }
        for (AttributeTypeGeneric attributeType : computedCharacteristic.getAttributeTypesToCompute()) {
            if (attributeType.isEnumerated()) {
                attributeValues.addAll(this.getEnumAttributeValues((AttributeTypeToken)attributeType));
                continue;
            }
            attributeValues.addAll(this.getAttributeValues((AttributeTypeToken)attributeType));
        }
        return (T)computedCharacteristic.calculate(attributeValues);
    }

    public int getMaximumRelationAllowed(RelationTypeSide typeAndSide) {
        RelationTypeToken type = typeAndSide.getRelationType();
        RelationSide side = this.whichSideAmIOn(typeAndSide);
        return this.getRelationManager().getMaximumRelationAllowed(type, (Artifact)this.getProxiedObject(), side);
    }

    public Collection<RelationTypeToken> getValidRelationTypes() {
        return this.getRelationManager().getValidRelationTypes((Artifact)this.getProxiedObject());
    }

    public Collection<RelationTypeToken> getExistingRelationTypes() {
        return this.getRelationManager().getExistingRelationTypes((Artifact)this.getProxiedObject());
    }

    public ArtifactReadable getParent() {
        Object parent = this.getRelationManager().getParent(this.getSession(), (Artifact)this.getProxiedObject());
        return this.getProxyManager().asExternalArtifact(this.getSession(), (Artifact)parent);
    }

    public List<ArtifactReadable> getChildren() {
        ResultSet children = this.getRelationManager().getChildren(this.getSession(), (Artifact)this.getProxiedObject());
        return this.getProxyManager().asExternalArtifacts(this.getSession(), (Iterable<? extends Artifact>)children).getList();
    }

    public List<ArtifactReadable> getDescendants() {
        LinkedList<ArtifactReadable> descendants = new LinkedList<ArtifactReadable>();
        this.getDescendants(descendants);
        return descendants;
    }

    public void getDescendants(List<ArtifactReadable> descendants) {
        for (ArtifactReadable child : this.getChildren()) {
            descendants.add(child);
            child.getDescendants(descendants);
        }
    }

    public boolean isDescendantOf(ArtifactToken parent) {
        ArtifactReadable nextParent = this.getParent();
        while (nextParent != null) {
            if (nextParent.equals(parent)) {
                return true;
            }
            nextParent = nextParent.getParent();
        }
        return false;
    }

    @Deprecated
    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide typeAndSide) {
        return this.getRelatedResultSet(typeAndSide, DeletionFlag.EXCLUDE_DELETED);
    }

    public ResultSet<IRelationLink> getRelations(RelationTypeSide typeAndSide) {
        ArrayList<IRelationLink> rels = new ArrayList<IRelationLink>();
        for (IRelationLink iRelationLink : this.getRelationManager().getRelations((Artifact)this.getProxiedObject(), DeletionFlag.EXCLUDE_DELETED)) {
            if (!iRelationLink.getRelationType().equals(typeAndSide.getRelationType())) continue;
            rels.add(iRelationLink);
        }
        return new ResultSetList(Collections.castAll(rels));
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide typeAndSide, DeletionFlag deletionFlag) {
        return this.getRelatedResultSet(typeAndSide, deletionFlag).getList();
    }

    private ResultSet<ArtifactReadable> getRelatedResultSet(RelationTypeSide typeAndSide, DeletionFlag deletionFlag) {
        RelationTypeToken type = typeAndSide.getRelationType();
        RelationSide side = this.whichSideAmIOn(typeAndSide);
        ResultSet related = this.getRelationManager().getRelated(this.getSession(), type, (Artifact)this.getProxiedObject(), side, deletionFlag);
        return this.getProxyManager().asExternalArtifacts(this.getSession(), (Iterable<? extends Artifact>)related);
    }

    public int getRelatedCount(RelationTypeSide typeAndSide) {
        RelationTypeToken type = typeAndSide.getRelationType();
        RelationSide side = this.whichSideAmIOn(typeAndSide);
        return this.getRelationManager().getRelatedCount(type, (Artifact)this.getProxiedObject(), side);
    }

    public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable artifact) {
        RelationTypeToken type = typeAndSide.getRelationType();
        Pair<Artifact, Artifact> nodes = this.asABNodes(typeAndSide.getSide(), artifact);
        return this.getRelationManager().areRelated((Artifact)nodes.getFirst(), type, (Artifact)nodes.getSecond());
    }

    public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) {
        RelationTypeToken type = typeAndSide.getRelationType();
        Pair<Artifact, Artifact> nodes = this.asABNodes(typeAndSide.getSide(), readable);
        return this.getRelationManager().getRationale((Artifact)nodes.getFirst(), type, (Artifact)nodes.getSecond());
    }

    private Pair<Artifact, Artifact> asABNodes(RelationSide side, ArtifactReadable readable) {
        Artifact bNode;
        Artifact aNode;
        Artifact thisArtifact = (Artifact)this.getProxiedObject();
        Artifact otherArtifact = this.getProxyManager().asInternalArtifact(readable);
        if (RelationSide.SIDE_A == side) {
            aNode = otherArtifact;
            bNode = thisArtifact;
        } else {
            aNode = thisArtifact;
            bNode = otherArtifact;
        }
        return new Pair((Object)aNode, (Object)bNode);
    }

    private RelationSide whichSideAmIOn(RelationTypeSide typeAndSide) {
        return typeAndSide.getSide().oppositeSide();
    }

    public Long getId() {
        return ((Artifact)this.getProxiedObject()).getId();
    }

    @Override
    public String toString() {
        return String.format("Artifact: Id [%s] Type [%s] Name [%s]", this.getIdString(), this.getArtifactType().getName(), this.getSafeName());
    }

    public boolean isDeleted() {
        return ((Artifact)this.getProxiedObject()).isDeleted();
    }

    public ModificationType getModificationType() {
        return ((Artifact)this.getProxiedObject()).getModificationType();
    }

    public Collection<ArtifactId> getChildrentIds() {
        return this.getRelatedIds(CoreRelationTypes.DefaultHierarchical_Child);
    }

    public List<ArtifactId> getRelatedIds(RelationTypeSide relationTypeSide) {
        ArrayList<ArtifactId> relatedIds = new ArrayList<ArtifactId>();
        for (Relation relation : this.getRelationManager().getRelations((Artifact)this.getProxiedObject(), DeletionFlag.EXCLUDE_DELETED)) {
            if (!relation.getRelationType().equals(relationTypeSide.getRelationType())) continue;
            boolean aSide = relationTypeSide.getSide().isSideA();
            if (aSide && relation.getArtifactIdB().equals(this)) {
                relatedIds.add(relation.getArtifactIdA());
                continue;
            }
            if (aSide || !relation.getArtifactIdA().equals(this)) continue;
            relatedIds.add(relation.getArtifactIdB());
        }
        return relatedIds;
    }

    public boolean isHistorical() {
        return ((ArtifactData)((Artifact)this.getProxiedObject()).getOrcsData()).getVersion().isHistorical();
    }

    public ApplicabilityToken getApplicabilityToken() {
        return ApplicabilityToken.valueOf((long)((ArtifactData)((Artifact)this.getProxiedObject()).getOrcsData()).getApplicabilityId().getId(), (String)"");
    }

    public ApplicabilityId getApplicability() {
        return ((ArtifactData)((Artifact)this.getProxiedObject()).getOrcsData()).getApplicabilityId();
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public String getSafeName() {
        return this.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name, DeletionFlag.INCLUDE_DELETED, "Unknown Name: " + this.getIdString());
    }

    public List<ArtifactReadable> getRelatedList(RelationTypeSide relationTypeSide) {
        return this.getRelated(relationTypeSide).getList();
    }

    public List<String> fetchAttributesAsStringList(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }
}

