/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest.morphology;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.DuplicateStoreEntryException;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.Store;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.StoreType;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.util.HierarchyTree;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;

class StoreRank3
implements Store {
    private static int rank = 3;
    protected final Map<Identifier, HierarchyTree<Identifier, GroveThing>> hierarchyTrees;
    private final Predicate<Object>[] keyValidators;
    private final Map<Object, GroveThing> uniquePrimaryKeyMap;
    private final StoreType storeType;

    public StoreRank3(StoreType storeType, Predicate<Object> primaryKeyValidator, Predicate<Object> secondaryKeyValidator, Predicate<Object> tertiaryKeyValidator) {
        assert (Objects.nonNull((Object)storeType) && StoreType.PRIMARY_HIERARCHY.equals((Object)storeType)) : "StoreRank3::new, parameter \"storeType\" is invalid.";
        this.storeType = storeType;
        this.keyValidators = new Predicate[]{Objects.requireNonNull(primaryKeyValidator), Objects.requireNonNull(secondaryKeyValidator), Objects.requireNonNull(tertiaryKeyValidator)};
        this.hierarchyTrees = new HashMap<Identifier, HierarchyTree<Identifier, GroveThing>>(1024, 0.75f);
        this.uniquePrimaryKeyMap = new HashMap<Object, GroveThing>(1024, 0.75f);
    }

    @Override
    public void add(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing)) : "StoreRank3::add, groveThing is null.";
        if (groveThing.isType(IdentifierType.SPECIFICATION)) {
            Identifier key = groveThing.getIdentifier();
            if (this.uniquePrimaryKeyMap.containsKey(key)) {
                throw new DuplicateStoreEntryException(this, groveThing);
            }
            HierarchyTree<Identifier, GroveThing> hierarchyTree = new HierarchyTree<Identifier, GroveThing>();
            hierarchyTree.setRoot(key, groveThing);
            this.hierarchyTrees.put(key, hierarchyTree);
            this.uniquePrimaryKeyMap.put(key, groveThing);
        } else {
            groveThing.getPrimaryKeys().ifPresent(keys -> {
                assert (ParameterArray.validateNonNullSizeAndElements((Object[])keys, (int)rank, (int)rank, (Predicate[])this.keyValidators)) : new StringBuilder(1024).append("\n").append("StoreRank3::add, primary keys failed to validate for GroveThing").append("\n").append("   GroveThing folows:").append("\n").append(groveThing).append("\n");
                if (this.uniquePrimaryKeyMap.containsKey(keys[2])) {
                    throw new DuplicateStoreEntryException(this, groveThing);
                }
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                if (Objects.isNull(hierarchyTree)) {
                    hierarchyTree = new HierarchyTree();
                    this.hierarchyTrees.put((Identifier)keys[0], hierarchyTree);
                }
                hierarchyTree.insertLast((Identifier)keys[1], (Identifier)keys[2], groveThing);
                this.uniquePrimaryKeyMap.put(keys[2], groveThing);
            });
        }
    }

    @Override
    public boolean contains(Object ... keys) {
        assert (ParameterArray.validateNonNullSizeAndElements((Object[])keys, (int)1, (int)rank, (Predicate[])this.keyValidators));
        HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
        if (Objects.isNull(hierarchyTree)) {
            return false;
        }
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 2: {
                return hierarchyTree.containsKey((Identifier)keys[1]);
            }
            case 3: {
                return hierarchyTree.containsKey((Identifier)keys[1], (Identifier)keys[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Optional<GroveThing> get(Object ... keys) {
        assert (ParameterArray.validateNonNullSizeAndElements((Object[])keys, (int)2, (int)rank, (Predicate[])this.keyValidators));
        HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
        if (Objects.isNull(hierarchyTree)) {
            return null;
        }
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 2: {
                return Optional.ofNullable(hierarchyTree.get((Identifier)keys[1]));
            }
            case 3: {
                return hierarchyTree.get((Identifier)keys[1], (Identifier)keys[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Optional<GroveThing> getByUniqueKey(Object uniqueKey) {
        assert (Objects.nonNull(uniqueKey) && (Objects.isNull(this.keyValidators) || Objects.isNull(this.keyValidators[1]) || this.keyValidators[1].test(uniqueKey))) : "StoreRank3::getByUniqueKey, key failed validation.";
        return Optional.ofNullable(this.uniquePrimaryKeyMap.get(uniqueKey));
    }

    @Override
    public StoreType getType() {
        return this.storeType;
    }

    @Override
    public int rank() {
        return rank;
    }

    @Override
    public int size() {
        return this.hierarchyTrees.values().stream().collect(Collectors.summingInt(HierarchyTree::size));
    }

    @Override
    public Stream<GroveThing> stream(Object ... keys) {
        assert (ParameterArray.validateSizeAndElements((Object[])keys, (int)0, (int)rank, (Predicate[])this.keyValidators));
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 0: {
                return this.hierarchyTrees.values().stream().flatMap(HierarchyTree::streamValuesDeep);
            }
            case 1: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamValuesDeep() : Stream.empty();
            }
            case 2: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamValuesShallow((Identifier)keys[1]) : Stream.empty();
            }
            case 3: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.get((Identifier)keys[1], (Identifier)keys[2]).map(value -> Stream.of(value)).orElseGet(Stream::empty) : Stream.empty();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Stream<Object> streamKeysAtAndBelow(Object ... keys) {
        assert (ParameterArray.validateSizeAndElements((Object[])keys, (int)0, (int)rank, (Predicate[])this.keyValidators));
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 0: {
                return this.hierarchyTrees.keySet().stream().flatMap(treeKey -> this.hierarchyTrees.get(treeKey).streamKeysDeep());
            }
            case 1: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysDeep() : Stream.empty();
            }
            case 2: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysDeep((Identifier)keys[1]) : Stream.empty();
            }
            case 3: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return (Objects.nonNull(hierarchyTree) ? hierarchyTree.get((Identifier)keys[1], (Identifier)keys[2]) : Optional.empty()).map(child -> Stream.of(keys[2])).orElseGet(Stream::empty);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Stream<Object> streamKeysAt(Object ... keys) {
        assert (ParameterArray.validateSizeAndElements((Object[])keys, (int)0, (int)rank, (Predicate[])this.keyValidators));
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 0: {
                return this.hierarchyTrees.keySet().stream();
            }
            case 1: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysShallow((Identifier)keys[0]) : Stream.empty();
            }
            case 2: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysShallow((Identifier)keys[1]) : Stream.empty();
            }
            case 3: {
                HierarchyTree<Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return (Objects.nonNull(hierarchyTree) ? hierarchyTree.get((Identifier)keys[1], (Identifier)keys[2]) : Optional.empty()).map(child -> Stream.of(keys[2])).orElseGet(Stream::empty);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Stream<Object[]> streamKeySets(Object ... keys) {
        return this.streamKeysAtAndBelow(keys).map(this.uniquePrimaryKeyMap::get).filter(Objects::nonNull).map(GroveThing::getPrimaryKeys).filter(Optional::isPresent).map(Optional::get).map(lowerKeys -> {
            Class<?> keyClass = lowerKeys[0].getClass();
            Object[] keyArray = (Object[])Array.newInstance(keyClass, 3);
            keyArray[0] = keys[0];
            if (((Object[])lowerKeys).length == 1) {
                keyArray[1] = lowerKeys[0];
                keyArray[2] = lowerKeys[0];
            } else {
                keyArray[1] = lowerKeys[1];
                keyArray[2] = lowerKeys[2];
            }
            return keyArray;
        });
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.indent(indent).title((CharSequence)this.getClass().getSimpleName()).indentInc().segment((CharSequence)"Rank", (Object)this.rank()).segment((CharSequence)"Store Type", (Object)this.storeType).segment((CharSequence)"Current Size", (Object)this.size()).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

