/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osee.define.api.publishing.templatemanager.InvalidRendererOptionsException;
import org.eclipse.osee.define.api.publishing.templatemanager.InvalidWordMlTemplateException;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.RendererOptions;
import org.eclipse.osee.define.api.publishing.templatemanager.TemplateContent;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.xml.sax.SAXParseException;

class ArtifactPublishingTemplate
implements PublishingTemplateInternal {
    private final ArtifactReadable artifactReadable;
    private final String identifier;
    private final String name;
    private final RendererOptions rendererOptions;
    private final TemplateContent templateContent;
    private final List<String> templateMatchCriteria;
    private String style;

    ArtifactPublishingTemplate(ArtifactReadable artifactReadable) {
        this.artifactReadable = Objects.requireNonNull(artifactReadable);
        this.identifier = "AT-" + this.artifactReadable.getIdString();
        this.name = this.artifactReadable.getName();
        try {
            this.rendererOptions = RendererOptions.create((String)this.artifactReadable.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.RendererOptions));
        }
        catch (InvalidRendererOptionsException e) {
            e.setPublishingTemplateInformation(this.identifier, this.name);
            throw e;
        }
        String templateXml = this.artifactReadable.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent);
        this.templateContent = new TemplateContent(templateXml);
        Optional documentOptional = this.templateContent.getTemplateXml();
        if (documentOptional.isEmpty()) {
            String message = this.templateContent.getTemplateXmlParseError().map(exception -> exception instanceof SAXParseException ? new Message().title((CharSequence)"Template Word ML XML parsing failed.").indentInc().title((CharSequence)exception.getMessage()).indentInc().segment((CharSequence)"LineNumber", (Object)((SAXParseException)exception).getLineNumber()).segment((CharSequence)"Column Number", (Object)((SAXParseException)exception).getColumnNumber()).toString() : exception.getMessage()).orElse("Template Word ML XML parsing failed.");
            throw new InvalidWordMlTemplateException(this.identifier, this.name, message, templateXml);
        }
        this.templateMatchCriteria = this.buildTemplateMatchCriteriaList();
        try {
            List templateRelatedArtifacts = this.artifactReadable.getRelated(CoreRelationTypes.SupportingInfo_SupportingInfo).getList();
            this.style = templateRelatedArtifacts.size() == 1 ? ((ArtifactReadable)templateRelatedArtifacts.get(0)).getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent) : "";
        }
        catch (Exception exception2) {
            this.style = "";
        }
    }

    private List<String> buildTemplateMatchCriteriaList() {
        try {
            List matchCriteriaObjectList = this.artifactReadable.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria);
            List<String> matchCriteriaList = matchCriteriaObjectList.stream().map(Object::toString).collect(Collectors.toUnmodifiableList());
            return matchCriteriaList;
        }
        catch (Exception exception) {
            return List.of();
        }
    }

    @Override
    public PublishingTemplate getBean() {
        return new PublishingTemplate(this.identifier, this.name, this.rendererOptions, this.style, this.templateContent);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RendererOptions getRendererOptions() {
        return this.rendererOptions;
    }

    @Override
    public String getSafeName() {
        return this.artifactReadable.getSafeName();
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public TemplateContent getTemplateContent() {
        return this.templateContent;
    }

    @Override
    public List<String> getTemplateMatchCriteria() {
        return this.templateMatchCriteria;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"ArtifactPublishingTemplate").indentInc().segment((CharSequence)"Class", (Object)this.getClass().getSimpleName()).segment((CharSequence)"Artifact Readable", (Object)this.artifactReadable).segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).segment((CharSequence)"Style", (Object)this.style).segment((CharSequence)"Template Match Criteria", this.templateMatchCriteria).toMessage((ToMessage)this.rendererOptions).toMessage((ToMessage)this.templateContent);
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

