/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.Objects;
import org.eclipse.osee.define.operations.publishing.UserNotAuthorizedForPublishingException;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.orcs.OrcsApi;

public class PublishingPermissions {
    private static PublishingPermissions instance = null;
    private final UserService userService;

    private PublishingPermissions(UserService userService) {
        this.userService = userService;
    }

    public static void create(OrcsApi orcsApi) {
        if (Objects.nonNull(instance)) {
            return;
        }
        UserService userService = Objects.requireNonNull(Objects.requireNonNull(orcsApi, "PublishingPermissions::new, parameter \"orcsApi\" is null.").userService(), "PublishingPermissions::new, failed to get the \"UserService\" from the \"orcsApi\".");
        instance = new PublishingPermissions(userService);
    }

    public static void verify() {
        if (Objects.isNull(instance)) {
            throw new IllegalStateException();
        }
        int causeFlags = (PublishingPermissions.instance.userService.isInUserGroup(new IUserGroupArtifactToken[]{CoreUserGroups.Publishing}) ? 0 : UserNotAuthorizedForPublishingException.NOT_IN_PUBLISHING_GROUP) + (PublishingPermissions.instance.userService.isActiveUser() ? 0 : UserNotAuthorizedForPublishingException.NOT_ACTIVE_USER) + (PublishingPermissions.instance.userService.isLoginUser() ? 0 : UserNotAuthorizedForPublishingException.NOT_LOGIN_USER);
        if (causeFlags > 0) {
            throw new UserNotAuthorizedForPublishingException(causeFlags, PublishingPermissions.instance.userService.getUser());
        }
    }

    public static void verifyNonGroup() {
        if (Objects.isNull(instance)) {
            throw new IllegalStateException();
        }
        int causeFlags = (PublishingPermissions.instance.userService.isActiveUser() ? 0 : UserNotAuthorizedForPublishingException.NOT_ACTIVE_USER) + (PublishingPermissions.instance.userService.isLoginUser() ? 0 : UserNotAuthorizedForPublishingException.NOT_LOGIN_USER);
        if (causeFlags > 0) {
            throw new UserNotAuthorizedForPublishingException(causeFlags, PublishingPermissions.instance.userService.getUser());
        }
    }
}

