/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters;

import java.security.Key;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.KeyProperties;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.AccessToken;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.AuthorizationCode;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.RefreshOAuthToken;
import org.eclipse.osee.jaxrs.server.session.SessionData;

public class OAuthEncryption {
    private static final String AES_CRYPTO_ALGO = "AES";
    private static final String SEP = "|";

    public SecretKey decodeSecretKey(String encodedSecretKey, String secretKeyAlgorithm) {
        String secretKeyAlgorithmToUse = secretKeyAlgorithm;
        if (!Strings.isValid((String)secretKeyAlgorithmToUse)) {
            secretKeyAlgorithmToUse = AES_CRYPTO_ALGO;
        }
        return CryptoUtils.decodeSecretKey((String)encodedSecretKey, (String)secretKeyAlgorithmToUse);
    }

    public String encryptCodeGrant(AuthorizationCode grant, SecretKey secretKey) throws SecurityException {
        return OAuthEncryption.encryptCodeGrant(grant, secretKey, null);
    }

    private static String encryptCodeGrant(ServerAuthorizationCodeGrant grant, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = OAuthEncryption.tokenizeCodeGrant(grant);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    private static String tokenizeCodeGrant(ServerAuthorizationCodeGrant grant) {
        StringBuilder state = new StringBuilder();
        state.append(grant.getClient().getClientId());
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(grant.getCode()));
        state.append(SEP);
        state.append(grant.getExpiresIn());
        state.append(SEP);
        state.append(grant.getIssuedAt());
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(grant.getRedirectUri()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(grant.getAudience()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(grant.getCodeVerifier()));
        state.append(SEP);
        state.append(grant.getApprovedScopes().toString());
        state.append(SEP);
        OAuthEncryption.tokenizeUserSubject(state, grant.getSubject());
        return state.toString();
    }

    public String encryptSessionToken(SessionData session, SecretKey secretKey) {
        return this.encryptSessionToken(session, secretKey, null);
    }

    private String encryptSessionToken(SessionData session, SecretKey secretKey, KeyProperties props) {
        String tokenSequence = OAuthEncryption.tokenizeSessionToken(session);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public String encryptAccessToken(AccessToken token, SecretKey secretKey) {
        return OAuthEncryption.encryptAccessToken(token, secretKey, null);
    }

    private static String encryptAccessToken(ServerAccessToken token, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = OAuthEncryption.tokenizeServerToken(token);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public String encryptRefreshToken(RefreshOAuthToken refreshToken, SecretKey secretKey) {
        return OAuthEncryption.encryptRefreshToken(refreshToken, secretKey, null);
    }

    private static String encryptRefreshToken(RefreshToken token, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = OAuthEncryption.tokenizeRefreshToken(token);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public ServerAuthorizationCodeGrant decryptCodeGrant(OAuthDataProvider provider, String grant, SecretKey secretKey) {
        return OAuthEncryption.decryptCodeGrant(provider, grant, secretKey, null);
    }

    private static ServerAuthorizationCodeGrant decryptCodeGrant(OAuthDataProvider provider, String encodedData, Key key, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)key, (KeyProperties)props);
        return OAuthEncryption.recreateCodeGrant(provider, decryptedSequence);
    }

    private static ServerAuthorizationCodeGrant recreateCodeGrant(OAuthDataProvider provider, String decryptedSequence) throws SecurityException {
        return OAuthEncryption.recreateCodeGrantInternal(provider, decryptedSequence);
    }

    private static ServerAuthorizationCodeGrant recreateCodeGrantInternal(OAuthDataProvider provider, String sequence) {
        String[] parts = OAuthEncryption.getParts(sequence);
        ServerAuthorizationCodeGrant grant = new ServerAuthorizationCodeGrant(provider.getClient(parts[0]), parts[1], Long.valueOf(parts[2]).longValue(), Long.valueOf(parts[3]).longValue());
        grant.setRedirectUri(OAuthEncryption.getStringPart(parts[4]));
        grant.setAudience(OAuthEncryption.getStringPart(parts[5]));
        grant.setCodeVerifier(OAuthEncryption.getStringPart(parts[6]));
        grant.setApprovedScopes(OAuthEncryption.parseSimpleList(parts[7]));
        grant.setSubject(OAuthEncryption.recreateUserSubject(parts[8]));
        return grant;
    }

    private static UserSubject recreateUserSubject(String sequence) {
        UserSubject subject = null;
        if (!sequence.trim().isEmpty()) {
            String[] subjectParts = sequence.split("&");
            subject = new UserSubject(OAuthEncryption.getStringPart(subjectParts[0]), OAuthEncryption.getStringPart(subjectParts[1]));
            subject.setRoles(OAuthEncryption.parseSimpleList(subjectParts[2]));
            subject.setProperties(OAuthEncryption.parseSimpleMap(subjectParts[3]));
        }
        return subject;
    }

    private static Map<String, String> parseSimpleMap(String mapStr) {
        HashMap<String, String> props = new HashMap<String, String>();
        List<String> entries = OAuthEncryption.parseSimpleList(mapStr);
        for (String entry : entries) {
            String[] pair = entry.split("=");
            props.put(pair[0].trim(), pair[1]);
        }
        return props;
    }

    private static String prepareSimpleString(String str) {
        return str.trim().isEmpty() ? "" : str.substring(1, str.length() - 1);
    }

    private static List<String> parseSimpleList(String listStr) {
        return Collections.fromString((String)OAuthEncryption.prepareSimpleString(listStr), (String)",");
    }

    private static String getStringPart(String str) {
        return " ".equals(str) ? null : str;
    }

    private static String[] getParts(String sequence) {
        return sequence.split("\\|");
    }

    public SessionData decryptSessionToken(String token, SecretKey secretKey) {
        String decryptedSequence = CryptoUtils.decryptSequence((String)token, (Key)secretKey, null);
        String[] parts = OAuthEncryption.getParts(decryptedSequence);
        UserSubject recreateUserSubject = OAuthEncryption.recreateUserSubject(parts[9]);
        SessionData toReturn = new SessionData(parts[0]);
        toReturn.setAccountActive(Boolean.getBoolean(parts[1]));
        toReturn.setExpiresIn(Long.valueOf(parts[2]));
        toReturn.setIssuedAt(Long.valueOf(parts[3]));
        toReturn.setAccountDisplayName(parts[4]);
        toReturn.setAccountEmail(parts[5]);
        toReturn.setAccountName(parts[6]);
        toReturn.setAccountUsername(parts[7]);
        toReturn.setAccountId(Long.valueOf(parts[8]));
        toReturn.setSubject(recreateUserSubject);
        return toReturn;
    }

    public ServerAccessToken decryptAccessToken(OAuthDataProvider provider, String token, SecretKey secretKey) {
        ServerAccessToken accessToken = OAuthEncryption.decryptAccessToken(provider, token, secretKey, null);
        return accessToken;
    }

    private static ServerAccessToken decryptAccessToken(OAuthDataProvider provider, String encodedData, Key secretKey, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)secretKey, (KeyProperties)props);
        return OAuthEncryption.recreateAccessToken(provider, encodedData, decryptedSequence);
    }

    private static ServerAccessToken recreateAccessToken(OAuthDataProvider provider, String newTokenKey, String decryptedSequence) throws SecurityException {
        return OAuthEncryption.recreateAccessToken(provider, newTokenKey, OAuthEncryption.getParts(decryptedSequence));
    }

    private static ServerAccessToken recreateAccessToken(OAuthDataProvider provider, String newTokenKey, String[] parts) {
        ServerAccessToken newToken = new ServerAccessToken(provider.getClient(parts[4]), parts[1], newTokenKey == null ? parts[0] : newTokenKey, Long.valueOf(parts[2]), Long.valueOf(parts[3])){
            private static final long serialVersionUID = 7381031812625396582L;
        };
        newToken.setRefreshToken(OAuthEncryption.getStringPart(parts[5]));
        newToken.setGrantType(OAuthEncryption.getStringPart(parts[6]));
        LinkedList<String> audi = new LinkedList<String>();
        audi.add(parts[7]);
        newToken.setAudiences(audi);
        newToken.setParameters(OAuthEncryption.parseSimpleMap(parts[8]));
        if (!parts[9].trim().isEmpty()) {
            LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
            String[] allPermParts = parts[9].split("&");
            int i = 0;
            while (i + 4 < allPermParts.length) {
                OAuthPermission perm = new OAuthPermission(allPermParts[i], allPermParts[i + 1]);
                perm.setDefaultPermission(Boolean.valueOf(allPermParts[i + 2]).booleanValue());
                perm.setHttpVerbs(OAuthEncryption.parseSimpleList(allPermParts[i + 3]));
                perm.setUris(OAuthEncryption.parseSimpleList(allPermParts[i + 4]));
                perms.add(perm);
                i += 5;
            }
            newToken.setScopes(perms);
        }
        newToken.setSubject(OAuthEncryption.recreateUserSubject(parts[10]));
        return newToken;
    }

    public RefreshToken decryptRefreshToken(OAuthDataProvider provider, String token, SecretKey secretKey) {
        return OAuthEncryption.decryptRefreshToken(provider, token, secretKey, null);
    }

    private static RefreshToken decryptRefreshToken(OAuthDataProvider provider, String encodedData, Key key, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)key, (KeyProperties)props);
        return OAuthEncryption.recreateRefreshToken(provider, encodedData, decryptedSequence);
    }

    private static RefreshToken recreateRefreshToken(OAuthDataProvider provider, String newTokenKey, String decryptedSequence) throws SecurityException {
        String[] parts = OAuthEncryption.getParts(decryptedSequence);
        ServerAccessToken token = OAuthEncryption.recreateAccessToken(provider, newTokenKey, parts);
        return new RefreshToken(token, newTokenKey, OAuthEncryption.parseSimpleList(parts[parts.length - 1]));
    }

    private static String tokenizeRefreshToken(RefreshToken token) {
        String seq = OAuthEncryption.tokenizeServerToken((ServerAccessToken)token);
        return String.valueOf(seq) + SEP + token.getAccessTokens().toString();
    }

    private static String tokenizeSessionToken(SessionData session) {
        StringBuilder state = new StringBuilder();
        state.append(OAuthEncryption.tokenizeString((String)session.getGuid()));
        state.append(SEP);
        state.append(session.getAccountActive());
        state.append(SEP);
        state.append(session.getExpiresIn());
        state.append(SEP);
        state.append(session.getIssuedAt());
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(session.getAccountDisplayName()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(session.getAccountEmail()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(session.getAccountName()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(session.getAccountUsername()));
        state.append(SEP);
        state.append(session.getAccountId());
        state.append(SEP);
        OAuthEncryption.tokenizeUserSubject(state, session.getSubject());
        return state.toString();
    }

    private static String tokenizeServerToken(ServerAccessToken token) {
        StringBuilder state = new StringBuilder();
        state.append(OAuthEncryption.tokenizeString(token.getTokenKey()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(token.getTokenType()));
        state.append(SEP);
        state.append(token.getExpiresIn());
        state.append(SEP);
        state.append(token.getIssuedAt());
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(token.getClient().getClientId()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(token.getRefreshToken()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(token.getGrantType()));
        state.append(SEP);
        state.append(OAuthEncryption.tokenizeString(token.getAudiences().toString()));
        state.append(SEP);
        state.append(token.getParameters().toString());
        state.append(SEP);
        if (token.getScopes().isEmpty()) {
            state.append(" ");
        } else {
            for (OAuthPermission p : token.getScopes()) {
                state.append(OAuthEncryption.tokenizeString(p.getPermission()));
                state.append(".");
                state.append(OAuthEncryption.tokenizeString(p.getDescription()));
                state.append(".");
                state.append(p.isDefaultPermission());
                state.append(".");
                state.append(p.getHttpVerbs().toString());
                state.append(".");
                state.append(p.getUris().toString());
            }
        }
        state.append(SEP);
        OAuthEncryption.tokenizeUserSubject(state, token.getSubject());
        return state.toString();
    }

    private static void tokenizeUserSubject(StringBuilder state, UserSubject subject) {
        if (subject != null) {
            state.append(OAuthEncryption.tokenizeString(subject.getLogin()));
            state.append("&");
            state.append(OAuthEncryption.tokenizeString(subject.getId()));
            state.append("&");
            String roles = OAuthEncryption.tokenizeString(subject.getRoles().toString());
            state.append(roles.replaceAll(", ", ","));
            state.append("&");
            state.append(OAuthEncryption.tokenizeString(subject.getProperties().toString()));
        } else {
            state.append("&");
        }
    }

    private static String tokenizeString(String str) {
        return str != null ? str.trim() : " ";
    }
}

