/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.template.engine.AppendableRule;
import org.eclipse.osee.template.engine.StringRule;

public final class PageCreator {
    private static final Pattern xmlProcessingInstructionStartOrEnd = Pattern.compile("(\\?>)|(<\\?\\s*)");
    private static final Pattern xmlProcessingInstructionStart = Pattern.compile("\\s*<\\?");
    private static final Pattern emptyOrWhitespaceOnly = Pattern.compile("\\s*");
    private static final Pattern newlineStart = Pattern.compile("\\A\\r?\\n?");
    private static final Pattern newlineEnd = Pattern.compile("\\r?\\n?\\z");
    private static final Pattern processingInstructionPath = Pattern.compile("path=\"([^ ]+)");
    private static final Pattern processingInstructionId = Pattern.compile("id=\"([^\"]+)");
    private static final Pattern includeInstructionParseAttribute = Pattern.compile("parse=\"(.)+\"");
    private static final int NumOfCharsInTypicalSmallPage = 7000;
    private final IResourceRegistry registry;
    private final ConcurrentHashMap<String, AppendableRule<?>> substitutions = new ConcurrentHashMap();

    public PageCreator(IResourceRegistry registry) {
        this.registry = registry;
    }

    public Set<String> getAttributes() {
        return Collections.unmodifiableSet(this.substitutions.keySet());
    }

    public void addSubstitution(AppendableRule<?> ... rules) {
        AppendableRule<?>[] appendableRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            AppendableRule<?> rule = appendableRuleArray[n2];
            this.substitutions.put(rule.getName(), rule);
            ++n2;
        }
    }

    public void addKeyValuePair(String ruleName, CharSequence substitution) {
        this.addSubstitution(new StringRule(ruleName, substitution));
    }

    public void addKeyValuePairs(String ... keyValues) {
        int i = 0;
        while (i < keyValues.length) {
            this.addKeyValuePair(keyValues[i], keyValues[i + 1]);
            i += 2;
        }
    }

    public void addKeyValuePairs(Iterable<String> keyValuePairs) {
        Iterator<String> iterator = keyValuePairs.iterator();
        while (iterator.hasNext()) {
            this.addKeyValuePair(iterator.next(), iterator.next());
        }
    }

    public String getValue(String ruleName) {
        AppendableRule<?> appendableRule = this.substitutions.get(ruleName);
        if (appendableRule != null) {
            return appendableRule.toString();
        }
        return null;
    }

    public void readKeyValuePairs(ResourceToken keyValueResource) {
        this.readKeyValuePairs(keyValueResource.getInputStream());
    }

    public void readKeyValuePairs(InputStream keyValueStream) {
        Scanner scanner = new Scanner(keyValueStream, "UTF-8");
        scanner.useDelimiter(xmlProcessingInstructionStartOrEnd);
        try {
            try {
                String id = null;
                StringBuilder substitution = new StringBuilder(7000);
                boolean isProcessingInstruction = false;
                while (scanner.hasNext()) {
                    isProcessingInstruction = scanner.findInLine(xmlProcessingInstructionStart) != null;
                    String token = scanner.next();
                    if (emptyOrWhitespaceOnly.matcher(token).matches()) continue;
                    if (token.startsWith("include")) {
                        this.handleInclude(substitution, token);
                        substitution = new StringBuilder(7000);
                        continue;
                    }
                    if (token.startsWith("rule ")) {
                        this.handleRule(substitution, token);
                        continue;
                    }
                    if (isProcessingInstruction) {
                        if (id != null) {
                            this.addKeyValuePair(id, substitution);
                            substitution = new StringBuilder(7000);
                        }
                        id = token;
                        continue;
                    }
                    substitution.append(this.trimToken(token));
                }
                if (id != null) {
                    this.addKeyValuePair(id, substitution);
                }
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
        finally {
            scanner.close();
        }
    }

    private void handleRule(StringBuilder substitution, String token) {
        String ruleName = this.getRuleNamefromToken(token);
        if (!Strings.isValid((String)ruleName)) {
            throw new OseeArgumentException("no rule name specified in token %s", new Object[]{token});
        }
        AppendableRule<?> rule = this.substitutions.get(ruleName);
        if (rule == null) {
            throw new OseeArgumentException("no rule was found for token %s", new Object[]{token});
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.parseArgumentList(token, attributes);
        try {
            rule.applyTo((Appendable)substitution, (Map<String, String>)attributes);
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
        String id = (String)attributes.get("id");
        this.addKeyValuePair(id, substitution);
    }

    public String realizePage(ResourceToken templateResource) {
        return this.realizePage(templateResource, true);
    }

    public Appendable realizePage(ResourceToken templateResource, Appendable page) {
        return this.realizePage(templateResource, page, true);
    }

    private String realizePage(ResourceToken templateResource, boolean processInstructions) {
        StringBuilder page = new StringBuilder(7000);
        return this.realizePage(templateResource, (Appendable)page, processInstructions).toString();
    }

    private Appendable realizePage(ResourceToken templateResource, Appendable page, boolean processInstructions) {
        return this.realizePage(templateResource.getInputStream(), page, processInstructions);
    }

    private Appendable realizePage(InputStream template, Appendable page, boolean processInstructions) {
        try (Scanner scanner = new Scanner(template, "UTF-8");){
            try {
                scanner.useDelimiter(xmlProcessingInstructionStartOrEnd);
                boolean isProcessingInstruction = processInstructions ? scanner.findInLine(xmlProcessingInstructionStart) != null : false;
                while (scanner.hasNext()) {
                    boolean bl;
                    this.processToken(page, scanner.next(), isProcessingInstruction);
                    if (processInstructions) {
                        if (isProcessingInstruction) {
                            bl = false;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = isProcessingInstruction = false;
                }
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
        return page;
    }

    private Long toUniversalId(String token) {
        Matcher pathMatcher = processingInstructionPath.matcher(token);
        if (pathMatcher.find()) {
            return Long.parseLong(pathMatcher.group(1), 16);
        }
        throw new OseeArgumentException("include path from token[%s] is not of the expected format", new Object[]{token});
    }

    private String getProcessingInstructionId(String token) {
        Matcher idMatcher = processingInstructionId.matcher(token);
        if (idMatcher.find()) {
            return idMatcher.group(1);
        }
        return null;
    }

    private void processToken(Appendable page, String token, boolean isProcessingInstruction) throws IOException {
        if (isProcessingInstruction) {
            if (token.startsWith("include")) {
                this.appendInclude(page, token);
            } else if (token.startsWith("xml ") || token.startsWith("mso-application ")) {
                page.append("<?");
                page.append(token);
                page.append("?>");
            } else if (token.startsWith("rule")) {
                String ruleName = this.getRuleNamefromToken(token);
                if (!Strings.isValid((String)ruleName)) {
                    throw new OseeArgumentException("no rule name specified in token %s", new Object[]{token});
                }
                AppendableRule<?> rule = this.substitutions.get(ruleName);
                if (rule == null) {
                    throw new OseeArgumentException("no rule was found for token %s", new Object[]{token});
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                this.parseArgumentList(token, attributes);
                try {
                    rule.applyTo(page, (Map<String, String>)attributes);
                }
                catch (IOException ex) {
                    throw new OseeCoreException((Throwable)ex);
                }
            } else {
                AppendableRule<?> rule = this.substitutions.get(token);
                if (rule == null) {
                    throw new OseeArgumentException("no substitution was found for token %s", new Object[]{token});
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                this.parseArgumentList(token, attributes);
                try {
                    rule.applyTo(page, (Map<String, String>)attributes);
                }
                catch (IOException ex) {
                    throw new OseeCoreException((Throwable)ex);
                }
            }
        } else {
            page.append(token);
        }
    }

    private String trimToken(String token) {
        Matcher newLineStartMatcher = newlineStart.matcher(token);
        int beginIndex = newLineStartMatcher.find() ? newLineStartMatcher.end() : 0;
        Matcher newLineEndMatcher = newlineEnd.matcher(token);
        int endIndex = newLineEndMatcher.find() ? newLineEndMatcher.start() : token.length();
        return beginIndex > endIndex ? "" : token.substring(beginIndex, endIndex);
    }

    private boolean parseInclude(String token) {
        boolean toReturn = true;
        Matcher matcher = includeInstructionParseAttribute.matcher(token);
        if (matcher.find()) {
            toReturn = Boolean.parseBoolean(matcher.group(1));
        }
        return toReturn;
    }

    private void handleInclude(StringBuilder substitution, String token) throws IOException {
        this.appendInclude(substitution, token);
        String id = this.getProcessingInstructionId(token);
        if (id != null) {
            this.addKeyValuePair(id, substitution);
        }
    }

    private void appendInclude(Appendable page, String tokenStr) throws IOException {
        Long universalId = this.toUniversalId(tokenStr);
        boolean parseInclude = this.parseInclude(tokenStr);
        ResourceToken token = this.registry.getResourceToken(universalId);
        String name = token.getName();
        if (name.endsWith(".css")) {
            page.append("/* ");
            page.append(name);
            page.append(" */\n");
        } else if (name.endsWith(".html")) {
            page.append("<!-- ");
            page.append(name);
            page.append(" -->\n");
        }
        page.append(this.realizePage(token, parseInclude));
    }

    public String toString() {
        return this.substitutions.toString();
    }

    private String getRuleNamefromToken(String token) {
        String toReturn = "";
        String search = "name=\"";
        int iName = token.indexOf(search);
        if (iName > -1) {
            toReturn = token.substring(iName += search.length());
            int iQuote = toReturn.indexOf("\"");
            toReturn = toReturn.substring(0, iQuote);
        }
        return toReturn;
    }

    private void parseArgumentList(String token, Map<String, String> attributes) {
        StringBuilder working = new StringBuilder(token.trim());
        int iSpace = working.lastIndexOf(" ");
        int iEqual = working.lastIndexOf("=\"");
        int iQuote = working.lastIndexOf("\"");
        String key = "";
        String value = null;
        while (iSpace != -1) {
            if (iQuote < iSpace) {
                key = working.substring(iSpace + 1).trim();
            } else {
                if (iSpace > iEqual) {
                    iSpace = working.substring(0, iEqual).lastIndexOf(" ");
                }
                key = working.substring(iSpace, iEqual).trim();
                value = working.substring(iEqual + 2, working.length() - 1);
            }
            if (!key.equalsIgnoreCase("name")) {
                attributes.put(key, value);
            }
            value = null;
            working.delete(iSpace, working.length());
            iSpace = working.lastIndexOf(" ");
            iEqual = working.lastIndexOf("=\"");
            iQuote = working.lastIndexOf("\"");
        }
    }
}

