/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.operation;

import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.access.object.BranchAccessObject;
import org.eclipse.osee.framework.core.access.operation.AccessCache;
import org.eclipse.osee.framework.core.access.operation.AccessRankOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class BranchAclOperations {
    private final AccessCache cache;
    private final AccessRankOperations rankOps;
    private final IAccessControlService accessService;

    public BranchAclOperations(AccessCache cache, AccessRankOperations rankOps, IAccessControlService accessService) {
        this.cache = cache;
        this.rankOps = rankOps;
        this.accessService = accessService;
    }

    public XResultData hasBranchAclPermission(BranchToken branch, PermissionEnum permission, XResultData rd) {
        return this.hasBranchAclPermission(this.accessService.getUser(), branch, permission, rd);
    }

    public XResultData hasBranchAclPermission(ArtifactToken subject, BranchToken branch, PermissionEnum permission, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        if (branch.isInvalid()) {
            rd.errorf("Branch ACL: Branch [%s] is InValid", new Object[]{branch.getIdString()});
            return rd;
        }
        PermissionEnum accessPermissionEnum = this.getBranchPermission(subject, branch);
        if (!accessPermissionEnum.equals((Object)PermissionEnum.DENY) && permission.getRank() <= accessPermissionEnum.getRank()) {
            rd.logf("Branch ACL: Subject [%s] DOES have [%s] access for branch %s with permission [%s]\n", new Object[]{subject.getName(), permission, branch.toStringWithId(), accessPermissionEnum});
        } else {
            rd.errorf("Branch ACL: Subject [%s] DOES NOT have [%s] access for branch %s; permission [%s]\n", new Object[]{subject.getName(), permission, branch.toStringWithId(), accessPermissionEnum});
        }
        return rd;
    }

    public PermissionEnum getBranchPermission(ArtifactToken subject, BranchToken branch) {
        PermissionEnum userPermission = null;
        BranchAccessObject accessObject = BranchAccessObject.valueOf(branch);
        userPermission = accessObject == null && branch.notEqual(CoreBranches.COMMON) && this.accessService.isBaselineBranch(branch) ? PermissionEnum.READ : (accessObject == null ? PermissionEnum.FULLACCESS : this.rankOps.acquirePermissionRank(subject, accessObject));
        return userPermission;
    }

    public void populateBranchAccessControlListEntry(ArtifactId subjectId, ArtifactTypeToken subjectArtifactType, BranchToken branch, PermissionEnum permission) {
        BranchAccessObject branchAccessObject = BranchAccessObject.valueOf(branch);
        this.cache.accessControlListCache.put((Object)subjectId.getId(), (Object)branchAccessObject, (Object)permission);
        this.cache.objectToSubjectCache.put((Object)branchAccessObject, (Object)subjectId);
        if (subjectArtifactType.inheritsFrom(CoreArtifactTypes.UserGroup)) {
            this.accessService.populateGroupMembers(subjectId);
        }
    }
}

