/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import java.util.Date;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.admin.AccountSession;
import org.eclipse.osee.account.admin.SubscriptionGroup;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.account.admin.internal.AccountArtifact;
import org.eclipse.osee.orcs.account.admin.internal.AccountPreferencesArtifact;
import org.eclipse.osee.orcs.account.admin.internal.AccountSessionImpl;
import org.eclipse.osee.orcs.account.admin.internal.AccountSubscriptionGroupImpl;

public class AccountFactory {
    public ResultSet<Account> newAccountResultSet(ResultSet<ArtifactReadable> results) {
        return ResultSets.transform(results, this::newAccount);
    }

    private Account newAccount(ArtifactReadable account) {
        AccountPreferencesArtifact preferences = new AccountPreferencesArtifact(account.getGuid(), account);
        AccountWebPreferences webPreferences = this.newAccountWebPreferences(account);
        return new AccountArtifact(account, preferences, webPreferences);
    }

    public AccountPreferences newAccountPreferencesResultSet(ArtifactReadable account) {
        return new AccountPreferencesArtifact(account.getGuid(), account);
    }

    public AccountPreferences newAccountPreferences(ArtifactReadable artifact) {
        String id = artifact.getGuid();
        return new AccountPreferencesArtifact(id, artifact);
    }

    public AccountWebPreferences newAccountWebPreferences(ArtifactReadable artifact) {
        String webPreferencesJson = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.WebPreferences, "{}");
        return new AccountWebPreferences(webPreferencesJson, artifact.getName());
    }

    public AccountSession newAccountSession(ArtifactId accountId, String sessionToken, String accessedFrom, String accessDetails) {
        Date currentDate = new Date();
        return this.newAccountSession(accountId, sessionToken, currentDate, currentDate, accessedFrom, accessDetails);
    }

    public AccountSession newAccountSession(ArtifactId accountId, String sessionToken, Date createdOn, Date lastAccessedOn, String accessedFrom, String accessDetails) {
        AccountSessionImpl session = new AccountSessionImpl();
        session.setAccountId(accountId.getId());
        session.setSessionToken(sessionToken);
        session.setCreatedOn(createdOn);
        session.setLastAccessedOn(lastAccessedOn);
        session.setAccessDetails(accessDetails);
        session.setAccessedFrom(accessedFrom);
        return session;
    }

    public SubscriptionGroup newAccountSubscriptionGroup(ArtifactReadable source) {
        return new AccountSubscriptionGroupImpl(source);
    }

    public ResultSet<SubscriptionGroup> newAccountSubscriptionGroupResultSet(ResultSet<ArtifactReadable> results) {
        return ResultSets.transform(results, this::newAccountSubscriptionGroup);
    }
}

