/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.note;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.Date;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteType;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsStateNote {
    @JsonSerialize(using=ToStringSerializer.class)
    private Long id;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long date;
    private Date dateObj;
    private String state;
    private String msg;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long userId;
    private ArtifactToken userTok = ArtifactToken.SENTINEL;
    private String type;

    public AtsStateNote() {
    }

    public AtsStateNote(AtsStateNoteType type, String state, String date, UserId user, String msg) {
        this.id = Lib.generateId();
        this.date = Long.valueOf(date);
        this.state = Strings.intern((String)state);
        this.msg = msg;
        this.userId = user.getId();
        this.type = type.getName();
    }

    public AtsStateNote(String type, String state, String date, UserId user, String msg) {
        this(AtsStateNoteType.valueOf(type), state, date, user, msg);
    }

    @JsonIgnore
    public Date getDateObj() {
        if (this.dateObj == null) {
            this.dateObj = new Date(this.date);
        }
        return this.dateObj;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public void setDateObj(Date date) {
        this.date = date.getTime();
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return String.format("%s from %s%s on %s - %s", this.type, this.getUserName(), this.toStringState(), DateUtil.getMMDDYYHHMM((Date)this.getDateObj()), this.msg);
    }

    private String toStringState() {
        return this.state.isEmpty() ? "" : " for \"" + this.state + "\"";
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public AtsStateNoteType getTypeEnum() {
        return AtsStateNoteType.valueOf(this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toHTML() {
        return this.toString().replaceFirst("^Note: ", "<b>Note:</b>");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public UserId getUser() {
        return UserId.valueOf((Long)this.userId);
    }

    public void setUser(UserId user) {
        this.userId = user.getId();
    }

    @JsonIgnore
    public ArtifactToken getUserTok() {
        return this.userTok;
    }

    public void setUserTok(ArtifactToken userTok) {
        this.userTok = userTok;
    }

    @JsonIgnore
    public String getUserName() {
        return this.userTok.isValid() ? this.userTok.getName() : this.userId.toString();
    }
}

